/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationResult;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Nullable;

public class AllocateUnassignedDecision {
    public static final AllocateUnassignedDecision NOT_TAKEN = new AllocateUnassignedDecision(null, null, null, null, null, null, null);
    private static final Map<UnassignedInfo.AllocationStatus, AllocateUnassignedDecision> CACHED_DECISIONS;
    @Nullable
    private final Decision.Type finalDecision;
    @Nullable
    private final UnassignedInfo.AllocationStatus allocationStatus;
    @Nullable
    private final String finalExplanation;
    @Nullable
    private final String assignedNodeId;
    @Nullable
    private final String allocationId;
    @Nullable
    private final Map<String, NodeAllocationResult> nodeDecisions;
    @Nullable
    private final Decision shardDecision;

    private AllocateUnassignedDecision(Decision.Type finalDecision, UnassignedInfo.AllocationStatus allocationStatus, String finalExplanation, String assignedNodeId, String allocationId, Map<String, NodeAllocationResult> nodeDecisions, Decision shardDecision) {
        assert (assignedNodeId != null || finalDecision == null || finalDecision != Decision.Type.YES) : "a yes decision must have a node to assign the shard to";
        assert (allocationStatus != null || finalDecision == null || finalDecision == Decision.Type.YES) : "only a yes decision should not have an allocation status";
        assert (allocationId == null || assignedNodeId != null) : "allocation id can only be null if the assigned node is null";
        this.finalDecision = finalDecision;
        this.allocationStatus = allocationStatus;
        this.finalExplanation = finalExplanation;
        this.assignedNodeId = assignedNodeId;
        this.allocationId = allocationId;
        this.nodeDecisions = nodeDecisions != null ? Collections.unmodifiableMap(nodeDecisions) : null;
        this.shardDecision = shardDecision;
    }

    public static AllocateUnassignedDecision no(Decision shardDecision, @Nullable String explanation) {
        if (explanation != null) {
            return new AllocateUnassignedDecision(Decision.Type.NO, UnassignedInfo.AllocationStatus.DECIDERS_NO, explanation, null, null, null, shardDecision);
        }
        return AllocateUnassignedDecision.getCachedDecision(UnassignedInfo.AllocationStatus.DECIDERS_NO);
    }

    public static AllocateUnassignedDecision no(UnassignedInfo.AllocationStatus allocationStatus, @Nullable String explanation) {
        return AllocateUnassignedDecision.no(allocationStatus, explanation, null);
    }

    public static AllocateUnassignedDecision no(UnassignedInfo.AllocationStatus allocationStatus, @Nullable String explanation, @Nullable Map<String, Decision> nodeDecisions) {
        Objects.requireNonNull(allocationStatus, "allocationStatus must not be null");
        if (explanation != null) {
            return new AllocateUnassignedDecision(Decision.Type.NO, allocationStatus, explanation, null, null, AllocateUnassignedDecision.asExplanations(nodeDecisions), null);
        }
        return AllocateUnassignedDecision.getCachedDecision(allocationStatus);
    }

    public static AllocateUnassignedDecision throttle(@Nullable String explanation, @Nullable Map<String, Decision> nodeDecisions) {
        if (explanation != null) {
            return new AllocateUnassignedDecision(Decision.Type.THROTTLE, UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED, explanation, null, null, AllocateUnassignedDecision.asExplanations(nodeDecisions), null);
        }
        return AllocateUnassignedDecision.getCachedDecision(UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED);
    }

    public static AllocateUnassignedDecision yes(String assignedNodeId, @Nullable String explanation, @Nullable String allocationId, @Nullable Map<String, Decision> nodeDecisions) {
        Objects.requireNonNull(assignedNodeId, "assignedNodeId must not be null");
        return new AllocateUnassignedDecision(Decision.Type.YES, null, explanation, assignedNodeId, allocationId, AllocateUnassignedDecision.asExplanations(nodeDecisions), null);
    }

    public static AllocateUnassignedDecision fromDecision(Decision decision, @Nullable String assignedNodeId, boolean explain, @Nullable Map<String, NodeAllocationResult> nodeDecisions) {
        Decision.Type decisionType = decision.type();
        UnassignedInfo.AllocationStatus allocationStatus = decisionType != Decision.Type.YES ? UnassignedInfo.AllocationStatus.fromDecision(decisionType) : null;
        String explanation = null;
        if (explain) {
            if (decision.type() == Decision.Type.YES) {
                assert (assignedNodeId != null);
                explanation = "shard assigned to node [" + assignedNodeId + "]";
            } else if (decision.type() == Decision.Type.THROTTLE) {
                assert (assignedNodeId != null);
                explanation = "shard assignment throttled on node [" + assignedNodeId + "]";
            } else {
                explanation = "shard cannot be assigned to any node in the cluster";
            }
        }
        return new AllocateUnassignedDecision(decisionType, allocationStatus, explanation, assignedNodeId, null, nodeDecisions, null);
    }

    private static AllocateUnassignedDecision getCachedDecision(UnassignedInfo.AllocationStatus allocationStatus) {
        AllocateUnassignedDecision decision = CACHED_DECISIONS.get(allocationStatus);
        return Objects.requireNonNull(decision, "precomputed decision not found for " + allocationStatus);
    }

    private static Map<String, NodeAllocationResult> asExplanations(Map<String, Decision> decisionMap) {
        if (decisionMap != null) {
            HashMap<String, NodeAllocationResult> explanationMap = new HashMap<String, NodeAllocationResult>();
            for (Map.Entry<String, Decision> entry : decisionMap.entrySet()) {
                explanationMap.put(entry.getKey(), new NodeAllocationResult(entry.getValue(), Float.POSITIVE_INFINITY));
            }
            return explanationMap;
        }
        return null;
    }

    public boolean isDecisionTaken() {
        return this.finalDecision != null;
    }

    @Nullable
    public Decision.Type getFinalDecisionType() {
        return this.finalDecision;
    }

    public Decision.Type getFinalDecisionSafe() {
        if (!this.isDecisionTaken()) {
            throw new IllegalArgumentException("decision must have been taken in order to return the final decision");
        }
        return this.finalDecision;
    }

    @Nullable
    public UnassignedInfo.AllocationStatus getAllocationStatus() {
        return this.allocationStatus;
    }

    @Nullable
    public String getFinalExplanation() {
        return this.finalExplanation;
    }

    @Nullable
    public String getAssignedNodeId() {
        return this.assignedNodeId;
    }

    @Nullable
    public String getAllocationId() {
        return this.allocationId;
    }

    @Nullable
    public Map<String, NodeAllocationResult> getNodeDecisions() {
        return this.nodeDecisions;
    }

    @Nullable
    public Decision getShardDecision() {
        return this.shardDecision;
    }

    static {
        HashMap<UnassignedInfo.AllocationStatus, AllocateUnassignedDecision> cachedDecisions = new HashMap<UnassignedInfo.AllocationStatus, AllocateUnassignedDecision>();
        cachedDecisions.put(UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, new AllocateUnassignedDecision(Decision.Type.NO, UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, null, null, null, null, null));
        cachedDecisions.put(UnassignedInfo.AllocationStatus.NO_VALID_SHARD_COPY, new AllocateUnassignedDecision(Decision.Type.NO, UnassignedInfo.AllocationStatus.NO_VALID_SHARD_COPY, null, null, null, null, null));
        cachedDecisions.put(UnassignedInfo.AllocationStatus.DECIDERS_NO, new AllocateUnassignedDecision(Decision.Type.NO, UnassignedInfo.AllocationStatus.DECIDERS_NO, null, null, null, null, null));
        cachedDecisions.put(UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED, new AllocateUnassignedDecision(Decision.Type.THROTTLE, UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED, null, null, null, null, null));
        cachedDecisions.put(UnassignedInfo.AllocationStatus.DELAYED_ALLOCATION, new AllocateUnassignedDecision(Decision.Type.NO, UnassignedInfo.AllocationStatus.DELAYED_ALLOCATION, null, null, null, null, null));
        CACHED_DECISIONS = Collections.unmodifiableMap(cachedDecisions);
    }
}

