/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;

public final class CustomAnalyzer
extends Analyzer {
    private final TokenizerFactory tokenizerFactory;
    private final CharFilterFactory[] charFilters;
    private final TokenFilterFactory[] tokenFilters;
    private final int positionIncrementGap;
    private final int offsetGap;

    public CustomAnalyzer(TokenizerFactory tokenizerFactory, CharFilterFactory[] charFilters, TokenFilterFactory[] tokenFilters) {
        this(tokenizerFactory, charFilters, tokenFilters, 0, -1);
    }

    public CustomAnalyzer(TokenizerFactory tokenizerFactory, CharFilterFactory[] charFilters, TokenFilterFactory[] tokenFilters, int positionIncrementGap, int offsetGap) {
        this.tokenizerFactory = tokenizerFactory;
        this.charFilters = charFilters;
        this.tokenFilters = tokenFilters;
        this.positionIncrementGap = positionIncrementGap;
        this.offsetGap = offsetGap;
    }

    public TokenizerFactory tokenizerFactory() {
        return this.tokenizerFactory;
    }

    public TokenFilterFactory[] tokenFilters() {
        return this.tokenFilters;
    }

    public CharFilterFactory[] charFilters() {
        return this.charFilters;
    }

    public int getPositionIncrementGap(String fieldName) {
        return this.positionIncrementGap;
    }

    public int getOffsetGap(String field) {
        if (this.offsetGap < 0) {
            return super.getOffsetGap(field);
        }
        return this.offsetGap;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        Tokenizer tokenizer;
        Tokenizer tokenStream = tokenizer = this.tokenizerFactory.create();
        for (TokenFilterFactory tokenFilter : this.tokenFilters) {
            tokenStream = tokenFilter.create((TokenStream)tokenStream);
        }
        return new Analyzer.TokenStreamComponents(tokenizer, (TokenStream)tokenStream);
    }

    protected Reader initReader(String fieldName, Reader reader) {
        if (this.charFilters != null && this.charFilters.length > 0) {
            for (CharFilterFactory charFilter : this.charFilters) {
                reader = charFilter.create(reader);
            }
        }
        return reader;
    }
}

