/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.query.QueryShardContext;

public class FieldNamesFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_field_names";
    public static final String CONTENT_TYPE = "_field_names";

    private FieldNamesFieldMapper(Settings indexSettings, MappedFieldType existing) {
        this(existing.clone(), indexSettings);
    }

    private FieldNamesFieldMapper(MappedFieldType fieldType, Settings indexSettings) {
        super("_field_names", fieldType, Defaults.FIELD_TYPE, indexSettings);
    }

    @Override
    public FieldNamesFieldType fieldType() {
        return (FieldNamesFieldType)super.fieldType();
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        return null;
    }

    static Iterable<String> extractFieldNames(final String fullPath) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    int endIndex = this.nextEndIndex(0);

                    private int nextEndIndex(int index) {
                        while (index < fullPath.length() && fullPath.charAt(index) != '.') {
                            ++index;
                        }
                        return index;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.endIndex <= fullPath.length();
                    }

                    @Override
                    public String next() {
                        String result = fullPath.substring(0, this.endIndex);
                        this.endIndex = this.nextEndIndex(this.endIndex + 1);
                        return result;
                    }

                    @Override
                    public final void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        if (!this.fieldType().isEnabled()) {
            return;
        }
        for (ParseContext.Document document : context.docs()) {
            ArrayList<String> paths = new ArrayList<String>();
            for (IndexableField field : document.getFields()) {
                paths.add(field.name());
            }
            for (String path : paths) {
                for (String fieldName : FieldNamesFieldMapper.extractFieldNames(path)) {
                    if (this.fieldType().indexOptions() == IndexOptions.NONE && !this.fieldType().stored()) continue;
                    document.add((IndexableField)new Field(this.fieldType().name(), fieldName, (FieldType)this.fieldType()));
                }
            }
        }
    }

    @Override
    protected String contentType() {
        return "_field_names";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.fieldType().isEnabled()) {
            return builder;
        }
        builder.startObject("_field_names");
        if (includeDefaults || !this.fieldType().isEnabled()) {
            builder.field("enabled", this.fieldType().isEnabled());
        }
        builder.endObject();
        return builder;
    }

    public static final class FieldNamesFieldType
    extends TermBasedFieldType {
        private boolean enabled = true;

        public FieldNamesFieldType() {
        }

        protected FieldNamesFieldType(FieldNamesFieldType ref) {
            super(ref);
            this.enabled = ref.enabled;
        }

        @Override
        public FieldNamesFieldType clone() {
            return new FieldNamesFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            FieldNamesFieldType that = (FieldNamesFieldType)((Object)o);
            return this.enabled == that.enabled;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.enabled);
        }

        @Override
        public String typeName() {
            return "_field_names";
        }

        @Override
        public void checkCompatibility(MappedFieldType fieldType, List<String> conflicts, boolean strict) {
            super.checkCompatibility(fieldType, conflicts, strict);
            if (strict) {
                FieldNamesFieldType other = (FieldNamesFieldType)fieldType;
                if (this.isEnabled() != other.isEnabled()) {
                    conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [enabled] across all types.");
                }
            }
        }

        public void setEnabled(boolean enabled) {
            this.checkIfFrozen();
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            if (!this.isEnabled()) {
                throw new IllegalStateException("Cannot run [exists] queries if the [_field_names] field is disabled");
            }
            return super.termQuery(value, context);
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(parserContext.mapperService().fullName("_field_names"));
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("enabled")) continue;
                builder.enabled(XContentMapValues.lenientNodeBooleanValue(fieldNode));
                iterator.remove();
            }
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            Settings indexSettings = context.mapperService().getIndexSettings().getSettings();
            if (fieldType != null) {
                return new FieldNamesFieldMapper(indexSettings, fieldType);
            }
            return (MetadataFieldMapper)this.parse("_field_names", Collections.emptyMap(), context).build(new Mapper.BuilderContext(indexSettings, new ContentPath(1)));
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, FieldNamesFieldMapper> {
        private boolean enabled = true;

        public Builder(MappedFieldType existing) {
            super("_field_names", existing == null ? Defaults.FIELD_TYPE : existing, Defaults.FIELD_TYPE);
        }

        @Override
        @Deprecated
        public Builder index(boolean index) {
            this.enabled(index);
            return (Builder)super.index(index);
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public FieldNamesFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            this.fieldType.setHasDocValues(false);
            FieldNamesFieldType fieldNamesFieldType = (FieldNamesFieldType)this.fieldType;
            fieldNamesFieldType.setEnabled(this.enabled);
            return new FieldNamesFieldMapper(this.fieldType, context.indexSettings());
        }
    }

    public static class Defaults {
        public static final String NAME = "_field_names";
        public static final boolean ENABLED = true;
        public static final MappedFieldType FIELD_TYPE = new FieldNamesFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setName("_field_names");
            FIELD_TYPE.freeze();
        }
    }
}

