/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;

public class TypeQueryBuilder
extends AbstractQueryBuilder<TypeQueryBuilder> {
    public static final String NAME = "type";
    private static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    private final BytesRef type;

    public TypeQueryBuilder(String type) {
        if (type == null) {
            throw new IllegalArgumentException("[type] cannot be null");
        }
        this.type = BytesRefs.toBytesRef(type);
    }

    TypeQueryBuilder(BytesRef type) {
        if (type == null) {
            throw new IllegalArgumentException("[type] cannot be null");
        }
        this.type = type;
    }

    public TypeQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.type = in.readBytesRef();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeBytesRef(this.type);
    }

    public String type() {
        return BytesRefs.toString(this.type);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(VALUE_FIELD.getPreferredName(), this.type.utf8ToString());
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static Optional<TypeQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        BytesRef type = null;
        String queryName = null;
        float boost = 1.0f;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.NAME_FIELD)) {
                    queryName = parser.text();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.BOOST_FIELD)) {
                    boost = parser.floatValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, VALUE_FIELD)) {
                    type = parser.utf8Bytes();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[type] filter doesn't support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[type] filter doesn't support [" + currentFieldName + "]", new Object[0]);
        }
        if (type == null) {
            throw new ParsingException(parser.getTokenLocation(), "[type] filter needs to be provided with a value for the type", new Object[0]);
        }
        return Optional.of(((TypeQueryBuilder)new TypeQueryBuilder(type).boost(boost)).queryName(queryName));
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        DocumentMapper documentMapper = context.getMapperService().documentMapper(this.type.utf8ToString());
        if (documentMapper == null) {
            return new MatchNoDocsQuery();
        }
        return documentMapper.typeFilter();
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.type);
    }

    @Override
    protected boolean doEquals(TypeQueryBuilder other) {
        return Objects.equals(this.type, other.type);
    }
}

