/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.gradle.api.Buildable;
import org.gradle.api.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.artifacts.DefaultResolvedArtifact;
import org.gradle.api.internal.artifacts.attributes.DefaultArtifactAttributes;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.transform.ArtifactAttributeMatcher;
import org.gradle.api.internal.artifacts.transform.ArtifactTransforms;
import org.gradle.api.internal.artifacts.transform.InstantiatingArtifactTransforms;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.DefaultAttributeContainer;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.Pair;
import org.gradle.internal.component.local.model.ComponentFileArtifactIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.resolve.ArtifactResolveException;

public class ArtifactTransformer {
    private final ArtifactTransforms artifactTransforms;
    private final ArtifactAttributeMatcher attributeMatcher;
    private final Map<Pair<File, AttributeContainer>, List<File>> transformedFiles = Maps.newHashMap();
    private final Map<Pair<ResolvedArtifact, AttributeContainer>, List<ResolvedArtifact>> transformedArtifacts = Maps.newHashMap();

    public ArtifactTransformer(ArtifactTransforms artifactTransforms, ArtifactAttributeMatcher attributeMatcher) {
        this.artifactTransforms = artifactTransforms;
        this.attributeMatcher = attributeMatcher;
    }

    public ArtifactTransformer(ResolutionStrategyInternal resolutionStrategy, AttributesSchema attributesSchema) {
        this.attributeMatcher = new ArtifactAttributeMatcher(attributesSchema);
        this.artifactTransforms = new InstantiatingArtifactTransforms(resolutionStrategy, this.attributeMatcher);
    }

    private boolean matchArtifactsAttributes(HasAttributes candidate, AttributeContainer requested) {
        return this.attributeMatcher.attributesMatch(candidate, requested, candidate.getAttributes());
    }

    private Transformer<List<File>, File> getTransform(HasAttributes from, AttributeContainer to) {
        return this.artifactTransforms.getTransform(from.getAttributes(), to);
    }

    public <T extends HasAttributes> Transformer<T, Collection<? extends T>> variantSelector(final AttributeContainer attributes) {
        if (attributes.isEmpty()) {
            return new Transformer<T, Collection<? extends T>>(){

                public T transform(Collection<? extends T> variants) {
                    return (HasAttributes)variants.iterator().next();
                }
            };
        }
        return new Transformer<T, Collection<? extends T>>(){

            public T transform(Collection<? extends T> variants) {
                HasAttributes canTransform = null;
                for (HasAttributes variant : variants) {
                    DefaultAttributeContainer commonAttributes = new DefaultAttributeContainer();
                    HashSet keys = new HashSet(variant.getAttributes().keySet());
                    keys.retainAll(attributes.keySet());
                    for (Attribute attribute : keys) {
                        commonAttributes.attribute(attribute, variant.getAttributes().getAttribute(attribute));
                    }
                    boolean matches = ArtifactTransformer.this.attributeMatcher.attributesMatch(variant, attributes, (AttributeContainer)commonAttributes);
                    if (matches) {
                        return variant;
                    }
                    if (ArtifactTransformer.this.getTransform(variant, attributes) == null) continue;
                    canTransform = variant;
                }
                return canTransform;
            }
        };
    }

    public ArtifactVisitor visitor(ArtifactVisitor visitor, @Nullable AttributeContainerInternal attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return visitor;
        }
        AttributeContainerInternal immutableAttributes = attributes.asImmutable();
        return new ArtifactVisitor((AttributeContainer)immutableAttributes, visitor){
            final /* synthetic */ AttributeContainer val$immutableAttributes;
            final /* synthetic */ ArtifactVisitor val$visitor;
            {
                this.val$immutableAttributes = attributeContainer;
                this.val$visitor = artifactVisitor;
            }

            @Override
            public void visitArtifact(ResolvedArtifact artifact) {
                List transformResults = (List)ArtifactTransformer.this.transformedArtifacts.get(Pair.of((Object)artifact, (Object)this.val$immutableAttributes));
                if (transformResults != null) {
                    for (ResolvedArtifact resolvedArtifact : transformResults) {
                        this.val$visitor.visitArtifact(resolvedArtifact);
                    }
                    return;
                }
                Transformer transform = ArtifactTransformer.this.getTransform((HasAttributes)artifact, this.val$immutableAttributes);
                if (transform == null) {
                    if (ArtifactTransformer.this.matchArtifactsAttributes((HasAttributes)artifact, this.val$immutableAttributes)) {
                        this.val$visitor.visitArtifact(artifact);
                        return;
                    }
                    throw new ArtifactResolveException("Artifact " + artifact + " is not compatible with requested attributes " + this.val$immutableAttributes);
                }
                TaskDependency buildDependencies = ((Buildable)artifact).getBuildDependencies();
                transformResults = Lists.newArrayList();
                List transformedFiles = (List)transform.transform((Object)artifact.getFile());
                for (File output : transformedFiles) {
                    ComponentFileArtifactIdentifier newId = new ComponentFileArtifactIdentifier(artifact.getId().getComponentIdentifier(), output.getName());
                    DefaultIvyArtifactName artifactName = DefaultIvyArtifactName.forAttributeContainer(output.getName(), this.val$immutableAttributes);
                    DefaultResolvedArtifact resolvedArtifact = new DefaultResolvedArtifact(artifact.getModuleVersion().getId(), (IvyArtifactName)artifactName, (ComponentArtifactIdentifier)newId, buildDependencies, output);
                    transformResults.add(resolvedArtifact);
                    this.val$visitor.visitArtifact(resolvedArtifact);
                }
                ArtifactTransformer.this.transformedArtifacts.put(Pair.of((Object)artifact, (Object)this.val$immutableAttributes), transformResults);
            }

            @Override
            public boolean includeFiles() {
                return this.val$visitor.includeFiles();
            }

            @Override
            public void visitFiles(@Nullable ComponentIdentifier componentIdentifier, Iterable<File> files) {
                ArrayList<File> result = new ArrayList<File>();
                RuntimeException transformException = null;
                try {
                    for (File file : files) {
                        try {
                            List transformResults = (List)ArtifactTransformer.this.transformedFiles.get(Pair.of((Object)file, (Object)this.val$immutableAttributes));
                            if (transformResults != null) {
                                result.addAll(transformResults);
                                continue;
                            }
                            AttributeContainer fileWithAttributes = DefaultArtifactAttributes.forFile(file);
                            Transformer transform = ArtifactTransformer.this.getTransform((HasAttributes)fileWithAttributes, this.val$immutableAttributes);
                            if (transform == null) {
                                if (!ArtifactTransformer.this.matchArtifactsAttributes((HasAttributes)fileWithAttributes, this.val$immutableAttributes)) continue;
                                result.add(file);
                                continue;
                            }
                            transformResults = (List)transform.transform((Object)file);
                            ArtifactTransformer.this.transformedFiles.put(Pair.of((Object)file, (Object)this.val$immutableAttributes), transformResults);
                            result.addAll(transformResults);
                        }
                        catch (RuntimeException e) {
                            transformException = e;
                            break;
                        }
                    }
                }
                catch (Throwable t) {
                    this.val$visitor.visitFiles(componentIdentifier, files);
                }
                if (transformException != null) {
                    throw transformException;
                }
                if (!result.isEmpty()) {
                    this.val$visitor.visitFiles(componentIdentifier, result);
                }
            }
        };
    }
}

