/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiImmediateClassType
extends PsiClassType.Stub {
    private final PsiClass myClass;
    private final PsiSubstitutor mySubstitutor;
    private final PsiManager myManager;
    private String myCanonicalText;
    private String myCanonicalTextAnnotated;
    private String myPresentableText;
    private String myInternalCanonicalText;
    private final PsiClassType.ClassResolveResult myClassResolveResult;

    public PsiImmediateClassType(@NotNull PsiClass aClass2, @NotNull PsiSubstitutor substitutor2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        this(aClass2, substitutor2, null, TypeAnnotationProvider.EMPTY);
    }

    public PsiImmediateClassType(@NotNull PsiClass aClass2, @NotNull PsiSubstitutor substitutor2, @Nullable LanguageLevel level) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        this(aClass2, substitutor2, level, TypeAnnotationProvider.EMPTY);
    }

    public PsiImmediateClassType(@NotNull PsiClass aClass2, @NotNull PsiSubstitutor substitutor2, @Nullable LanguageLevel level, PsiAnnotation ... annotations2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        super(level, annotations2);
        this.myClassResolveResult = new PsiClassType.ClassResolveResult(){

            @Override
            public PsiClass getElement() {
                return PsiImmediateClassType.this.myClass;
            }

            @Override
            @NotNull
            public PsiSubstitutor getSubstitutor() {
                PsiSubstitutor psiSubstitutor = PsiImmediateClassType.this.mySubstitutor;
                if (psiSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType$1", "getSubstitutor"));
                }
                return psiSubstitutor;
            }

            @Override
            public boolean isValidResult() {
                return true;
            }

            @Override
            public boolean isAccessible() {
                return true;
            }

            @Override
            public boolean isStaticsScopeCorrect() {
                return true;
            }

            @Override
            public PsiElement getCurrentFileResolveScope() {
                return null;
            }

            @Override
            public boolean isPackagePrefixPackageReference() {
                return false;
            }
        };
        this.myClass = aClass2;
        this.myManager = aClass2.getManager();
        this.mySubstitutor = substitutor2;
        assert (substitutor2.isValid());
    }

    public PsiImmediateClassType(@NotNull PsiClass aClass2, @NotNull PsiSubstitutor substitutor2, @Nullable LanguageLevel level, @NotNull TypeAnnotationProvider provider) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "<init>"));
        }
        super(level, provider);
        this.myClassResolveResult = new /* invalid duplicate definition of identical inner class */;
        this.myClass = aClass2;
        this.myManager = aClass2.getManager();
        this.mySubstitutor = substitutor2;
        assert (substitutor2.isValid());
    }

    @Override
    public PsiClass resolve() {
        return this.myClass;
    }

    @Override
    public String getClassName() {
        return this.myClass.getName();
    }

    @Override
    @NotNull
    public PsiType[] getParameters() {
        PsiTypeParameter[] parameters2 = this.myClass.getTypeParameters();
        if (parameters2.length == 0) {
            if (PsiType.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "getParameters"));
            }
            return PsiType.EMPTY_ARRAY;
        }
        ArrayList<PsiType> lst = new ArrayList<PsiType>();
        for (PsiTypeParameter parameter : parameters2) {
            PsiType substituted = this.mySubstitutor.substitute(parameter);
            if (substituted == null) {
                if (PsiType.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "getParameters"));
                }
                return PsiType.EMPTY_ARRAY;
            }
            lst.add(substituted);
        }
        PsiType[] psiTypeArray = lst.toArray(PsiImmediateClassType.createArray(lst.size()));
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "getParameters"));
        }
        return psiTypeArray;
    }

    @Override
    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        PsiClassType.ClassResolveResult classResolveResult = this.myClassResolveResult;
        if (classResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "resolveGenerics"));
        }
        return classResolveResult;
    }

    @Override
    @NotNull
    public PsiClassType rawType() {
        PsiClassType psiClassType = JavaPsiFacade.getInstance(this.myClass.getProject()).getElementFactory().createType(this.myClass);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "rawType"));
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        if (this.myPresentableText == null) {
            this.myPresentableText = this.getText(TextType.PRESENTABLE, true);
        }
        String string = this.myPresentableText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "getPresentableText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String cached;
        String string = cached = annotated ? this.myCanonicalTextAnnotated : this.myCanonicalText;
        if (cached == null) {
            cached = this.getText(TextType.CANONICAL, annotated);
            if (annotated) {
                this.myCanonicalTextAnnotated = cached;
            } else {
                this.myCanonicalText = cached;
            }
        }
        String string2 = cached;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "getCanonicalText"));
        }
        return string2;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        if (this.myInternalCanonicalText == null) {
            this.myInternalCanonicalText = this.getText(TextType.INT_CANONICAL, true);
        }
        String string = this.myInternalCanonicalText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "getInternalCanonicalText"));
        }
        return string;
    }

    private String getText(@NotNull TextType textType, boolean annotated) {
        if (textType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textType", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "getText"));
        }
        this.mySubstitutor.ensureValid();
        StringBuilder buffer = new StringBuilder();
        this.buildText(this.myClass, this.mySubstitutor, buffer, textType, annotated);
        return buffer.toString();
    }

    private void buildText(@NotNull PsiClass aClass2, @NotNull PsiSubstitutor substitutor2, @NotNull StringBuilder buffer, @NotNull TextType textType, boolean annotated) {
        String prefix;
        String fqn;
        PsiElement parent2;
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "buildText"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "buildText"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "buildText"));
        }
        if (textType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textType", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "buildText"));
        }
        if (aClass2 instanceof PsiAnonymousClass) {
            PsiClassType.ClassResolveResult baseResolveResult = ((PsiAnonymousClass)aClass2).getBaseClassType().resolveGenerics();
            PsiClass baseClass = baseResolveResult.getElement();
            if (baseClass != null) {
                if (textType == TextType.INT_CANONICAL) {
                    buffer.append("anonymous ");
                }
                this.buildText(baseClass, baseResolveResult.getSubstitutor(), buffer, textType, false);
            }
            return;
        }
        boolean qualified = textType != TextType.PRESENTABLE;
        PsiClass enclosingClass = null;
        if (!aClass2.hasModifierProperty("static") && (parent2 = aClass2.getParent()) instanceof PsiClass && !(parent2 instanceof PsiAnonymousClass)) {
            enclosingClass = (PsiClass)parent2;
        }
        if (enclosingClass != null) {
            this.buildText(enclosingClass, substitutor2, buffer, textType, false);
            buffer.append('.');
        } else if (qualified && (fqn = aClass2.getQualifiedName()) != null && !StringUtil.isEmpty(prefix = StringUtil.getPackageName(fqn))) {
            buffer.append(prefix);
            buffer.append('.');
        }
        if (annotated) {
            PsiNameHelper.appendAnnotations(buffer, this.getAnnotations(), qualified);
        }
        buffer.append(aClass2.getName());
        PsiTypeParameter[] typeParameters2 = aClass2.getTypeParameters();
        if (typeParameters2.length > 0) {
            int pos = buffer.length();
            buffer.append('<');
            for (int i = 0; i < typeParameters2.length; ++i) {
                PsiType substitutionResult;
                PsiTypeParameter typeParameter = typeParameters2[i];
                PsiUtilCore.ensureValid(typeParameter);
                if (i > 0) {
                    buffer.append(',');
                    if (textType == TextType.PRESENTABLE) {
                        buffer.append(' ');
                    }
                }
                if ((substitutionResult = substitutor2.substitute(typeParameter)) == null) {
                    buffer.setLength(pos);
                    pos = -1;
                    break;
                }
                PsiUtil.ensureValidType(substitutionResult);
                if (textType == TextType.PRESENTABLE) {
                    buffer.append(substitutionResult.getPresentableText());
                    continue;
                }
                if (textType == TextType.CANONICAL) {
                    buffer.append(substitutionResult.getCanonicalText(annotated));
                    continue;
                }
                buffer.append(substitutionResult.getInternalCanonicalText());
            }
            if (pos >= 0) {
                buffer.append('>');
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.myClass.isValid() && this.mySubstitutor.isValid();
    }

    @Override
    public boolean equalsToText(@NotNull String text2) {
        PsiType patternType;
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "equalsToText"));
        }
        String name2 = this.myClass.getName();
        if (name2 == null || !text2.contains(name2)) {
            return false;
        }
        if (text2.equals(this.getCanonicalText(false))) {
            return true;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(this.myManager.getProject()).getElementFactory();
        try {
            patternType = factory.createTypeFromText(text2, this.myClass);
        }
        catch (IncorrectOperationException e) {
            return false;
        }
        return this.equals(patternType);
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myClass.getResolveScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevel != null ? this.myLanguageLevel : PsiUtil.getLanguageLevel(this.myClass);
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "getLanguageLevel"));
        }
        return languageLevel;
    }

    @Override
    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "setLanguageLevel"));
        }
        PsiImmediateClassType psiImmediateClassType = level.equals((Object)this.myLanguageLevel) ? this : new PsiImmediateClassType(this.myClass, this.mySubstitutor, level, this.getAnnotationProvider());
        if (psiImmediateClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImmediateClassType", "setLanguageLevel"));
        }
        return psiImmediateClassType;
    }

    private static enum TextType {
        PRESENTABLE,
        CANONICAL,
        INT_CANONICAL;

    }
}

