/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.stubs.KotlinAnnotationEntryStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtAnnotationEntry
extends KtElementImplStub<KotlinAnnotationEntryStub>
implements KtCallElement {
    public KtAnnotationEntry(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtAnnotationEntry", "<init>"));
        }
        super(node);
    }

    public KtAnnotationEntry(@NotNull KotlinAnnotationEntryStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/KtAnnotationEntry", "<init>"));
        }
        super(stub, KtStubElementTypes.ANNOTATION_ENTRY);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtAnnotationEntry", "accept"));
        }
        return visitor2.visitAnnotationEntry(this, data2);
    }

    @IfNotParsed
    @Nullable
    public KtTypeReference getTypeReference() {
        KtConstructorCalleeExpression calleeExpression = this.getCalleeExpression();
        if (calleeExpression == null) {
            return null;
        }
        return calleeExpression.getTypeReference();
    }

    @Override
    public KtConstructorCalleeExpression getCalleeExpression() {
        return (KtConstructorCalleeExpression)this.getStubOrPsiChild(KtStubElementTypes.CONSTRUCTOR_CALLEE);
    }

    @Override
    public KtValueArgumentList getValueArgumentList() {
        KotlinAnnotationEntryStub stub = (KotlinAnnotationEntryStub)this.getStub();
        if (stub != null && !stub.hasValueArguments()) {
            return null;
        }
        return (KtValueArgumentList)this.findChildByType(KtNodeTypes.VALUE_ARGUMENT_LIST);
    }

    @Override
    @NotNull
    public List<? extends ValueArgument> getValueArguments() {
        KtValueArgumentList list2 = this.getValueArgumentList();
        List<Object> list3 = list2 != null ? list2.getArguments() : Collections.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtAnnotationEntry", "getValueArguments"));
        }
        return list3;
    }

    @Override
    @NotNull
    public List<KtLambdaArgument> getLambdaArguments() {
        List<KtLambdaArgument> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtAnnotationEntry", "getLambdaArguments"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<KtTypeProjection> getTypeArguments() {
        KtTypeArgumentList typeArgumentList = this.getTypeArgumentList();
        if (typeArgumentList == null) {
            List<KtTypeProjection> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtAnnotationEntry", "getTypeArguments"));
            }
            return list2;
        }
        List<KtTypeProjection> list3 = typeArgumentList.getArguments();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtAnnotationEntry", "getTypeArguments"));
        }
        return list3;
    }

    @Override
    public KtTypeArgumentList getTypeArgumentList() {
        KtTypeReference typeReference = this.getTypeReference();
        if (typeReference == null) {
            return null;
        }
        KtTypeElement typeElement = typeReference.getTypeElement();
        if (typeElement instanceof KtUserType) {
            KtUserType userType = (KtUserType)typeElement;
            return userType.getTypeArgumentList();
        }
        return null;
    }

    @Nullable
    public PsiElement getAtSymbol() {
        return this.findChildByType(KtTokens.AT);
    }

    @Nullable
    public KtAnnotationUseSiteTarget getUseSiteTarget() {
        PsiElement parent2;
        KtAnnotationUseSiteTarget target = this.getStubOrPsiChild(KtStubElementTypes.ANNOTATION_TARGET);
        if (target == null && (parent2 = this.getParentByStub()) instanceof KtAnnotation) {
            return ((KtAnnotation)parent2).getUseSiteTarget();
        }
        return target;
    }
}

