/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.tooling.internal.protocol.BuildExceptionVersion1;
import org.gradle.tooling.internal.protocol.InternalBuildCancelledException;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.provider.BuildActionResult;
import org.gradle.tooling.internal.provider.BuildModelAction;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.tooling.provider.model.UnknownModelException;

public class BuildModelActionRunner
implements BuildActionRunner {
    public void run(BuildAction action, BuildController buildController) {
        if (!(action instanceof BuildModelAction)) {
            return;
        }
        BuildModelAction buildModelAction = (BuildModelAction)action;
        GradleInternal gradle = buildController.getGradle();
        gradle.addBuildListener((BuildListener)new BuildResultAdapter(gradle, buildController, buildModelAction));
        if (buildModelAction.isRunTasks()) {
            buildController.run();
        } else {
            buildController.configure();
        }
    }

    private static class BuildResultAdapter
    extends BuildAdapter {
        private final GradleInternal gradle;
        private final BuildController buildController;
        private final BuildModelAction buildModelAction;

        private BuildResultAdapter(GradleInternal gradle, BuildController buildController, BuildModelAction buildModelAction) {
            this.buildController = buildController;
            this.gradle = gradle;
            this.buildModelAction = buildModelAction;
        }

        public void buildFinished(BuildResult result) {
            if (result.getFailure() == null) {
                this.buildController.setResult((Object)BuildResultAdapter.buildResult(this.gradle, this.buildModelAction));
            }
        }

        private static BuildActionResult buildResult(GradleInternal gradle, BuildModelAction buildModelAction) {
            PayloadSerializer serializer = (PayloadSerializer)gradle.getServices().get(PayloadSerializer.class);
            try {
                Object model = BuildResultAdapter.buildModel(gradle, buildModelAction);
                return new BuildActionResult(serializer.serialize(model), null);
            }
            catch (RuntimeException e) {
                return new BuildActionResult(null, serializer.serialize((Object)e));
            }
        }

        private static Object buildModel(GradleInternal gradle, BuildModelAction buildModelAction) {
            if (!buildModelAction.isRunTasks()) {
                BuildResultAdapter.forceFullConfiguration(gradle);
            }
            String modelName = buildModelAction.getModelName();
            ToolingModelBuilder builder = BuildResultAdapter.getModelBuilder(gradle, modelName);
            return builder.buildAll(modelName, (Project)gradle.getDefaultProject());
        }

        private static void forceFullConfiguration(GradleInternal gradle) {
            try {
                ProjectInternal rootProject = gradle.getRootProject();
                BuildResultAdapter.getProjectConfigurer(gradle).configureHierarchyFully(rootProject);
            }
            catch (BuildCancelledException e) {
                throw new InternalBuildCancelledException((Throwable)e);
            }
            catch (RuntimeException e) {
                throw new BuildExceptionVersion1((Throwable)e);
            }
        }

        private static ProjectConfigurer getProjectConfigurer(GradleInternal gradle) {
            return (ProjectConfigurer)gradle.getServices().get(ProjectConfigurer.class);
        }

        private static ToolingModelBuilder getModelBuilder(GradleInternal gradle, String modelName) {
            ToolingModelBuilderRegistry builderRegistry = BuildResultAdapter.getToolingModelBuilderRegistry(gradle);
            try {
                return builderRegistry.getBuilder(modelName);
            }
            catch (UnknownModelException e) {
                throw (InternalUnsupportedModelException)new InternalUnsupportedModelException().initCause((Throwable)e);
            }
        }

        private static ToolingModelBuilderRegistry getToolingModelBuilderRegistry(GradleInternal gradle) {
            return (ToolingModelBuilderRegistry)gradle.getDefaultProject().getServices().get(ToolingModelBuilderRegistry.class);
        }
    }
}

