/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import java.util.List;
import org.gradle.api.internal.changedetection.changes.IncrementalTaskInputsInternal;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.hash.DefaultFileHasher;
import org.gradle.api.internal.hash.FileHasher;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.ClassSetAnalysisUpdater;
import org.gradle.api.internal.tasks.compile.incremental.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilationInitializer;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilerDecorator;
import org.gradle.api.internal.tasks.compile.incremental.RecompilationSpecProvider;
import org.gradle.api.internal.tasks.compile.incremental.SourceToNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.CachingClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.DefaultClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.cache.CompileCaches;
import org.gradle.api.internal.tasks.compile.incremental.jar.CachingJarSnapshotter;
import org.gradle.api.internal.tasks.compile.incremental.jar.ClasspathJarFinder;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshotFactory;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshotMaker;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.language.base.internal.compile.Compiler;

public class IncrementalCompilerFactory {
    private final IncrementalCompilerDecorator incrementalSupport;
    private final IncrementalTaskInputs inputs;

    public IncrementalCompilerFactory(FileOperations fileOperations, FileHasher snapshotter, String compileDisplayName, CleaningJavaCompiler cleaningJavaCompiler, List<Object> source, CompileCaches compileCaches, IncrementalTaskInputsInternal inputs) {
        this.inputs = inputs;
        DefaultFileHasher hasher = new DefaultFileHasher();
        CachingClassDependenciesAnalyzer analyzer = new CachingClassDependenciesAnalyzer(new DefaultClassDependenciesAnalyzer(), (FileHasher)hasher, compileCaches.getClassAnalysisCache());
        CachingJarSnapshotter jarSnapshotter = new CachingJarSnapshotter(snapshotter, analyzer, compileCaches.getJarSnapshotCache());
        JarClasspathSnapshotMaker jarClasspathSnapshotMaker = new JarClasspathSnapshotMaker(compileCaches.getLocalJarClasspathSnapshotStore(), new JarClasspathSnapshotFactory(jarSnapshotter), new ClasspathJarFinder(fileOperations));
        CompilationSourceDirs sourceDirs = new CompilationSourceDirs(source);
        SourceToNameConverter sourceToNameConverter = new SourceToNameConverter(sourceDirs);
        RecompilationSpecProvider recompilationSpecProvider = new RecompilationSpecProvider(sourceToNameConverter, fileOperations);
        ClassSetAnalysisUpdater classSetAnalysisUpdater = new ClassSetAnalysisUpdater(compileCaches.getLocalClassSetAnalysisStore(), fileOperations, analyzer);
        IncrementalCompilationInitializer compilationInitializer = new IncrementalCompilationInitializer(fileOperations);
        this.incrementalSupport = new IncrementalCompilerDecorator(jarClasspathSnapshotMaker, compileCaches, compilationInitializer, cleaningJavaCompiler, compileDisplayName, recompilationSpecProvider, classSetAnalysisUpdater, sourceDirs);
    }

    public Compiler<JavaCompileSpec> createCompiler() {
        return this.incrementalSupport.prepareCompiler(this.inputs);
    }
}

