/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import javajs.util.AU;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.P4;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.render.ShapeRenderer;
import org.jmol.shape.Mesh;
import org.jmol.util.C;

public abstract class MeshRenderer
extends ShapeRenderer {
    protected Mesh mesh;
    protected T3[] vertices;
    protected short[] normixes;
    protected P3i[] screens;
    protected P3[] p3Screens;
    protected V3[] transformedVectors;
    protected int vertexCount;
    protected float imageFontScaling;
    protected float scalePixelsPerMicron;
    protected int diameter;
    protected float width;
    protected boolean isTranslucent;
    protected boolean frontOnly;
    protected boolean isShell;
    protected boolean antialias;
    protected boolean haveBsDisplay;
    protected boolean selectedPolyOnly;
    protected boolean isGhostPass;
    protected P4 thePlane;
    protected P3 latticeOffset = new P3();
    protected final P3 pt1f = new P3();
    protected final P3 pt2f = new P3();
    protected P3i pt1i = new P3i();
    protected P3i pt2i = new P3i();
    protected final P3i pt3i = new P3i();
    protected int exportPass;
    protected boolean needTranslucent;
    private boolean doRender;
    protected boolean volumeRender;
    protected BS bsPolygons;
    protected boolean isTranslucentInherit;
    protected boolean renderLow;
    protected int meshSlabValue = 100;
    private boolean showTriangles;
    protected boolean forceShowTriangles;
    protected BS bsPolygonsToExport = new BS();

    protected boolean renderMesh2(Mesh mesh) {
        this.mesh = mesh;
        if (!this.setVariables()) {
            return false;
        }
        if (!this.doRender) {
            return mesh.title != null;
        }
        this.latticeOffset.set(0.0f, 0.0f, 0.0f);
        if (mesh.modelIndex < 0 || mesh.lattice == null && mesh.symops == null) {
            int i = this.vertexCount;
            while (--i >= 0) {
                if (this.vertices[i] == null) continue;
                this.tm.transformPtScr(this.vertices[i], this.screens[i]);
            }
            i = this.vertexCount;
            while (--i >= 0) {
                if (this.vertices[i] == null) continue;
                this.tm.transformPtScrT3(this.vertices[i], this.p3Screens[i]);
            }
            this.render2(this.isExport);
        } else {
            P3 vTemp = new P3();
            SymmetryInterface unitcell = mesh.getUnitCell();
            if (unitcell != null) {
                if (mesh.symops != null) {
                    if (mesh.symopNormixes == null) {
                        mesh.symopNormixes = AU.newShort2(mesh.symops.length);
                    }
                    T3[] verticesTemp = null;
                    int max = mesh.symops.length;
                    short c = mesh.colix;
                    int j = max;
                    while (--j >= 0) {
                        short[] normals;
                        M4 m = mesh.symops[j];
                        if (m == null) continue;
                        if (mesh.colorType == 1296041986) {
                            mesh.colix = mesh.symopColixes[j];
                        }
                        boolean needNormals = (normals = mesh.symopNormixes[j]) == null;
                        verticesTemp = needNormals ? new P3[this.vertexCount] : null;
                        int i = this.vertexCount;
                        while (--i >= 0) {
                            vTemp.setT(this.vertices[i]);
                            unitcell.toFractional(vTemp, true);
                            m.rotTrans(vTemp);
                            unitcell.toCartesian(vTemp, true);
                            this.tm.transformPtScr(vTemp, this.screens[i]);
                            if (!needNormals) continue;
                            verticesTemp[i] = vTemp;
                            vTemp = new P3();
                        }
                        if (needNormals) {
                            mesh.symopNormixes[j] = mesh.setNormixes(mesh.getNormals(verticesTemp, null));
                            this.normixes = mesh.symopNormixes[j];
                        } else {
                            mesh.normixes = mesh.symopNormixes[j];
                            this.normixes = mesh.normixes;
                        }
                        this.render2(this.isExport);
                    }
                    mesh.colix = c;
                } else {
                    P3i minXYZ = new P3i();
                    P3i maxXYZ = P3i.new3((int)mesh.lattice.x, (int)mesh.lattice.y, (int)mesh.lattice.z);
                    unitcell.setMinMaxLatticeParameters(minXYZ, maxXYZ);
                    for (int tx = minXYZ.x; tx < maxXYZ.x; ++tx) {
                        for (int ty = minXYZ.y; ty < maxXYZ.y; ++ty) {
                            for (int tz = minXYZ.z; tz < maxXYZ.z; ++tz) {
                                this.latticeOffset.set(tx, ty, tz);
                                unitcell.toCartesian(this.latticeOffset, false);
                                int i = this.vertexCount;
                                while (--i >= 0) {
                                    vTemp.add2(this.vertices[i], this.latticeOffset);
                                    this.tm.transformPtScr(vTemp, this.screens[i]);
                                }
                                this.render2(this.isExport);
                            }
                        }
                    }
                }
            }
        }
        if (this.screens != null) {
            this.vwr.freeTempScreens(this.screens);
        }
        if (this.p3Screens != null) {
            this.vwr.freeTempPoints(this.p3Screens);
        }
        return true;
    }

    private boolean setVariables() {
        if (this.mesh.visibilityFlags == 0) {
            return false;
        }
        boolean bl = this.showTriangles = this.forceShowTriangles || this.mesh.showTriangles;
        if (this.mesh.bsSlabGhost != null) {
            this.g3d.setC(this.mesh.slabColix);
        }
        if (this.mesh.colorsExplicit) {
            this.g3d.setC((short)2047);
        }
        this.isGhostPass = this.mesh.bsSlabGhost != null && (this.isExport ? this.exportPass == 2 : this.vwr.gdata.isPass2);
        this.isTranslucentInherit = this.isGhostPass && C.getColixTranslucent3(this.mesh.slabColix, false, 0.0f) == 1;
        boolean bl2 = this.isTranslucent = this.isGhostPass || C.renderPass2(this.mesh.colix);
        if (this.isTranslucent || this.volumeRender || this.mesh.bsSlabGhost != null) {
            this.needTranslucent = true;
        }
        boolean bl3 = this.doRender = this.setColix(this.mesh.colix) || this.mesh.showContourLines;
        if (!this.doRender || this.isGhostPass && !(this.doRender = this.g3d.setC(this.mesh.slabColix))) {
            this.vertices = this.mesh.vs;
            if (this.needTranslucent) {
                this.g3d.setC(C.getColixTranslucent3((short)4, true, 0.5f));
            }
            return true;
        }
        if (this.mesh.isModelConnected) {
            this.mesh.mat4 = this.ms.am[this.mesh.modelIndex].mat4;
        }
        T3[] t3Array = this.vertices = this.mesh.scale3d == 0.0f && this.mesh.mat4 == null ? this.mesh.vs : this.mesh.getOffsetVertices(this.thePlane);
        if (this.mesh.lineData == null) {
            this.vertexCount = this.mesh.vc;
            if (this.vertexCount == 0) {
                return false;
            }
            this.normixes = this.mesh.normixes;
            if (this.normixes == null && this.mesh.pc >= 0 || this.vertices == null) {
                return false;
            }
            this.haveBsDisplay = this.mesh.bsDisplay != null;
            boolean bl4 = this.selectedPolyOnly = this.isGhostPass || this.mesh.bsSlabDisplay != null;
            this.bsPolygons = this.isGhostPass ? this.mesh.bsSlabGhost : (this.selectedPolyOnly ? this.mesh.bsSlabDisplay : null);
            this.renderLow = !this.isExport && !this.vwr.checkMotionRendering(1073742018);
            boolean allowFrontOnly = !this.mesh.isTwoSided && !this.selectedPolyOnly && (this.meshSlabValue == Integer.MIN_VALUE || this.meshSlabValue >= 100);
            this.frontOnly = this.renderLow || this.mesh.frontOnly && !this.tm.slabEnabled && allowFrontOnly;
            this.isShell = this.mesh.isShell && allowFrontOnly;
            this.screens = this.vwr.allocTempScreens(this.vertexCount);
            this.p3Screens = this.vwr.allocTempPoints(this.vertexCount);
            if (this.frontOnly || this.isShell) {
                this.transformedVectors = this.vwr.gdata.getTransformedVertexVectors();
            }
            if (this.transformedVectors == null) {
                this.isShell = false;
                this.frontOnly = false;
            }
        }
        return true;
    }

    public boolean setColix(short colix) {
        if (this.isGhostPass) {
            return true;
        }
        if (this.volumeRender && !this.isTranslucent) {
            colix = C.getColixTranslucent3(colix, true, 0.8f);
        }
        this.colix = colix;
        if (C.isColixLastAvailable(colix)) {
            this.vwr.gdata.setColor(this.mesh.color);
        }
        return this.g3d.setC(colix);
    }

    protected boolean isPolygonDisplayable(int i) {
        return true;
    }

    protected void render2(boolean generateSet) {
        this.render2b(generateSet);
    }

    protected void render2b(boolean generateSet) {
        if (!this.g3d.setC(this.isGhostPass ? this.mesh.slabColix : this.colix)) {
            return;
        }
        if (this.renderLow || this.mesh.showPoints || this.mesh.pc <= 0) {
            this.renderPoints();
        }
        if (!this.renderLow && (this.isGhostPass ? this.mesh.slabMeshType == 1073742018 : this.mesh.drawTriangles)) {
            this.renderTriangles(false, this.showTriangles, false);
        }
        if (!this.renderLow && this.mesh.pc > 0 && (this.isGhostPass ? this.mesh.slabMeshType == 1073741938 : this.mesh.fillTriangles)) {
            this.renderTriangles(true, this.showTriangles, generateSet);
        }
    }

    protected void renderPoints() {
        if (!this.mesh.isDrawPolygon || this.mesh.pc < 0) {
            int i = this.vertexCount;
            while (--i >= 0) {
                if (this.frontOnly && this.normixes != null && !this.isVisibleNormix(this.normixes[i])) continue;
                this.drawPoint(i, false);
            }
            return;
        }
        int[][] polygonIndexes = this.mesh.pis;
        BS bsPoints = BS.newN(this.mesh.vc);
        if (this.haveBsDisplay) {
            bsPoints.setBits(0, this.mesh.vc);
            bsPoints.andNot(this.mesh.bsDisplay);
        }
        int i = this.mesh.pc;
        while (--i >= 0) {
            if (!this.isPolygonDisplayable(i)) continue;
            int[] p = polygonIndexes[i];
            if (this.frontOnly && !this.isVisibleNormix(this.normixes[i])) continue;
            int j = p.length - 1;
            while (--j >= 0) {
                int pt = p[j];
                if (bsPoints.get(pt)) continue;
                bsPoints.set(pt);
                this.drawPoint(pt, true);
            }
        }
    }

    private void drawPoint(int pt, boolean forTriangle) {
        if (this.renderLow && forTriangle) {
            P3i s = this.screens[pt];
            this.g3d.drawPixel(s.x, s.y, s.z);
        } else if (this.mesh.pc >= 0) {
            this.drawMeshSphere(this.screens[pt]);
        } else {
            this.drawEdge(pt, pt, false, this.vertices[pt], this.vertices[pt], this.screens[pt], null);
        }
    }

    private void drawMeshSphere(P3i pt) {
        this.g3d.fillSphereI(4, pt);
    }

    protected void renderTriangles(boolean fill, boolean iShowTriangles, boolean generateSet) {
        this.g3d.addRenderer(1073742182);
        int[][] polygons = this.mesh.pis;
        short s = this.colix = this.isGhostPass ? this.mesh.slabColix : this.mesh.colix;
        if (this.isTranslucentInherit) {
            this.colix = C.copyColixTranslucency(this.mesh.slabColix, this.mesh.colix);
        }
        this.g3d.setC(this.colix);
        if (generateSet) {
            if (this.frontOnly && fill) {
                this.frontOnly = false;
            }
            this.bsPolygonsToExport.clearAll();
        }
        int i = this.mesh.pc;
        while (--i >= 0) {
            int check;
            if (!this.isPolygonDisplayable(i)) continue;
            int[] polygon = polygons[i];
            int iA = polygon[0];
            int iB = polygon[1];
            int iC = polygon[2];
            if (iShowTriangles) {
                this.setColix((short)(Math.round(Math.random() * 10.0) + 5L));
            }
            if (this.haveBsDisplay && (!this.mesh.bsDisplay.get(iA) || !this.mesh.bsDisplay.get(iB) || !this.mesh.bsDisplay.get(iC))) continue;
            if (iB == iC) {
                this.drawEdge(iA, iB, fill, this.vertices[iA], this.vertices[iB], this.screens[iA], this.screens[iB]);
                continue;
            }
            if (this.mesh.isDrawPolygon) {
                short normix = this.normixes[i];
                if (this.frontOnly && !this.isVisibleNormix(normix)) continue;
                if (fill) {
                    this.g3d.fillTriangle3CNBits(this.p3Screens[iA], this.colix, normix, this.p3Screens[iB], this.colix, normix, this.p3Screens[iC], this.colix, normix, true);
                    continue;
                }
                check = polygon[3];
                if (iShowTriangles) {
                    check = 7;
                }
                if ((check & 1) == 1) {
                    this.drawEdge(iA, iB, true, this.vertices[iA], this.vertices[iB], this.screens[iA], this.screens[iB]);
                }
                if ((check & 2) == 2) {
                    this.drawEdge(iB, iC, true, this.vertices[iB], this.vertices[iC], this.screens[iB], this.screens[iC]);
                }
                if ((check & 4) != 4) continue;
                this.drawEdge(iA, iC, true, this.vertices[iA], this.vertices[iC], this.screens[iA], this.screens[iC]);
                continue;
            }
            short nA = this.normixes[iA];
            short nB = this.normixes[iB];
            short nC = this.normixes[iC];
            int n = check = this.frontOnly || this.isShell ? this.checkFront(nA, nB, nC) : 7;
            if (fill && check != 7) continue;
            switch (polygon.length) {
                case 3: {
                    if (fill) {
                        if (generateSet) {
                            this.bsPolygonsToExport.set(i);
                            break;
                        }
                        this.g3d.fillTriangle3CNBits(this.p3Screens[iA], this.colix, nA, this.p3Screens[iB], this.colix, nB, this.p3Screens[iC], this.colix, nC, false);
                        break;
                    }
                    this.drawTriangleBits(this.p3Screens[iA], this.colix, this.p3Screens[iB], this.colix, this.p3Screens[iC], this.colix, check, 1);
                    break;
                }
                case 4: {
                    int iD = polygon[3];
                    short nD = this.normixes[iD];
                    if (this.frontOnly && (check != 7 || !this.isVisibleNormix(nD))) break;
                    if (fill) {
                        if (generateSet) {
                            this.bsPolygonsToExport.set(i);
                            break;
                        }
                        this.g3d.fillTriangle3CNBits(this.p3Screens[iA], this.colix, nA, this.p3Screens[iB], this.colix, nB, this.p3Screens[iC], this.colix, nC, false);
                        this.g3d.fillTriangle3CNBits(this.p3Screens[iA], this.colix, nA, this.p3Screens[iC], this.colix, nC, this.p3Screens[iD], this.colix, nD, false);
                        break;
                    }
                    this.vwr.gdata.drawQuadrilateralBits(this.g3d, this.colix, this.p3Screens[iA], this.p3Screens[iB], this.p3Screens[iC], this.p3Screens[iD]);
                }
            }
        }
        if (generateSet) {
            this.exportSurface(this.colix);
        }
    }

    protected boolean isVisibleNormix(short normix) {
        return normix < 0 || this.transformedVectors[normix].z >= 0.0f;
    }

    private void drawTriangleBits(P3 screenA, short colixA, P3 screenB, short colixB, P3 screenC, short colixC, int check, int diam) {
        if (!this.antialias && diam == 1) {
            this.vwr.gdata.drawTriangleBits(this.g3d, screenA, colixA, screenB, colixB, screenC, colixC, check);
            return;
        }
        if (this.antialias) {
            diam <<= 1;
        }
        if ((check & 1) == 1) {
            this.g3d.fillCylinderBits2(colixA, colixB, (byte)1, diam, screenA, screenB);
        }
        if ((check & 2) == 2) {
            this.g3d.fillCylinderBits2(colixB, colixC, (byte)1, diam, screenB, screenC);
        }
        if ((check & 4) == 4) {
            this.g3d.fillCylinderBits2(colixA, colixC, (byte)1, diam, screenA, screenC);
        }
    }

    protected void drawTriangle(P3i screenA, short colixA, P3i screenB, short colixB, P3i screenC, short colixC, int check, int diam) {
        if (!this.antialias && diam == 1) {
            this.g3d.drawTriangle3C(screenA, colixA, screenB, colixB, screenC, colixC, check);
            return;
        }
        if (this.antialias) {
            diam <<= 1;
        }
        if ((check & 1) == 1) {
            this.g3d.fillCylinderXYZ(colixA, colixB, (byte)1, diam, screenA.x, screenA.y, screenA.z, screenB.x, screenB.y, screenB.z);
        }
        if ((check & 2) == 2) {
            this.g3d.fillCylinderXYZ(colixB, colixC, (byte)1, diam, screenB.x, screenB.y, screenB.z, screenC.x, screenC.y, screenC.z);
        }
        if ((check & 4) == 4) {
            this.g3d.fillCylinderXYZ(colixA, colixC, (byte)1, diam, screenA.x, screenA.y, screenA.z, screenC.x, screenC.y, screenC.z);
        }
    }

    protected int checkFront(short nA, short nB, short nC) {
        int check = 7;
        if (this.transformedVectors[nA].z < 0.0f) {
            check ^= 1;
        }
        if (this.transformedVectors[nB].z < 0.0f) {
            check ^= 2;
        }
        if (this.transformedVectors[nC].z < 0.0f) {
            check ^= 4;
        }
        return check;
    }

    protected void drawEdge(int iA, int iB, boolean fill, T3 vA, T3 vB, P3i sA, P3i sB) {
        byte endCap;
        byte by = iA != iB && !fill ? (byte)0 : (endCap = this.width < 0.0f || (double)this.width == -0.0 || iA != iB && this.isTranslucent ? (byte)2 : 3);
        if (this.width == 0.0f) {
            if (this.diameter == 0) {
                int n = this.mesh.diameter > 0 ? this.mesh.diameter : (this.diameter = iA == iB ? 7 : 3);
            }
            if (this.exportType == 1) {
                this.pt1f.ave(vA, vB);
                this.tm.transformPtScr(this.pt1f, this.pt1i);
            }
            if (iA == iB) {
                this.pt1f.set(sA.x, sA.y, sA.z);
                this.g3d.fillSphereBits(this.diameter, this.pt1f);
                return;
            }
        } else {
            this.pt1f.ave(vA, vB);
            this.tm.transformPtScr(this.pt1f, this.pt1i);
            int mad = (int)Math.floor(Math.abs(this.width) * 1000.0f);
            this.diameter = (int)this.vwr.tm.scaleToScreen(this.pt1i.z, mad);
        }
        if (this.diameter == 0) {
            this.diameter = 1;
        }
        this.tm.transformPt3f(vA, this.pt1f);
        this.tm.transformPt3f(vB, this.pt2f);
        this.g3d.fillCylinderBits(endCap, this.diameter, this.pt1f, this.pt2f);
    }

    protected void exportSurface(short colix) {
        this.mesh.normals = this.mesh.getNormals(this.vertices, null);
        this.mesh.bsPolygons = this.bsPolygonsToExport;
        this.mesh.offset = this.latticeOffset;
        this.g3d.drawSurface(this.mesh, colix);
        this.mesh.normals = null;
        this.mesh.bsPolygons = null;
    }
}

