/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.cache;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.JCSCachedTileLoaderJob;

public class HostLimitQueue
extends LinkedBlockingDeque<Runnable> {
    private static final long serialVersionUID = 1L;
    private final Map<String, Semaphore> hostSemaphores = new ConcurrentHashMap<String, Semaphore>();
    private final int hostLimit;

    public HostLimitQueue(int n) {
        this.hostLimit = n;
    }

    private JCSCachedTileLoaderJob<?, ?> findJob() {
        for (Runnable runnable : this) {
            if (!(runnable instanceof JCSCachedTileLoaderJob)) continue;
            JCSCachedTileLoaderJob jCSCachedTileLoaderJob = (JCSCachedTileLoaderJob)runnable;
            if (this.tryAcquireSemaphore(jCSCachedTileLoaderJob)) {
                if (this.remove(jCSCachedTileLoaderJob)) {
                    return jCSCachedTileLoaderJob;
                }
                this.releaseSemaphore(jCSCachedTileLoaderJob);
                continue;
            }
            URL uRL = null;
            try {
                uRL = jCSCachedTileLoaderJob.getUrl();
            }
            catch (IOException iOException) {
                Main.debug(iOException);
            }
            Main.debug("TMS - Skipping job {0} because host limit reached", uRL);
        }
        return null;
    }

    @Override
    public Runnable poll(long l, TimeUnit timeUnit) throws InterruptedException {
        Runnable runnable = this.findJob();
        if (runnable != null) {
            return runnable;
        }
        runnable = (Runnable)this.pollFirst(l, timeUnit);
        if (runnable != null) {
            this.acquireSemaphore(runnable);
        }
        return runnable;
    }

    @Override
    public Runnable take() throws InterruptedException {
        Runnable runnable = this.findJob();
        if (runnable != null) {
            return runnable;
        }
        runnable = (Runnable)this.takeFirst();
        this.acquireSemaphore(runnable);
        return runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Semaphore getSemaphore(JCSCachedTileLoaderJob<?, ?> jCSCachedTileLoaderJob) {
        String string;
        try {
            string = jCSCachedTileLoaderJob.getUrl().getHost();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
        Semaphore semaphore = this.hostSemaphores.get(string);
        if (semaphore == null) {
            Map<String, Semaphore> map = this.hostSemaphores;
            synchronized (map) {
                semaphore = this.hostSemaphores.get(string);
                if (semaphore == null) {
                    semaphore = new Semaphore(this.hostLimit);
                    this.hostSemaphores.put(string, semaphore);
                }
            }
        }
        return semaphore;
    }

    private void acquireSemaphore(Runnable runnable) throws InterruptedException {
        if (runnable instanceof JCSCachedTileLoaderJob) {
            JCSCachedTileLoaderJob jCSCachedTileLoaderJob = (JCSCachedTileLoaderJob)runnable;
            this.getSemaphore(jCSCachedTileLoaderJob).acquire();
            jCSCachedTileLoaderJob.setFinishedTask(() -> this.releaseSemaphore(jCSCachedTileLoaderJob));
        }
    }

    private boolean tryAcquireSemaphore(JCSCachedTileLoaderJob<?, ?> jCSCachedTileLoaderJob) {
        boolean bl = true;
        Semaphore semaphore = this.getSemaphore(jCSCachedTileLoaderJob);
        if (semaphore != null && (bl = semaphore.tryAcquire())) {
            jCSCachedTileLoaderJob.setFinishedTask(() -> this.releaseSemaphore(jCSCachedTileLoaderJob));
        }
        return bl;
    }

    private void releaseSemaphore(JCSCachedTileLoaderJob<?, ?> jCSCachedTileLoaderJob) {
        Semaphore semaphore = this.getSemaphore(jCSCachedTileLoaderJob);
        if (semaphore != null) {
            semaphore.release();
            if (semaphore.availablePermits() > this.hostLimit) {
                Main.warn("More permits than it should be");
            }
        }
    }
}

