/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.Arrays;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.gui.mappaint.DividedScale;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.StyleElementList;
import org.openstreetmap.josm.tools.Pair;

public final class StyleCache {
    private static final Storage<StyleCache> internPool = new Storage();
    public static final StyleCache EMPTY_STYLECACHE = new StyleCache().intern();
    private static final int PLAIN = 0;
    private static final int SELECTED = 1;
    private final DividedScale<StyleElementList>[] states = new DividedScale[2];

    private StyleCache(StyleCache styleCache) {
        this.states[0] = styleCache.states[0];
        this.states[1] = styleCache.states[1];
    }

    private StyleCache() {
    }

    public StyleCache put(StyleElementList styleElementList, Range range, boolean bl) {
        StyleCache styleCache = new StyleCache(this);
        int n = StyleCache.getIndex(bl);
        DividedScale<StyleElementList> dividedScale = styleCache.states[n];
        if (dividedScale == null) {
            dividedScale = new DividedScale();
        }
        styleCache.states[n] = dividedScale.put(styleElementList, range);
        return styleCache.intern();
    }

    public Pair<StyleElementList, Range> getWithRange(double d, boolean bl) {
        int n = StyleCache.getIndex(bl);
        if (this.states[n] == null) {
            return Pair.create(null, Range.ZERO_TO_INFINITY);
        }
        return this.states[n].getWithRange(d);
    }

    private static int getIndex(boolean bl) {
        return bl ? 1 : 0;
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.states);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StyleCache styleCache = (StyleCache)object;
        return Arrays.deepEquals(this.states, styleCache.states);
    }

    private StyleCache intern() {
        return internPool.putUnique(this);
    }

    public static int getInternPoolSize() {
        return internPool.size();
    }
}

