/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.auth;

import java.awt.Component;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Objects;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.auth.CredentialsAgent;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;
import org.openstreetmap.josm.io.auth.JosmPreferencesCredentialAgent;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class CredentialsManager
implements CredentialsAgent {
    private static volatile CredentialsManager instance;
    private static CredentialsAgentFactory agentFactory;
    private final CredentialsAgent delegate;

    public static CredentialsManager getInstance() {
        if (instance == null) {
            CredentialsAgent credentialsAgent = agentFactory == null ? new JosmPreferencesCredentialAgent() : agentFactory.getCredentialsAgent();
            instance = new CredentialsManager(credentialsAgent);
        }
        return instance;
    }

    public static void registerCredentialsAgentFactory(CredentialsAgentFactory credentialsAgentFactory) {
        agentFactory = credentialsAgentFactory;
        instance = null;
    }

    public CredentialsManager(CredentialsAgent credentialsAgent) {
        CheckParameterUtil.ensureParameterNotNull(credentialsAgent, "delegate");
        this.delegate = credentialsAgent;
    }

    public final Class<? extends CredentialsAgent> getCredentialsAgentClass() {
        return this.delegate.getClass();
    }

    public String getUsername() {
        return this.getUsername(OsmApi.getOsmApi().getHost());
    }

    public String getUsername(String string) {
        String string2 = null;
        try {
            PasswordAuthentication passwordAuthentication = this.lookup(Authenticator.RequestorType.SERVER, string);
            if (passwordAuthentication != null) {
                string2 = passwordAuthentication.getUserName();
            }
        }
        catch (CredentialsAgentException credentialsAgentException) {
            Main.debug(credentialsAgentException);
            return null;
        }
        if (string2 == null) {
            return null;
        }
        return (string2 = string2.trim()).isEmpty() ? null : string2;
    }

    @Override
    public PasswordAuthentication lookup(Authenticator.RequestorType requestorType, String string) throws CredentialsAgentException {
        return this.delegate.lookup(requestorType, string);
    }

    @Override
    public void store(Authenticator.RequestorType requestorType, String string, PasswordAuthentication passwordAuthentication) throws CredentialsAgentException {
        String string2;
        if (requestorType == Authenticator.RequestorType.SERVER && Objects.equals(OsmApi.getOsmApi().getHost(), string) && (string2 = passwordAuthentication.getUserName()) != null && !string2.trim().isEmpty()) {
            JosmUserIdentityManager.getInstance().setPartiallyIdentified(string2);
        }
        this.delegate.store(requestorType, string, passwordAuthentication);
    }

    @Override
    public CredentialsAgentResponse getCredentials(Authenticator.RequestorType requestorType, String string, boolean bl) throws CredentialsAgentException {
        return this.delegate.getCredentials(requestorType, string, bl);
    }

    @Override
    public OAuthToken lookupOAuthAccessToken() throws CredentialsAgentException {
        return this.delegate.lookupOAuthAccessToken();
    }

    @Override
    public void storeOAuthAccessToken(OAuthToken oAuthToken) throws CredentialsAgentException {
        this.delegate.storeOAuthAccessToken(oAuthToken);
    }

    @Override
    public Component getPreferencesDecorationPanel() {
        return this.delegate.getPreferencesDecorationPanel();
    }

    @FunctionalInterface
    public static interface CredentialsAgentFactory {
        public CredentialsAgent getCredentialsAgent();
    }
}

