/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.core.cast.NumericToFloatNode;
import org.jruby.truffle.core.cast.NumericToFloatNodeGen;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;

@NodeChild(value="duration")
public abstract class DurationToMillisecondsNode
extends RubyNode {
    @Node.Child
    NumericToFloatNode floatCastNode;
    private final ConditionProfile durationLessThanZeroProfile = ConditionProfile.createBinaryProfile();
    private final boolean acceptsNil;

    public DurationToMillisecondsNode(boolean acceptsNil) {
        this.acceptsNil = acceptsNil;
    }

    public abstract long executeDurationToMillis(VirtualFrame var1, Object var2);

    @Specialization
    public long noDuration(NotProvided duration) {
        return Long.MAX_VALUE;
    }

    @Specialization
    public long duration(int duration) {
        return this.validate((long)duration * 1000L);
    }

    @Specialization
    public long duration(long duration) {
        return this.validate(duration * 1000L);
    }

    @Specialization
    public long duration(double duration) {
        return this.validate((long)(duration * 1000.0));
    }

    @Specialization(guards={"isRubiniusUndefined(duration)"})
    public long duration(DynamicObject duration) {
        return this.noDuration(NotProvided.INSTANCE);
    }

    @Specialization(guards={"isNil(duration)"})
    public long durationNil(DynamicObject duration) {
        if (this.acceptsNil) {
            return this.noDuration(NotProvided.INSTANCE);
        }
        throw new RaiseException(this.coreExceptions().typeError("TypeError: can't convert NilClass into time interval", this));
    }

    @Specialization(guards={"!isRubiniusUndefined(duration)", "!isNil(duration)"})
    public long duration(VirtualFrame frame, DynamicObject duration) {
        if (this.floatCastNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.floatCastNode = this.insert(NumericToFloatNodeGen.create(this.getContext(), null, "to_f", null));
        }
        return this.duration(this.floatCastNode.executeDouble(frame, duration));
    }

    private long validate(long durationInMillis) {
        if (this.durationLessThanZeroProfile.profile(durationInMillis < 0L)) {
            throw new RaiseException(this.coreExceptions().argumentErrorTimeItervalPositive(this));
        }
        return durationInMillis;
    }
}

