/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.List;

public abstract class PsiRecursiveElementVisitor
extends PsiElementVisitor {
    private final boolean myVisitAllFileRoots;

    protected PsiRecursiveElementVisitor() {
        this(false);
    }

    protected PsiRecursiveElementVisitor(boolean visitAllFileRoots) {
        this.myVisitAllFileRoots = visitAllFileRoots;
    }

    @Override
    public void visitElement(PsiElement element) {
        ProgressIndicatorProvider.checkCanceled();
        element.acceptChildren(this);
    }

    @Override
    public void visitFile(PsiFile file) {
        FileViewProvider viewProvider;
        List<PsiFile> allFiles;
        if (this.myVisitAllFileRoots && (allFiles = (viewProvider = file.getViewProvider()).getAllFiles()).size() > 1 && file == viewProvider.getPsi(viewProvider.getBaseLanguage())) {
            for (PsiFile lFile : allFiles) {
                ProgressIndicatorProvider.checkCanceled();
                lFile.acceptChildren(this);
            }
            return;
        }
        super.visitFile(file);
    }
}

