/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

public class ComparableEvent
implements Comparable<ComparableEvent> {
    public int outcome;
    public int[] predIndexes;
    public int seen = 1;
    public float[] values;

    public ComparableEvent(int oc, int[] pids, float[] values) {
        this.outcome = oc;
        this.values = values;
        this.predIndexes = pids;
    }

    public ComparableEvent(int oc, int[] pids) {
        this(oc, pids, null);
    }

    @Override
    public int compareTo(ComparableEvent ce) {
        if (this.outcome < ce.outcome) {
            return -1;
        }
        if (this.outcome > ce.outcome) {
            return 1;
        }
        int smallerLength = this.predIndexes.length > ce.predIndexes.length ? ce.predIndexes.length : this.predIndexes.length;
        for (int i = 0; i < smallerLength; ++i) {
            if (this.predIndexes[i] < ce.predIndexes[i]) {
                return -1;
            }
            if (this.predIndexes[i] > ce.predIndexes[i]) {
                return 1;
            }
            if (this.values != null && ce.values != null) {
                if (this.values[i] < ce.values[i]) {
                    return -1;
                }
                if (!(this.values[i] > ce.values[i])) continue;
                return 1;
            }
            if (this.values != null) {
                if (this.values[i] < 1.0f) {
                    return -1;
                }
                if (!(this.values[i] > 1.0f)) continue;
                return 1;
            }
            if (ce.values == null) continue;
            if (1.0f < ce.values[i]) {
                return -1;
            }
            if (!(1.0f > ce.values[i])) continue;
            return 1;
        }
        if (this.predIndexes.length < ce.predIndexes.length) {
            return -1;
        }
        if (this.predIndexes.length > ce.predIndexes.length) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append(this.outcome).append(":");
        for (int i = 0; i < this.predIndexes.length; ++i) {
            s.append(" ").append(this.predIndexes[i]);
            if (this.values == null) continue;
            s.append("=").append(this.values[i]);
        }
        return s.toString();
    }

    private void sort(int[] pids, float[] values) {
        for (int mi = 0; mi < pids.length; ++mi) {
            int min = mi;
            for (int pi = mi + 1; pi < pids.length; ++pi) {
                if (pids[min] <= pids[pi]) continue;
                min = pi;
            }
            int pid = pids[mi];
            pids[mi] = pids[min];
            pids[min] = pid;
            float val = values[mi];
            values[mi] = values[min];
            values[min] = val;
        }
    }
}

