/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.sun.net.httpserver.HttpExchange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.RuleMatch;
import org.languagetool.server.AtDXmlSerializer;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.ServerTools;
import org.languagetool.server.TextChecker;
import org.languagetool.tools.RuleMatchAsXmlSerializer;

class V1TextChecker
extends TextChecker {
    private static final String XML_CONTENT_TYPE = "text/xml; charset=UTF-8";

    static String getDeprecationWarning() {
        return "<!-- ***** -->\n<!-- WARNING: this API is deprecated and will be turned off - see https://languagetool.org/http-api/migration.php for details -->\n<!-- ***** -->";
    }

    V1TextChecker(HTTPServerConfig config, boolean internalServer) {
        super(config, internalServer);
    }

    @Override
    protected void setHeaders(HttpExchange httpExchange) {
        ServerTools.setCommonHeaders(httpExchange, XML_CONTENT_TYPE, this.config.allowOriginUrl);
    }

    @Override
    protected String getResponse(String text, Language lang, Language motherTongue, List<RuleMatch> matches) {
        if (this.config.getMode() == HTTPServerConfig.Mode.AfterTheDeadline) {
            AtDXmlSerializer serializer = new AtDXmlSerializer();
            return serializer.ruleMatchesToXml(matches, text);
        }
        RuleMatchAsXmlSerializer serializer = new RuleMatchAsXmlSerializer();
        String xml = serializer.ruleMatchesToXml(matches, text, 40, lang, motherTongue);
        return xml.replaceFirst("\\?>", "?>\n" + V1TextChecker.getDeprecationWarning());
    }

    @Override
    @NotNull
    protected List<String> getEnabledRuleIds(Map<String, String> parameters) {
        String enabledParam = parameters.get("enabled");
        ArrayList<String> enabledRules = new ArrayList<String>();
        if (enabledParam != null) {
            enabledRules.addAll(Arrays.asList(enabledParam.split(",")));
        }
        return enabledRules;
    }

    @Override
    @NotNull
    protected List<String> getDisabledRuleIds(Map<String, String> parameters) {
        return this.getCommaSeparatedStrings("disabled", parameters);
    }

    @Override
    protected boolean getLanguageAutoDetect(Map<String, String> parameters) {
        boolean autoDetect;
        if (this.config.getMode() == HTTPServerConfig.Mode.AfterTheDeadline) {
            return "true".equals(parameters.get("guess"));
        }
        boolean bl = autoDetect = "1".equals(parameters.get("autodetect")) || "yes".equals(parameters.get("autodetect"));
        if (parameters.get("language") == null && !autoDetect) {
            throw new IllegalArgumentException("Missing 'language' parameter. Specify language or use 'autodetect=yes' for auto-detecting the language of the input text.");
        }
        return autoDetect;
    }

    @Override
    @NotNull
    protected Language getLanguage(String text, Map<String, String> parameters, List<String> preferredVariants) {
        Language lang;
        if (this.getLanguageAutoDetect(parameters)) {
            lang = this.detectLanguageOfString(text, parameters.get("language"), preferredVariants);
        } else if (this.config.getMode() == HTTPServerConfig.Mode.AfterTheDeadline) {
            lang = this.config.getAfterTheDeadlineLanguage();
            if (lang == null) {
                throw new RuntimeException("In AfterTheDeadline mode but AfterTheDeadline language not set");
            }
        } else {
            lang = Languages.getLanguageForShortCode(parameters.get("language"));
        }
        return lang;
    }

    @Override
    @NotNull
    protected List<String> getPreferredVariants(Map<String, String> parameters) {
        List<String> preferredVariants;
        if (parameters.get("preferredvariants") != null) {
            preferredVariants = Arrays.asList(parameters.get("preferredvariants").split(",\\s*"));
            if (!this.getLanguageAutoDetect(parameters)) {
                throw new IllegalArgumentException("You specified 'preferredvariants' but you didn't specify 'autodetect=yes'");
            }
        } else {
            preferredVariants = Collections.emptyList();
        }
        return preferredVariants;
    }
}

