/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ilirepository.impl;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.tools.StringUtility;
import ch.ehi.iox.ilisite.ILIREPOSITORY09;
import ch.ehi.iox.ilisite.IliRepository09.ModelName_;
import ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata;
import ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata_SchemaLanguage;
import ch.interlis.ili2c.ModelScan;
import ch.interlis.ili2c.modelscan.IliFile;
import ch.interlis.ili2c.modelscan.IliModel;
import ch.interlis.ilirepository.IliFiles;
import ch.interlis.ilirepository.IliResolver;
import ch.interlis.ilirepository.IliSite;
import ch.interlis.ilirepository.impl.RepositoryAccessException;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.xtf.XtfReader;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.ObjectEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class RepositoryAccess {
    private HashMap<String, IliFiles> reposIliFiles = new HashMap();
    private HashMap<String, IliSite> reposIliSite = new HashMap();
    private long metaMaxTTL = 86400000L;
    private File localCache = new File(System.getProperty("user.home"), ".ilicache");
    private IliResolver resolver = null;

    public IliResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(IliResolver resolver) {
        this.resolver = resolver;
    }

    public void setCache(File localdir) {
        this.localCache = localdir;
    }

    public void setIliFiles(String uri, IliFiles iliFiles) {
        this.reposIliFiles.put(uri, iliFiles);
    }

    public IliFiles getIliFiles(String uri) {
        IliFiles iliFiles;
        if (!this.reposIliFiles.containsKey(uri)) {
            if (this.isLegacyDir(uri)) {
                try {
                    EhiLogger.traceState("scan ili-files in folder <" + uri + ">...");
                    HashSet files = ModelScan.scanIliFileDir(new File(uri), null);
                    Iterator filei = files.iterator();
                    IliFiles iliFiles2 = new IliFiles();
                    while (filei.hasNext()) {
                        iliFiles2.addFile((IliFile)filei.next());
                    }
                    this.reposIliFiles.put(uri, iliFiles2);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            try {
                EhiLogger.traceState("read ilimodels.xml from <" + uri + ">...");
                iliFiles = this.readIliModelsXml(uri);
            }
            catch (RepositoryAccessException e) {
                this.handleRepositoryAccessException(e, uri);
                iliFiles = null;
            }
            this.reposIliFiles.put(uri, iliFiles);
        }
        iliFiles = this.reposIliFiles.get(uri);
        return iliFiles;
    }

    public IliSite getIliSite(String uri) {
        IliSite iliSite;
        if (!this.reposIliSite.containsKey(uri)) {
            try {
                EhiLogger.traceState("read ilisite.xml from <" + uri + ">...");
                iliSite = this.readIliSiteXml(uri);
            }
            catch (RepositoryAccessException e) {
                this.handleRepositoryAccessException(e, uri);
                iliSite = null;
            }
            this.reposIliSite.put(uri, iliSite);
        }
        iliSite = this.reposIliSite.get(uri);
        return iliSite;
    }

    private void handleRepositoryAccessException(RepositoryAccessException e, String uri) {
        if (this.reposIliSite.containsKey(uri) && this.reposIliFiles.containsKey(uri)) {
            return;
        }
        EhiLogger.logAdaption("repository <" + uri + "> ignored; " + e.getCause());
        if (!this.reposIliSite.containsKey(uri)) {
            this.reposIliSite.put(uri, null);
        }
        if (this.reposIliFiles.containsKey(uri)) {
            this.reposIliFiles.put(uri, null);
        }
    }

    private boolean isLegacyDir(String uri) {
        String urilc = uri.toLowerCase();
        if (urilc.startsWith("http:")) {
            return false;
        }
        File file = new File(uri, "ilimodels.xml");
        return !file.exists();
    }

    public static IliFiles createIliFiles(String uri, Collection<ModelMetadata> modelv) throws RepositoryAccessException {
        HashMap models = new HashMap();
        for (ModelMetadata model : modelv) {
            String name = model.getName();
            if (!models.containsKey(name)) {
                models.put(name, new ArrayList());
            }
            ArrayList versions = (ArrayList)models.get(name);
            versions.add(model);
        }
        IliFiles ret = new IliFiles();
        HashMap<String, IliFile> files = new HashMap<String, IliFile>();
        for (String name : models.keySet()) {
            ArrayList modelVersions = (ArrayList)models.get(name);
            ModelMetadata_SchemaLanguage[] cslv = new ModelMetadata_SchemaLanguage[]{ModelMetadata_SchemaLanguage.ili1, ModelMetadata_SchemaLanguage.ili2_2, ModelMetadata_SchemaLanguage.ili2_3};
            int csli = 0;
            while (csli < cslv.length) {
                ModelMetadata model = RepositoryAccess.getLatestVersion(modelVersions, cslv[csli]);
                if (model != null) {
                    String filename = model.getFile();
                    IliFile ilifile = null;
                    if (!files.containsKey(filename)) {
                        ilifile = new IliFile();
                        ilifile.setPath(filename);
                        ilifile.setRepositoryUri(uri);
                        files.put(filename, ilifile);
                        ret.addFile(ilifile);
                    } else {
                        ilifile = (IliFile)files.get(filename);
                    }
                    IliModel iliModel = new IliModel();
                    ModelMetadata_SchemaLanguage csl = model.getSchemaLanguage();
                    if (csl == ModelMetadata_SchemaLanguage.ili1) {
                        iliModel.setIliVersion(1.0);
                    } else if (csl == ModelMetadata_SchemaLanguage.ili2_2) {
                        iliModel.setIliVersion(2.2);
                    } else if (csl == ModelMetadata_SchemaLanguage.ili2_3) {
                        iliModel.setIliVersion(2.3);
                    }
                    iliModel.setName(model.getName());
                    ModelName_[] deps = model.getdependsOnModel();
                    int depi = 0;
                    while (depi < deps.length) {
                        String depName = StringUtility.purge(deps[depi].getvalue());
                        if (depName != null) {
                            iliModel.addDepenedency(depName);
                        }
                        ++depi;
                    }
                    ilifile.addModel(iliModel);
                }
                ++csli;
            }
        }
        return ret;
    }

    private IliFiles readIliModelsXml(String uri) throws RepositoryAccessException {
        File file = this.getLocalFileLocation(uri, "ilimodels.xml", this.metaMaxTTL, null);
        if (file == null) {
            return null;
        }
        ArrayList<ModelMetadata> modelv = RepositoryAccess.readIliModelsXml(file);
        return RepositoryAccess.createIliFiles(uri, modelv);
    }

    public static ArrayList<ModelMetadata> readIliModelsXml(File file) {
        ArrayList<ModelMetadata> modelv = new ArrayList<ModelMetadata>();
        XtfReader reader = null;
        try {
            try {
                reader = new XtfReader(file);
                reader.getFactory().registerFactory(ILIREPOSITORY09.getIoxFactory());
                IoxEvent event = null;
                do {
                    IomObject iomObj;
                    if (!((event = reader.read()) instanceof ObjectEvent) || !((iomObj = ((ObjectEvent)event).getIomObject()) instanceof ModelMetadata)) continue;
                    ModelMetadata model = (ModelMetadata)iomObj;
                    modelv.add(model);
                } while (!(event instanceof EndTransferEvent));
            }
            catch (IoxException e) {
                throw new IllegalStateException(e);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IoxException e) {
                    throw new IllegalStateException(e);
                }
                reader = null;
            }
        }
        return modelv;
    }

    /*
     * Exception decompiling
     */
    private IliSite readIliSiteXml(String uri) throws RepositoryAccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ArrayList<ModelMetadata> getLatestVersions(ArrayList<ModelMetadata> modelVersions1) {
        HashMap models = new HashMap();
        for (ModelMetadata model : modelVersions1) {
            String name = model.getName();
            if (!models.containsKey(name)) {
                models.put(name, new ArrayList());
            }
            ArrayList versions = (ArrayList)models.get(name);
            versions.add(model);
        }
        ArrayList<ModelMetadata> ret = new ArrayList<ModelMetadata>();
        HashMap files = new HashMap();
        for (String name : models.keySet()) {
            ArrayList modelVersions = (ArrayList)models.get(name);
            ModelMetadata_SchemaLanguage[] cslv = new ModelMetadata_SchemaLanguage[]{ModelMetadata_SchemaLanguage.ili1, ModelMetadata_SchemaLanguage.ili2_2, ModelMetadata_SchemaLanguage.ili2_3};
            int csli = 0;
            while (csli < cslv.length) {
                ModelMetadata model = RepositoryAccess.getLatestVersion(modelVersions, cslv[csli]);
                if (model != null) {
                    ret.add(model);
                }
                ++csli;
            }
        }
        return ret;
    }

    private static ModelMetadata getLatestVersion(ArrayList<ModelMetadata> modelVersions1, ModelMetadata_SchemaLanguage csl) {
        ArrayList<ModelMetadata> modelVersions = new ArrayList<ModelMetadata>();
        ModelMetadata model2 = null;
        for (ModelMetadata model2 : modelVersions1) {
            if (!model2.getSchemaLanguage().equals(csl)) continue;
            modelVersions.add(model2);
        }
        if (modelVersions.isEmpty()) {
            return null;
        }
        ModelMetadata first = null;
        Iterator i = modelVersions.iterator();
        while (i.hasNext()) {
            model2 = (ModelMetadata)i.next();
            if (model2.getprecursorVersion() != null) continue;
            if (first == null) {
                if (!model2.getbrowseOnly()) {
                    first = model2;
                }
                i.remove();
                continue;
            }
            if (!model2.getbrowseOnly()) {
                EhiLogger.logAdaption("model " + model2.getName() + ": duplicate version without precursor; version " + model2.getVersion() + " ignored");
            }
            i.remove();
        }
        if (first == null) {
            EhiLogger.logAdaption("model " + model2.getName() + ": no version without precursor; model ignored");
            return null;
        }
        ModelMetadata lastVersion = first;
        ModelMetadata current = first;
        while (!modelVersions.isEmpty()) {
            ModelMetadata next = null;
            Iterator i2 = modelVersions.iterator();
            while (i2.hasNext()) {
                model2 = (ModelMetadata)i2.next();
                if (!current.getVersion().equals(model2.getprecursorVersion())) continue;
                if (next == null) {
                    next = model2;
                    i2.remove();
                    continue;
                }
                EhiLogger.logAdaption("model " + model2.getName() + ": duplicate version with same precursor; version " + model2.getVersion() + " ignored");
                i2.remove();
            }
            if (next == null) break;
            current = next;
            if (current.getbrowseOnly()) continue;
            lastVersion = current;
        }
        if (!modelVersions.isEmpty()) {
            EhiLogger.logAdaption("model " + lastVersion.getName() + ": broken version chain; use version " + lastVersion.getVersion() + "; others ignored");
        }
        return lastVersion;
    }

    /*
     * Exception decompiling
     */
    public File getLocalFileLocation(String uri, String filename, long maxTTL, String md5) throws RepositoryAccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String calcMD5(File file) {
        FileInputStream is;
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        String signature = null;
        try {
            try {
                int numRead;
                byte[] buffer = new byte[1024];
                do {
                    if ((numRead = ((InputStream)is).read(buffer)) <= 0) continue;
                    md.update(buffer, 0, numRead);
                } while (numRead != -1);
                signature = String.format("%032x", new BigInteger(1, md.digest()));
            }
            catch (IOException e) {
                EhiLogger.logError(e);
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e2) {
                    EhiLogger.logError(e2);
                }
            }
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                EhiLogger.logError(e);
            }
        }
        return signature;
    }
}

