/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.headers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.StyledEditorKit;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.graph.FileSystemTreeModel;
import org.owasp.jbrofuzz.graph.FileSystemTreeNode;
import org.owasp.jbrofuzz.headers.Header;
import org.owasp.jbrofuzz.headers.HeaderLoader;
import org.owasp.jbrofuzz.headers.HeaderMenuBar;
import org.owasp.jbrofuzz.util.NonWrappingTextPane;
import org.owasp.jbrofuzz.util.TextHighlighter;
import org.owasp.jbrofuzz.version.ImageCreator;
import org.owasp.jbrofuzz.version.JBroFuzzFormat;

public class HeaderFrame
extends JFrame
implements TreeSelectionListener,
KeyListener {
    private static final long serialVersionUID = 8707597613561230771L;
    private static final int SIZE_X = 650;
    private static final int SIZE_Y = 400;
    private JSplitPane mainSplitPanel;
    private JSplitPane rVSplitPanel;
    private JSplitPane rHSplitPanel;
    private JTree tree;
    private NonWrappingTextPane hTxTArea;
    private NonWrappingTextPane iTxTArea;
    private NonWrappingTextPane cTxTArea;
    private HeaderLoader mHeadersLoader;

    public HeaderFrame() {
        int ySize;
        this.setIconImage(ImageCreator.IMG_FRAME.getImage());
        this.setJMenuBar(new HeaderMenuBar(this));
        this.setTitle(" JBroFuzz - Browser Headers ");
        this.setLayout(new BorderLayout());
        this.mHeadersLoader = new HeaderLoader();
        this.tree = new JTree(new FileSystemTreeModel(new FileSystemTreeNode("...")));
        this.tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tree.addTreeSelectionListener(this);
        this.tree.addKeyListener(this);
        JScrollPane treeScrollPanel = new JScrollPane(this.tree);
        treeScrollPanel.setVerticalScrollBarPolicy(20);
        treeScrollPanel.setHorizontalScrollBarPolicy(30);
        JPanel treePanel = new JPanel(new BorderLayout());
        treePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" "), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        treePanel.add(treeScrollPanel);
        this.hTxTArea = new NonWrappingTextPane();
        this.hTxTArea.addKeyListener(this);
        this.hTxTArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.hTxTArea.putClientProperty("charset", "UTF-8");
        this.hTxTArea.setEditable(true);
        this.hTxTArea.setVisible(true);
        this.hTxTArea.setFont(new Font("Verdana", 0, 12));
        this.hTxTArea.setMargin(new Insets(1, 1, 1, 1));
        this.hTxTArea.setBackground(Color.WHITE);
        this.hTxTArea.setForeground(Color.BLACK);
        this.hTxTArea.setEditorKit(new StyledEditorKit(){
            private static final long serialVersionUID = -4550261337511448681L;

            @Override
            public Document createDefaultDocument() {
                return new TextHighlighter();
            }
        });
        JScrollPane hScrollPane = new JScrollPane(this.hTxTArea);
        hScrollPane.setVerticalScrollBarPolicy(20);
        hScrollPane.setHorizontalScrollBarPolicy(30);
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Header "), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        headerPanel.add(hScrollPane);
        this.iTxTArea = new NonWrappingTextPane();
        this.iTxTArea.addKeyListener(this);
        this.iTxTArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.iTxTArea.setEditable(false);
        this.iTxTArea.setFont(new Font("Verdana", 1, 10));
        JScrollPane iScrollPane = new JScrollPane(this.iTxTArea);
        iScrollPane.setVerticalScrollBarPolicy(20);
        iScrollPane.setHorizontalScrollBarPolicy(30);
        JPanel infoPanel = new JPanel(new BorderLayout());
        infoPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Information "), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        infoPanel.add(iScrollPane);
        this.cTxTArea = new NonWrappingTextPane();
        this.cTxTArea.addKeyListener(this);
        this.cTxTArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.cTxTArea.setEditable(false);
        this.cTxTArea.setFont(new Font("Verdana", 1, 10));
        JScrollPane cScrollPane = new JScrollPane(this.cTxTArea);
        cScrollPane.setVerticalScrollBarPolicy(20);
        cScrollPane.setHorizontalScrollBarPolicy(30);
        JPanel commentPanel = new JPanel(new BorderLayout());
        commentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Comment "), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        commentPanel.add(cScrollPane);
        this.rHSplitPanel = new JSplitPane(1);
        this.rHSplitPanel.setOneTouchExpandable(false);
        this.rHSplitPanel.setLeftComponent(headerPanel);
        this.rHSplitPanel.setRightComponent(infoPanel);
        this.rVSplitPanel = new JSplitPane(0);
        this.rVSplitPanel.setOneTouchExpandable(false);
        this.rVSplitPanel.setTopComponent(this.rHSplitPanel);
        this.rVSplitPanel.setBottomComponent(commentPanel);
        this.mainSplitPanel = new JSplitPane(1);
        this.mainSplitPanel.setOneTouchExpandable(false);
        this.mainSplitPanel.setLeftComponent(treePanel);
        this.mainSplitPanel.setRightComponent(this.rVSplitPanel);
        treePanel.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        commentPanel.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        infoPanel.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        headerPanel.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        JProgressBar progressBar = new JProgressBar();
        progressBar.setString("   ");
        progressBar.setStringPainted(true);
        progressBar.setBounds(410, 465, 120, 20);
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        bottomPanel.add(progressBar);
        this.add((Component)this.mainSplitPanel, "Center");
        this.add((Component)bottomPanel, "South");
        this.mHeadersLoader.load();
        this.tree.setModel(new DefaultTreeModel(this.mHeadersLoader.getMasterTreeNode()));
        this.tree.setSelectionRow(JBroFuzz.PREFS.getInt("UI.H.HeaderSelection", 0));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent wEvent) {
                HeaderFrame.this.closeFrame();
            }
        });
        this.mainSplitPanel.setDividerLocation(JBroFuzz.PREFS.getInt("UI.H.mainSplitPanel", 162));
        this.rHSplitPanel.setDividerLocation(JBroFuzz.PREFS.getInt("UI.H.rHSplitPanel", 315));
        this.rVSplitPanel.setDividerLocation(JBroFuzz.PREFS.getInt("UI.H.rVSplitPanel", 242));
        this.setMinimumSize(new Dimension(127, 127));
        int xSize = JBroFuzz.PREFS.getInt("UI.H.Height", 650);
        if (xSize < 127) {
            xSize = 127;
        }
        if ((ySize = JBroFuzz.PREFS.getInt("UI.H.Width", 400)) < 127) {
            ySize = 127;
        }
        this.setSize(ySize, xSize);
        this.setResizable(true);
        this.setVisible(true);
    }

    final void closeFrame() {
        JBroFuzz.PREFS.putInt("UI.H.mainSplitPanel", this.mainSplitPanel.getDividerLocation());
        JBroFuzz.PREFS.putInt("UI.H.rHSplitPanel", this.rHSplitPanel.getDividerLocation());
        JBroFuzz.PREFS.putInt("UI.H.rVSplitPanel", this.rVSplitPanel.getDividerLocation());
        JBroFuzz.PREFS.putInt("UI.H.HeaderSelection", this.tree.getSelectionCount());
        JBroFuzz.PREFS.putInt("UI.H.Height", this.getSize().height);
        JBroFuzz.PREFS.putInt("UI.H.Width", this.getSize().width);
        this.dispose();
    }

    public void setComment(String comment) {
        this.cTxTArea.setText(comment);
        this.cTxTArea.setCaretPosition(0);
    }

    public void setHeader(String header) {
        this.hTxTArea.setText(header);
        this.hTxTArea.setCaretPosition(0);
    }

    public void setInformation(String info) {
        this.iTxTArea.setText(info);
        this.iTxTArea.setCaretPosition(0);
    }

    @Override
    public void valueChanged(TreeSelectionEvent tEvent) {
        TreePath selectedPath = this.tree.getSelectionPath();
        if (selectedPath == null) {
            return;
        }
        if (selectedPath.getPathCount() > 127) {
            return;
        }
        Header cHeader = this.mHeadersLoader.getHeader(selectedPath);
        this.setHeader(cHeader.getHeader());
        this.setInformation(cHeader.getInfo());
        this.setComment(cHeader.getComment());
    }

    @Override
    public void keyTyped(KeyEvent kEvent) {
        if (kEvent.getKeyCode() == 27) {
            this.closeFrame();
        }
    }

    @Override
    public void keyPressed(KeyEvent kEvent) {
        if (kEvent.getKeyCode() == 27) {
            this.closeFrame();
        }
    }

    @Override
    public void keyReleased(KeyEvent kEvent) {
        if (kEvent.getKeyCode() == 27) {
            this.closeFrame();
        }
    }
}

