/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz3.message;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;

public class Request {
    private ArrayList<Byte> types = new ArrayList();
    private ArrayList<String> elements = new ArrayList();
    private static byte CRLF = 1;
    private static byte PLAINTEXT = (byte)2;
    private final int messageBodyLocation;
    private final int contentLengthHeaderLocation;

    public static void main(String[] args) {
        String[] messages;
        String[] stringArray = messages = new String[]{"", "\n\n\n\n\n\n\n\n", "GET /ig/extern_js/f/CgJlbB/2qJTcRRHu10.js HTTP/1.1\nHost: www.google.com\nReferer: http://www.google.com/ig?refresh=1\n\n", "GET /index.html", "POST /someURL.jsp?user=one HTTP/1.0\nHost: localhost\nContent-Length: 61\n\nproject=WIP&surname=last&firstName=first&language=en", "POST /SomeLoc/SWService HTTP/1.1\nHost: somelocation.com\nUser-Agent: Mozilla/5.0 (Windows; U; Windows NT 5.1; en-GB; rv:1.9.2.13) Gecko/20101203 Firefox/3.6.13\nAccept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\nAccept-Language: en-gb,en;q=0.5\nAccept-Encoding: gzip,deflate\nAccept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7\nKeep-Alive: 115\nConnection: keep-aliveReferer: https://www.theref.com\nContent-type: text/xml; charset=utf-8\nSOAPAction: \"\"\nContent-Length: 413\n\n<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n<soap:Body>\n<getSecToken xmlns=\"http://logon.logonws.directory.ubs.com\">\n<username>asdf</username>\n<password>asd</password>\n<targetInfo/>\n<versionInfo/>\n</getSecurityToken>\n</soap:Body>\n</soap:Envelope>\n"};
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            Request r = new Request(message);
            System.out.println(">>> >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> Start -->");
            System.out.println("Message:\n" + r.getRequestForDisplayPurposes());
            Request.debug(r);
            System.out.println("Type size is: " + r.getTypes().size());
            System.out.println("Has message body: " + r.isMessageBodyPresent());
            System.out.println("Adding a header: Header: MyHeaderOne!");
            r.addHeader("Header: MyHeaderOne!");
            Request.debug(r);
            System.out.println("New Message:\n" + r.getRequestForDisplayPurposes());
            System.out.println("<-- End <<< <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
            ++n2;
        }
        System.out.println("Done!");
    }

    public void addHeader(String header) {
        if (this.messageBodyLocation > 0) {
            int lastHeaderType = this.types.size() - 2;
            this.types.add(lastHeaderType, CRLF);
            this.types.add(lastHeaderType, PLAINTEXT);
            int lastHeaderElement = this.elements.size() - 1;
            this.elements.add(lastHeaderElement, header);
        } else {
            if (this.types.size() > 0) {
                this.types.add(CRLF);
            }
            this.types.add(PLAINTEXT);
            this.elements.add(header);
        }
    }

    public int hasContentHeader() {
        Iterator<Byte> itrTypes = this.types.iterator();
        Iterator<String> itrData = this.elements.iterator();
        int counter = 0;
        while (itrTypes.hasNext()) {
            String currentString;
            byte currentType = itrTypes.next();
            if (currentType != CRLF && (currentString = itrData.next().toLowerCase()).startsWith("content-length:")) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    public boolean isMessageBodyPresent() {
        return this.messageBodyLocation > 0;
    }

    public boolean isContentLengthHeaderPresent() {
        return this.contentLengthHeaderLocation > 0;
    }

    public Request(String message) {
        Request.loadMessage(message, this.types, this.elements);
        Request.removeEndCRLFs(this.types);
        this.messageBodyLocation = this.findMessageBodyLocation();
        this.contentLengthHeaderLocation = this.hasContentHeader();
    }

    private static void removeEndCRLFs(ArrayList<Byte> types) {
        int count = 0;
        while (count < 16) {
            int lastType = types.size() - 1;
            if (lastType < 0) {
                return;
            }
            if (types.get(lastType) != CRLF) {
                return;
            }
            types.remove(lastType);
            count = (byte)(count + 1);
        }
    }

    private int findMessageBodyLocation() {
        Iterator<Byte> itrTypes = this.types.iterator();
        int returnValue = -1;
        byte pattern1 = PLAINTEXT;
        byte pattern2 = CRLF;
        byte pattern3 = CRLF;
        byte pattern4 = PLAINTEXT;
        Stack<Byte> messageBodyPattern = new Stack<Byte>();
        while (itrTypes.hasNext()) {
            messageBodyPattern.size();
            messageBodyPattern.push(itrTypes.next());
        }
        return returnValue;
    }

    private static void loadMessage(String message, ArrayList<Byte> types, ArrayList<String> elements) {
        char[] charArray = message.toCharArray();
        StringBuffer sb = new StringBuffer();
        char[] cArray = charArray;
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\n') {
                int dataLength = sb.length();
                if (dataLength > 0) {
                    elements.add(sb.toString());
                    sb.delete(0, dataLength);
                    types.add(PLAINTEXT);
                }
                types.add(CRLF);
            } else {
                sb.append(c);
            }
            ++n2;
        }
        int dataLength = sb.length();
        if (dataLength > 0) {
            elements.add(sb.toString());
            sb.delete(0, dataLength);
            types.add(PLAINTEXT);
        }
    }

    private static void debug(Request r) {
        Iterator<Byte> itrTypes = r.getTypes().iterator();
        Iterator<String> itrData = r.getElements().iterator();
        System.out.println("Types Array: ");
        while (itrTypes.hasNext()) {
            System.out.print(itrTypes.next() + " ");
        }
        System.out.println("");
        System.out.println("Types Data: ");
        while (itrData.hasNext()) {
            System.out.print("[" + itrData.next() + "] ");
        }
        System.out.println("");
    }

    private ArrayList<String> getElements() {
        return this.elements;
    }

    private ArrayList<Byte> getTypes() {
        return this.types;
    }

    public String getRequest() {
        StringBuffer output = new StringBuffer();
        Iterator<Byte> itrTypes = this.types.iterator();
        Iterator<String> itrData = this.elements.iterator();
        while (itrTypes.hasNext()) {
            byte currentType = itrTypes.next();
            switch (currentType) {
                case 1: {
                    output.append('\r');
                    output.append('\n');
                    break;
                }
                case 2: {
                    output.append(itrData.next());
                }
            }
        }
        if (this.types.size() > 0 && !this.isMessageBodyPresent()) {
            output.append('\r');
            output.append('\n');
            output.append('\r');
            output.append('\n');
        }
        return output.toString();
    }

    public String getRequestForDisplayPurposes() {
        StringBuffer output = new StringBuffer();
        Iterator<Byte> itrTypes = this.types.iterator();
        Iterator<String> itrData = this.elements.iterator();
        while (itrTypes.hasNext()) {
            byte currentType = itrTypes.next();
            switch (currentType) {
                case 1: {
                    output.append("CRLF");
                    output.append('\n');
                    break;
                }
                case 2: {
                    output.append(itrData.next());
                }
            }
        }
        if (this.types.size() > 0 && !this.isMessageBodyPresent()) {
            output.append("CRLF");
            output.append('\n');
            output.append("CRLF");
            output.append('\n');
        }
        return output.toString();
    }
}

