/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.SliderBehavior;
import com.sun.javafx.scene.control.skin.SkinBase;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.chart.NumberAxis;
import javafx.scene.control.Slider;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;

public class SliderSkin
extends SkinBase<Slider, SliderBehavior> {
    private NumberAxis tickLine = null;
    private double trackToTickGap = 2.0;
    private boolean showTickMarks;
    private double thumbWidth;
    private double thumbHeight;
    private double trackStart;
    private double trackLength;
    private double thumbTop;
    private double thumbLeft;
    private double preDragThumbPos;
    private Point2D dragStart;
    private StackPane thumb;
    private StackPane track;

    public SliderSkin(Slider slider) {
        super(slider, new SliderBehavior(slider));
        this.initialize();
        this.requestLayout();
        this.registerChangeListener(slider.minProperty(), "MIN");
        this.registerChangeListener(slider.maxProperty(), "MAX");
        this.registerChangeListener(slider.valueProperty(), "VALUE");
        this.registerChangeListener(slider.orientationProperty(), "ORIENTATION");
        this.registerChangeListener(slider.showTickMarksProperty(), "SHOW_TICK_MARKS");
        this.registerChangeListener(slider.showTickLabelsProperty(), "SHOW_TICK_LABELS");
        this.registerChangeListener(slider.majorTickUnitProperty(), "MAJOR_TICK_UNIT");
        this.registerChangeListener(slider.minorTickCountProperty(), "MINOR_TICK_COUNT");
    }

    private void initialize() {
        this.thumb = new StackPane();
        this.thumb.getStyleClass().setAll((String[])new String[]{"thumb"});
        this.track = new StackPane();
        this.track.getStyleClass().setAll((String[])new String[]{"track"});
        this.getChildren().clear();
        this.getChildren().addAll((Node[])new Node[]{this.track, this.thumb});
        this.setShowTickMarks(((Slider)this.getSkinnable()).isShowTickMarks(), ((Slider)this.getSkinnable()).isShowTickLabels());
        this.track.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (!SliderSkin.this.thumb.isPressed()) {
                    if (((Slider)SliderSkin.this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
                        ((SliderBehavior)SliderSkin.this.getBehavior()).trackPress(mouseEvent, mouseEvent.getX() / SliderSkin.this.trackLength);
                    } else {
                        ((SliderBehavior)SliderSkin.this.getBehavior()).trackPress(mouseEvent, mouseEvent.getY() / SliderSkin.this.trackLength);
                    }
                }
            }
        });
        this.track.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                ((SliderBehavior)SliderSkin.this.getBehavior()).trackRelease(mouseEvent, 0.0);
            }
        });
        this.thumb.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                ((SliderBehavior)SliderSkin.this.getBehavior()).thumbPressed(mouseEvent, 0.0);
                SliderSkin.this.dragStart = SliderSkin.this.thumb.localToParent(mouseEvent.getX(), mouseEvent.getY());
                SliderSkin.this.preDragThumbPos = (((Slider)SliderSkin.this.getSkinnable()).getValue() - ((Slider)SliderSkin.this.getSkinnable()).getMin()) / (((Slider)SliderSkin.this.getSkinnable()).getMax() - ((Slider)SliderSkin.this.getSkinnable()).getMin());
            }
        });
        this.thumb.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                ((SliderBehavior)SliderSkin.this.getBehavior()).thumbReleased(mouseEvent);
            }
        });
        this.thumb.setOnMouseDragged((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                Point2D point2D = SliderSkin.this.thumb.localToParent(mouseEvent.getX(), mouseEvent.getY());
                double d = ((Slider)SliderSkin.this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL ? point2D.getX() - SliderSkin.this.dragStart.getX() : -(point2D.getY() - SliderSkin.this.dragStart.getY());
                ((SliderBehavior)SliderSkin.this.getBehavior()).thumbDragged(mouseEvent, SliderSkin.this.preDragThumbPos + d / SliderSkin.this.trackLength);
            }
        });
    }

    private void setShowTickMarks(boolean bl, boolean bl2) {
        this.showTickMarks = bl || bl2;
        Slider slider = (Slider)this.getSkinnable();
        if (this.showTickMarks) {
            if (this.tickLine == null) {
                this.tickLine = new NumberAxis();
                this.tickLine.setAutoRanging(false);
                this.tickLine.setSide(slider.getOrientation() == Orientation.VERTICAL ? Side.RIGHT : (slider.getOrientation() == null ? Side.RIGHT : Side.BOTTOM));
                this.tickLine.setUpperBound(slider.getMax());
                this.tickLine.setLowerBound(slider.getMin());
                this.tickLine.setTickUnit(slider.getMajorTickUnit());
                this.tickLine.setTickMarkVisible(bl);
                this.tickLine.setTickLabelsVisible(bl2);
                this.tickLine.setMinorTickVisible(bl);
                this.tickLine.setMinorTickCount(Math.max(slider.getMinorTickCount(), 0) + 1);
                this.getChildren().clear();
                this.getChildren().addAll((Node[])new Node[]{this.tickLine, this.track, this.thumb});
            } else {
                this.tickLine.setTickLabelsVisible(bl2);
                this.tickLine.setTickMarkVisible(bl);
                this.tickLine.setMinorTickVisible(bl);
            }
        } else {
            this.getChildren().clear();
            this.getChildren().addAll((Node[])new Node[]{this.track, this.thumb});
        }
        this.requestLayout();
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if ("ORIENTATION".equals(string)) {
            if (this.showTickMarks && this.tickLine != null) {
                this.tickLine.setSide(((Slider)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? Side.RIGHT : (((Slider)this.getSkinnable()).getOrientation() == null ? Side.RIGHT : Side.BOTTOM));
            }
            this.requestLayout();
        } else if ("VALUE".equals(string)) {
            this.positionThumb();
        } else if ("MIN".equals(string)) {
            if (this.showTickMarks && this.tickLine != null) {
                this.tickLine.setLowerBound(((Slider)this.getSkinnable()).getMin());
            }
            this.requestLayout();
        } else if ("MAX".equals(string)) {
            if (this.showTickMarks && this.tickLine != null) {
                this.tickLine.setUpperBound(((Slider)this.getSkinnable()).getMax());
            }
            this.requestLayout();
        } else if ("SHOW_TICK_MARKS".equals(string) || "SHOW_TICK_LABELS".equals(string)) {
            this.setShowTickMarks(((Slider)this.getSkinnable()).isShowTickMarks(), ((Slider)this.getSkinnable()).isShowTickLabels());
        } else if ("MAJOR_TICK_UNIT".equals(string)) {
            if (this.tickLine != null) {
                this.tickLine.setTickUnit(((Slider)this.getSkinnable()).getMajorTickUnit());
                this.requestLayout();
            }
        } else if ("MINOR_TICK_COUNT".equals(string) && this.tickLine != null) {
            this.tickLine.setMinorTickCount(Math.max(((Slider)this.getSkinnable()).getMinorTickCount(), 0) + 1);
            this.requestLayout();
        }
    }

    void positionThumb() {
        Slider slider = (Slider)this.getSkinnable();
        boolean bl = ((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL;
        double d = bl ? this.trackStart + (this.trackLength * ((slider.getValue() - slider.getMin()) / (slider.getMax() - slider.getMin())) - this.thumbWidth / 2.0) : this.thumbLeft;
        double d2 = bl ? this.thumbTop : this.getInsets().getTop() + this.trackLength - this.trackLength * ((slider.getValue() - slider.getMin()) / (slider.getMax() - slider.getMin()));
        this.thumb.setLayoutX(d);
        this.thumb.setLayoutY(d2);
    }

    @Override
    protected void layoutChildren() {
        double d;
        double d2 = this.getInsets().getLeft();
        double d3 = this.getInsets().getTop();
        double d4 = this.getWidth() - (this.getInsets().getLeft() + this.getInsets().getRight());
        double d5 = this.getHeight() - (this.getInsets().getTop() + this.getInsets().getBottom());
        this.thumbWidth = this.thumb.prefWidth(-1.0);
        this.thumbHeight = this.thumb.prefHeight(-1.0);
        this.thumb.resize(this.thumbWidth, this.thumbHeight);
        double d6 = d = this.track.impl_getBackgroundFills() != null && this.track.impl_getBackgroundFills().size() > 0 ? this.track.impl_getBackgroundFills().get(0).getTopLeftCornerRadius() : 0.0;
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            double d7 = this.showTickMarks ? this.tickLine.prefHeight(-1.0) : 0.0;
            double d8 = this.track.prefHeight(-1.0);
            double d9 = Math.max(d8, this.thumbHeight);
            double d10 = d9 + (this.showTickMarks ? this.trackToTickGap + d7 : 0.0);
            double d11 = d3 + (d5 - d10) / 2.0;
            this.trackLength = d4 - this.thumbWidth;
            this.trackStart = d2 + this.thumbWidth / 2.0;
            double d12 = (int)(d11 + (d9 - d8) / 2.0);
            this.thumbTop = (int)(d11 + (d9 - this.thumbHeight) / 2.0);
            this.positionThumb();
            this.track.resizeRelocate(this.trackStart - d, d12, this.trackLength + d + d, d8);
            if (this.showTickMarks) {
                this.tickLine.setLayoutX(this.trackStart);
                this.tickLine.setLayoutY(d12 + d8 + this.trackToTickGap);
                this.tickLine.resize(this.trackLength, d7);
                this.tickLine.requestAxisLayout();
            } else {
                if (this.tickLine != null) {
                    this.tickLine.resize(0.0, 0.0);
                    this.tickLine.requestAxisLayout();
                }
                this.tickLine = null;
            }
        } else {
            double d13 = this.showTickMarks ? this.tickLine.prefWidth(-1.0) : 0.0;
            double d14 = this.track.prefWidth(-1.0);
            double d15 = Math.max(d14, this.thumbWidth);
            double d16 = d15 + (this.showTickMarks ? this.trackToTickGap + d13 : 0.0);
            double d17 = d2 + (d4 - d16) / 2.0;
            this.trackLength = d5 - this.thumbHeight;
            this.trackStart = d3 + this.thumbHeight / 2.0;
            double d18 = (int)(d17 + (d15 - d14) / 2.0);
            this.thumbLeft = (int)(d17 + (d15 - this.thumbWidth) / 2.0);
            this.positionThumb();
            this.track.resizeRelocate(d18, this.trackStart - d, d14, this.trackLength + d + d);
            if (this.showTickMarks) {
                this.tickLine.setLayoutX(d18 + d14 + this.trackToTickGap);
                this.tickLine.setLayoutY(this.trackStart);
                this.tickLine.resize(d13, this.trackLength);
                this.tickLine.requestAxisLayout();
            } else {
                if (this.tickLine != null) {
                    this.tickLine.resize(0.0, 0.0);
                    this.tickLine.requestAxisLayout();
                }
                this.tickLine = null;
            }
        }
    }

    double minTrackLength() {
        return 2.0 * this.thumb.prefWidth(-1.0);
    }

    @Override
    protected double computeMinWidth(double d) {
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            return this.getInsets().getLeft() + this.minTrackLength() + this.thumb.minWidth(-1.0) + this.getInsets().getRight();
        }
        return this.getInsets().getLeft() + this.thumb.prefWidth(-1.0) + this.getInsets().getRight();
    }

    @Override
    protected double computeMinHeight(double d) {
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            return this.getInsets().getTop() + this.thumb.prefHeight(-1.0) + this.getInsets().getBottom();
        }
        return this.getInsets().getTop() + this.minTrackLength() + this.thumb.prefHeight(-1.0) + this.getInsets().getBottom();
    }

    @Override
    protected double computePrefWidth(double d) {
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            if (this.showTickMarks) {
                return Math.max(140.0, this.tickLine.prefWidth(-1.0));
            }
            return 140.0;
        }
        return this.getInsets().getLeft() + Math.max(this.thumb.prefWidth(-1.0), this.track.prefWidth(-1.0)) + (this.showTickMarks ? this.trackToTickGap + this.tickLine.prefWidth(-1.0) : 0.0) + this.getInsets().getRight();
    }

    @Override
    protected double computePrefHeight(double d) {
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            return this.getInsets().getTop() + Math.max(this.thumb.prefHeight(-1.0), this.track.prefHeight(-1.0)) + (this.showTickMarks ? this.trackToTickGap + this.tickLine.prefHeight(-1.0) : 0.0) + this.getInsets().getBottom();
        }
        if (this.showTickMarks) {
            return Math.max(140.0, this.tickLine.prefHeight(-1.0));
        }
        return 140.0;
    }

    @Override
    protected double computeMaxWidth(double d) {
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            return Double.MAX_VALUE;
        }
        return ((Slider)this.getSkinnable()).prefWidth(-1.0);
    }

    @Override
    protected double computeMaxHeight(double d) {
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            return ((Slider)this.getSkinnable()).prefHeight(d);
        }
        return Double.MAX_VALUE;
    }
}

