/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.model.HistoryReference;

public class HistoryFilter {
    public static final String NOTES_IGNORE = Constant.messages.getString("history.filter.notes.ignore");
    public static final String NOTES_PRESENT = Constant.messages.getString("history.filter.notes.present");
    public static final String NOTES_ABSENT = Constant.messages.getString("history.filter.notes.absent");
    public static final String[] NOTES_OPTIONS = new String[]{NOTES_IGNORE, NOTES_PRESENT, NOTES_ABSENT};
    private List<String> methodList = new ArrayList<String>();
    private List<Integer> codeList = new ArrayList<Integer>();
    private List<String> riskList = new ArrayList<String>();
    private List<String> confidenceList = new ArrayList<String>();
    private List<String> tagList = new ArrayList<String>();
    private String note = null;
    private List<Pattern> urlIncPatternList = new ArrayList<Pattern>();
    private List<Pattern> urlExcPatternList = new ArrayList<Pattern>();
    private Logger logger = Logger.getLogger(HistoryFilter.class);

    public void setMethods(List<String> list) {
        this.methodList.clear();
        this.methodList.addAll(list);
    }

    public void setCodes(List<Integer> list) {
        this.codeList.clear();
        this.codeList.addAll(list);
    }

    public void setTags(List<String> list) {
        this.tagList.clear();
        this.tagList.addAll(list);
    }

    public void setRisks(List<String> list) {
        this.riskList.clear();
        this.riskList.addAll(list);
    }

    public void setReliabilities(List<String> list) {
        this.confidenceList.clear();
        this.confidenceList.addAll(list);
    }

    public void reset() {
        this.methodList.clear();
        this.codeList.clear();
        this.tagList.clear();
        this.riskList.clear();
        this.confidenceList.clear();
        this.note = null;
    }

    public boolean matches(HistoryReference historyReference) {
        try {
            Object object;
            if (this.methodList.size() > 0 && !this.methodList.contains(historyReference.getMethod())) {
                return false;
            }
            if (this.codeList.size() > 0 && !this.codeList.contains(historyReference.getStatusCode())) {
                return false;
            }
            boolean bl = false;
            List<String> list = historyReference.getTags();
            if (this.tagList.size() > 0) {
                for (String object22 : list) {
                    if (!this.tagList.contains(object22)) continue;
                    bl = true;
                }
                if (!bl) {
                    return false;
                }
            }
            boolean bl2 = false;
            List<Alert> list2 = historyReference.getAlerts();
            if (this.riskList.size() > 0 || this.confidenceList.size() > 0) {
                for (Alert bl3 : list2) {
                    if (this.riskList.size() != 0 && !this.riskList.contains(Alert.MSG_RISK[bl3.getRisk()]) || this.confidenceList.size() != 0 && !this.confidenceList.contains(Alert.MSG_CONFIDENCE[bl3.getConfidence()])) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    return false;
                }
            }
            if (this.note != null && !this.note.equals(NOTES_IGNORE)) {
                boolean bl3;
                object = historyReference.getHttpMessage().getNote();
                boolean bl4 = bl3 = object != null && ((String)object).length() > 0;
                if (this.note.equals(NOTES_PRESENT) != bl3) {
                    return false;
                }
            }
            object = historyReference.getURI().toString();
            if (this.urlExcPatternList != null && this.urlExcPatternList.size() > 0) {
                for (Pattern pattern : this.urlExcPatternList) {
                    if (!pattern.matcher((CharSequence)object).matches()) continue;
                    return false;
                }
            }
            if (this.urlIncPatternList != null && this.urlIncPatternList.size() > 0) {
                boolean bl5 = false;
                for (Pattern pattern : this.urlIncPatternList) {
                    if (!pattern.matcher((CharSequence)object).matches()) continue;
                    bl5 = true;
                    break;
                }
                if (!bl5) {
                    return false;
                }
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return true;
    }

    public String toShortString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Constant.messages.getString("history.filter.label.filter"));
        stringBuilder.append(" ");
        boolean bl = true;
        if (this.methodList.size() > 0) {
            if (bl) {
                stringBuilder.append(Constant.messages.getString("history.filter.label.on"));
                stringBuilder.append(' ');
            }
            bl = false;
            stringBuilder.append(Constant.messages.getString("history.filter.label.methods"));
        }
        if (this.codeList.size() > 0) {
            if (bl) {
                stringBuilder.append(Constant.messages.getString("history.filter.label.on"));
                stringBuilder.append(' ');
            } else {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append(Constant.messages.getString("history.filter.label.codes"));
        }
        if (this.tagList.size() > 0) {
            if (bl) {
                stringBuilder.append(Constant.messages.getString("history.filter.label.on"));
                stringBuilder.append(' ');
            } else {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append(Constant.messages.getString("history.filter.label.tags"));
        }
        if (this.riskList.size() > 0 || this.confidenceList.size() > 0) {
            if (bl) {
                stringBuilder.append(Constant.messages.getString("history.filter.label.on"));
                stringBuilder.append(' ');
            } else {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append(Constant.messages.getString("history.filter.label.alerts"));
        }
        if (this.note != null && !this.note.equals(NOTES_IGNORE)) {
            if (bl) {
                stringBuilder.append(Constant.messages.getString("history.filter.label.on"));
                stringBuilder.append(' ');
            } else {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append(Constant.messages.getString("history.filter.label.notes"));
        }
        if (this.urlIncPatternList != null && this.urlIncPatternList.size() > 0) {
            if (bl) {
                stringBuilder.append(Constant.messages.getString("history.filter.label.on"));
                stringBuilder.append(' ');
            } else {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append(Constant.messages.getString("history.filter.label.urlincregex"));
        }
        if (this.urlExcPatternList != null && this.urlExcPatternList.size() > 0) {
            if (bl) {
                stringBuilder.append(Constant.messages.getString("history.filter.label.on"));
                stringBuilder.append(' ');
            } else {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append(Constant.messages.getString("history.filter.label.urlexcregex"));
        }
        if (bl) {
            stringBuilder.append(Constant.messages.getString("history.filter.label.off"));
        }
        return stringBuilder.toString();
    }

    public String toLongString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Constant.messages.getString("history.filter.label.filter"));
        stringBuilder.append(' ');
        boolean bl = true;
        if (this.methodList.size() > 0) {
            bl = false;
            stringBuilder.append(Constant.messages.getString("history.filter.label.methods"));
            stringBuilder.append(": ");
            for (String string : this.methodList) {
                stringBuilder.append(string);
                stringBuilder.append(' ');
            }
        }
        if (this.codeList.size() > 0) {
            bl = false;
            stringBuilder.append(Constant.messages.getString("history.filter.label.codes"));
            stringBuilder.append(": ");
            Object object = null;
            boolean bl2 = false;
            for (Integer n : this.codeList) {
                if (object == null) {
                    stringBuilder.append(n);
                } else if (n == (Integer)object + 1) {
                    bl2 = true;
                } else if (bl2) {
                    stringBuilder.append('-');
                    stringBuilder.append(object);
                    stringBuilder.append(' ');
                    stringBuilder.append(n);
                    bl2 = false;
                } else {
                    stringBuilder.append(' ');
                    stringBuilder.append(n);
                }
                object = n;
            }
            if (bl2) {
                stringBuilder.append('-');
                stringBuilder.append(object);
                stringBuilder.append(' ');
            }
        }
        if (this.tagList.size() > 0) {
            bl = false;
            stringBuilder.append(Constant.messages.getString("history.filter.label.tags"));
            stringBuilder.append(": ");
            for (String string : this.tagList) {
                stringBuilder.append(string);
                stringBuilder.append(' ');
            }
        }
        if (this.riskList.size() > 0 || this.confidenceList.size() > 0) {
            bl = false;
            stringBuilder.append(Constant.messages.getString("history.filter.label.alerts"));
            stringBuilder.append(": ");
            for (String string : this.riskList) {
                stringBuilder.append(string);
                stringBuilder.append(' ');
            }
            for (String string : this.confidenceList) {
                stringBuilder.append(string);
                stringBuilder.append(' ');
            }
        }
        if (this.note != null && !this.note.equals(NOTES_IGNORE)) {
            bl = false;
            stringBuilder.append(Constant.messages.getString("history.filter.label.notes"));
            stringBuilder.append(": ");
            stringBuilder.append(this.note);
        }
        if (bl) {
            stringBuilder.append(Constant.messages.getString("history.filter.label.off"));
        }
        return stringBuilder.toString();
    }

    public void setNote(Object object) {
        this.note = object == null ? null : object.toString();
    }

    public List<Pattern> getUrlIncPatternList() {
        return this.urlIncPatternList;
    }

    public void setUrlIncPatternList(List<Pattern> list) {
        this.urlIncPatternList = list;
    }

    public List<Pattern> getUrlExcPatternList() {
        return this.urlExcPatternList;
    }

    public void setUrlExcPatternList(List<Pattern> list) {
        this.urlExcPatternList = list;
    }
}

