/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.authorization;

import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.authorization.AuthorizationDetectionMethod;

public class BasicAuthorizationDetectionMethod
implements AuthorizationDetectionMethod {
    public static final int METHOD_UNIQUE_ID = 0;
    public static final int NO_STATUS_CODE = -1;
    public static final String CONTEXT_CONFIG_AUTH_BASIC = "context.authorization.basic";
    public static final String CONTEXT_CONFIG_AUTH_BASIC_HEADER = "context.authorization.basic.header";
    public static final String CONTEXT_CONFIG_AUTH_BASIC_BODY = "context.authorization.basic.body";
    public static final String CONTEXT_CONFIG_AUTH_BASIC_LOGIC = "context.authorization.basic.logic";
    public static final String CONTEXT_CONFIG_AUTH_BASIC_CODE = "context.authorization.basic.code";
    protected LogicalOperator logicalOperator;
    protected int statusCode;
    protected Pattern headerPattern;
    protected Pattern bodyPattern;

    public BasicAuthorizationDetectionMethod(Integer n, String string, String string2, LogicalOperator logicalOperator) {
        this.headerPattern = BasicAuthorizationDetectionMethod.buildPattern(string);
        this.bodyPattern = BasicAuthorizationDetectionMethod.buildPattern(string2);
        this.logicalOperator = logicalOperator;
        this.statusCode = n != null ? n : -1;
    }

    public BasicAuthorizationDetectionMethod(Configuration configuration) throws ConfigurationException {
        this.headerPattern = BasicAuthorizationDetectionMethod.buildPattern(configuration.getString(CONTEXT_CONFIG_AUTH_BASIC_HEADER));
        this.bodyPattern = BasicAuthorizationDetectionMethod.buildPattern(configuration.getString(CONTEXT_CONFIG_AUTH_BASIC_BODY));
        this.logicalOperator = LogicalOperator.valueOf(configuration.getString(CONTEXT_CONFIG_AUTH_BASIC_LOGIC));
        this.statusCode = configuration.getInt(CONTEXT_CONFIG_AUTH_BASIC_CODE);
    }

    private BasicAuthorizationDetectionMethod(int n, Pattern pattern, Pattern pattern2, LogicalOperator logicalOperator) {
        this.headerPattern = pattern;
        this.bodyPattern = pattern2;
        this.logicalOperator = logicalOperator;
        this.statusCode = n;
    }

    private static Pattern buildPattern(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        return Pattern.compile(string);
    }

    private static String getPatternString(Pattern pattern) {
        if (pattern == null) {
            return "";
        }
        return pattern.pattern();
    }

    @Override
    public boolean isResponseForUnauthorizedRequest(HttpMessage httpMessage) {
        boolean bl = httpMessage.getResponseHeader().getStatusCode() == this.statusCode;
        boolean bl2 = this.headerPattern != null ? this.headerPattern.matcher(httpMessage.getResponseHeader().toString()).find() : false;
        boolean bl3 = this.bodyPattern != null ? this.bodyPattern.matcher(httpMessage.getResponseBody().toString()).find() : false;
        switch (this.logicalOperator) {
            case AND: {
                if (this.statusCode == -1 && this.headerPattern == null && this.bodyPattern == null) {
                    return false;
                }
                return !(!bl && this.statusCode != -1 || this.headerPattern != null && !bl2 || this.bodyPattern != null && !bl3);
            }
            case OR: {
                return bl || bl2 || bl3;
            }
        }
        return false;
    }

    public String toString() {
        return "BasicAuthorizationDetectionMethod [" + (Object)((Object)this.logicalOperator) + ": code=" + this.statusCode + ", header=" + this.headerPattern + ", body=" + this.bodyPattern + "]";
    }

    @Override
    public AuthorizationDetectionMethod clone() {
        return new BasicAuthorizationDetectionMethod(this.statusCode, this.headerPattern, this.bodyPattern, this.logicalOperator);
    }

    @Override
    public int getMethodUniqueIdentifier() {
        return 0;
    }

    @Override
    public void persistMethodToSession(Session session, int n) throws DatabaseException {
        session.setContextData(n, 231, Integer.toString(this.statusCode));
        if (this.headerPattern != null) {
            session.setContextData(n, 232, this.headerPattern.pattern());
        } else {
            session.clearContextDataForType(n, 232);
        }
        if (this.bodyPattern != null) {
            session.setContextData(n, 233, this.bodyPattern.pattern());
        } else {
            session.clearContextDataForType(n, 233);
        }
        session.setContextData(n, 234, this.logicalOperator.name());
    }

    public static BasicAuthorizationDetectionMethod loadMethodFromSession(Session session, int n) throws DatabaseException {
        Object object;
        Object object2;
        Object object3;
        int n2 = -1;
        try {
            object3 = session.getContextDataStrings(n, 231);
            n2 = Integer.parseInt(object3.get(0));
        }
        catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException runtimeException) {
            // empty catch block
        }
        object3 = null;
        try {
            object2 = session.getContextDataStrings(n, 232);
            object3 = object2.get(0);
        }
        catch (IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        object2 = null;
        try {
            object = session.getContextDataStrings(n, 233);
            object2 = (String)object.get(0);
        }
        catch (IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        object = LogicalOperator.OR;
        try {
            List<String> list = session.getContextDataStrings(n, 234);
            object = LogicalOperator.valueOf(list.get(0));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        return new BasicAuthorizationDetectionMethod((Integer)n2, (String)object3, (String)object2, (LogicalOperator)((Object)object));
    }

    @Override
    public void exportMethodData(Configuration configuration) {
        configuration.setProperty(CONTEXT_CONFIG_AUTH_BASIC_HEADER, (Object)BasicAuthorizationDetectionMethod.getPatternString(this.headerPattern));
        configuration.setProperty(CONTEXT_CONFIG_AUTH_BASIC_BODY, (Object)BasicAuthorizationDetectionMethod.getPatternString(this.bodyPattern));
        configuration.setProperty(CONTEXT_CONFIG_AUTH_BASIC_LOGIC, (Object)this.logicalOperator.name());
        configuration.setProperty(CONTEXT_CONFIG_AUTH_BASIC_CODE, (Object)this.statusCode);
    }

    @Override
    public ApiResponse getApiResponseRepresentation() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("headerRegex", this.headerPattern == null ? "" : this.headerPattern.pattern());
        hashMap.put("bodyRegex", this.bodyPattern == null ? "" : this.bodyPattern.pattern());
        hashMap.put("statusCode", Integer.toString(this.statusCode));
        hashMap.put("logicalOperator", this.logicalOperator.name());
        hashMap.put("methodType", "basic");
        return new ApiResponseSet("authorizationDetectionMethod", hashMap);
    }

    public static enum LogicalOperator {
        AND,
        OR;

    }
}

