/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.debug.DebugStackFrame;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.RootNode;

public abstract class DebugValue {
    abstract Class<? extends TruffleLanguage> getLanguage();

    abstract Object get();

    DebugValue() {
    }

    public abstract void set(DebugValue var1);

    public abstract <T> T as(Class<T> var1);

    public abstract String getName();

    public abstract boolean isReadable();

    public abstract boolean isWriteable();

    public String toString() {
        return "DebugValue(name=" + this.getName() + ", value = " + this.as(String.class) + ")";
    }

    static final class StackValue
    extends DebugValue {
        protected final DebugStackFrame origin;
        private final FrameSlot slot;

        StackValue(DebugStackFrame frame, FrameSlot slot) {
            this.origin = frame;
            this.slot = slot;
        }

        @Override
        public <T> T as(Class<T> clazz) {
            this.origin.verifyValidState();
            if (!this.isReadable()) {
                throw new IllegalStateException("Value is not readable");
            }
            if (clazz == String.class) {
                RootNode root = this.origin.findCurrentRoot();
                Object value = this.get();
                String stringValue = root == null ? value.toString() : this.origin.event.getSession().getDebugger().getEnv().toString(root, this.get());
                return (T)stringValue;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        Class<? extends TruffleLanguage> getLanguage() {
            return this.origin.findCurrentLanguage();
        }

        @Override
        Object get() {
            this.origin.verifyValidState();
            return this.origin.findTruffleFrame().getValue(this.slot);
        }

        @Override
        public void set(DebugValue value) {
            this.origin.verifyValidState();
            if (value.getLanguage() != this.getLanguage()) {
                throw new IllegalStateException(String.format("Languages of set values do not match %s != %s.", value.getLanguage(), this.getLanguage()));
            }
            MaterializedFrame frame = this.origin.findTruffleFrame();
            frame.setObject(this.slot, value.get());
        }

        @Override
        public String getName() {
            return this.slot.getIdentifier().toString();
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWriteable() {
            return true;
        }
    }

    static final class HeapValue
    extends DebugValue {
        private final Debugger debugger;
        private final RootNode sourceRoot;
        private final Object value;

        HeapValue(Debugger debugger, RootNode root, Object value) {
            this.debugger = debugger;
            this.sourceRoot = root;
            this.value = value;
        }

        @Override
        Class<? extends TruffleLanguage> getLanguage() {
            return Debugger.ACCESSOR.findLanguage(this.sourceRoot);
        }

        @Override
        public <T> T as(Class<T> clazz) {
            if (!this.isReadable()) {
                throw new IllegalStateException("Value is not readable");
            }
            if (clazz == String.class) {
                String stringValue = this.sourceRoot == null ? this.value.toString() : this.debugger.getEnv().toString(this.sourceRoot, this.value);
                return (T)stringValue;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        Object get() {
            return this.value;
        }

        @Override
        public void set(DebugValue expression) {
            throw new IllegalStateException("Value is not writable");
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWriteable() {
            return false;
        }
    }
}

