/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.ISO8859_16Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.util.ByteList;
import org.jruby.util.encoding.ISO_8859_16;

public class EncodingManager {
    private static final int INITIAL_NUMBER_OF_ENCODINGS = EncodingDB.getEncodings().size();
    private final List<DynamicObject> ENCODING_LIST_BY_ENCODING_LIST_INDEX = new ArrayList<DynamicObject>(INITIAL_NUMBER_OF_ENCODINGS);
    private final List<DynamicObject> ENCODING_LIST_BY_ENCODING_INDEX = new ArrayList<DynamicObject>(INITIAL_NUMBER_OF_ENCODINGS);
    private final Map<String, DynamicObject> LOOKUP = new ConcurrentHashMap<String, DynamicObject>();
    private final RubyContext context;

    public EncodingManager(RubyContext context) {
        this.context = context;
    }

    @CompilerDirectives.TruffleBoundary
    private static DynamicObject newRubyEncoding(RubyContext context, Encoding encoding, byte[] name, int p, int end, boolean dummy) {
        Rope rope = StringOperations.ropeFromByteList(new ByteList(name, p, end, (Encoding)USASCIIEncoding.INSTANCE, false));
        Rope cachedRope = context.getRopeTable().getRope(rope.getBytes(), rope.getEncoding(), rope.getCodeRange());
        DynamicObject string = context.getFrozenStrings().getFrozenString(cachedRope);
        return Layouts.ENCODING.createEncoding(context.getCoreLibrary().getEncodingFactory(), encoding, string, dummy);
    }

    @CompilerDirectives.TruffleBoundary
    public Object[] getEncodingList() {
        return new ArrayList<DynamicObject>(this.ENCODING_LIST_BY_ENCODING_LIST_INDEX).toArray();
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject getRubyEncoding(String name) {
        return this.LOOKUP.get(name.toLowerCase(Locale.ENGLISH));
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject getRubyEncoding(int encodingListIndex) {
        return this.ENCODING_LIST_BY_ENCODING_LIST_INDEX.get(encodingListIndex);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject getRubyEncoding(Encoding encoding) {
        return this.ENCODING_LIST_BY_ENCODING_INDEX.get(encoding.getIndex());
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized DynamicObject defineEncoding(EncodingDB.Entry encodingEntry, byte[] name, int p, int end) {
        Encoding encoding = encodingEntry.getEncoding();
        DynamicObject rubyEncoding = EncodingManager.newRubyEncoding(this.context, encoding, name, p, end, encodingEntry.isDummy());
        assert (this.ENCODING_LIST_BY_ENCODING_LIST_INDEX.size() == encodingEntry.getIndex());
        this.ENCODING_LIST_BY_ENCODING_LIST_INDEX.add(rubyEncoding);
        while (encoding.getIndex() >= this.ENCODING_LIST_BY_ENCODING_INDEX.size()) {
            this.ENCODING_LIST_BY_ENCODING_INDEX.add(null);
        }
        this.ENCODING_LIST_BY_ENCODING_INDEX.set(encoding.getIndex(), rubyEncoding);
        this.LOOKUP.put(Layouts.ENCODING.getName(rubyEncoding).toString().toLowerCase(Locale.ENGLISH), rubyEncoding);
        return rubyEncoding;
    }

    @CompilerDirectives.TruffleBoundary
    public void defineAlias(int encodingListIndex, String name) {
        DynamicObject rubyEncoding = this.getRubyEncoding(encodingListIndex);
        this.LOOKUP.put(name.toLowerCase(Locale.ENGLISH), rubyEncoding);
    }

    public synchronized DynamicObject replicateEncoding(Encoding encoding, String name) {
        if (this.getRubyEncoding(name) != null) {
            return null;
        }
        EncodingDB.replicate((String)name, (String)new String(encoding.getName()));
        byte[] nameBytes = name.getBytes();
        EncodingDB.Entry entry = (EncodingDB.Entry)EncodingDB.getEncodings().get(nameBytes);
        return this.defineEncoding(entry, nameBytes, 0, nameBytes.length);
    }

    @CompilerDirectives.TruffleBoundary
    public Encoding getLocaleEncoding() {
        return this.context.getJRubyRuntime().getEncodingService().getLocaleEncoding();
    }

    @CompilerDirectives.TruffleBoundary
    public static Charset charsetForEncoding(Encoding encoding) {
        String encodingName = encoding.toString();
        if (encodingName.equals("ASCII-8BIT")) {
            return Charset.forName("ISO-8859-1");
        }
        if (encoding == ISO8859_16Encoding.INSTANCE) {
            return ISO_8859_16.INSTANCE;
        }
        try {
            return Charset.forName(encodingName);
        }
        catch (UnsupportedCharsetException uce) {
            throw new UnsupportedOperationException("no java.nio.charset.Charset found for encoding `" + encoding.toString() + "'", uce);
        }
    }
}

