/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg.text;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;
import java.util.Set;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.fop.complexscripts.bidi.UnicodeBidiAlgorithm;
import org.apache.fop.traits.Direction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BidiAttributedCharacterIterator
implements AttributedCharacterIterator {
    private AttributedCharacterIterator aci;

    protected BidiAttributedCharacterIterator(AttributedCharacterIterator aci) {
        this.aci = aci;
    }

    public BidiAttributedCharacterIterator(AttributedCharacterIterator aci, int defaultBidiLevel) {
        this(BidiAttributedCharacterIterator.annotateBidiLevels(aci, defaultBidiLevel));
    }

    private static AttributedCharacterIterator annotateBidiLevels(AttributedCharacterIterator aci, int defaultBidiLevel) {
        int start = aci.getBeginIndex();
        int end = aci.getEndIndex();
        int numChars = end - start;
        StringBuffer sb = new StringBuffer(numChars);
        for (int i = 0; i < numChars; ++i) {
            char ch = aci.setIndex(i);
            assert (ch != '\uffff');
            sb.append(ch);
        }
        int[] levels = UnicodeBidiAlgorithm.resolveLevels(sb, (defaultBidiLevel & 1) == 1 ? Direction.RL : Direction.LR);
        if (levels != null) {
            int runStart;
            assert (levels.length == numChars);
            AttributedString as = new AttributedString(aci, start, end);
            int runEnd = runStart = 0;
            int nextRunLevel = -1;
            int currRunLevel = -1;
            int n = levels.length;
            for (int i = 0; i < n; ++i) {
                nextRunLevel = levels[i];
                if (currRunLevel < 0) {
                    currRunLevel = nextRunLevel;
                    continue;
                }
                if (nextRunLevel == currRunLevel) continue;
                as.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.BIDI_LEVEL, new Integer(currRunLevel), runStart, i);
                runEnd = runStart = i;
                currRunLevel = nextRunLevel;
            }
            if (currRunLevel >= 0 && end > runStart) {
                as.addAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.BIDI_LEVEL, new Integer(currRunLevel), runStart, end);
            }
            return as.getIterator();
        }
        return aci;
    }

    @Override
    public char first() {
        return this.aci.first();
    }

    @Override
    public char last() {
        return this.aci.last();
    }

    @Override
    public char current() {
        return this.aci.current();
    }

    @Override
    public char next() {
        return this.aci.next();
    }

    @Override
    public char previous() {
        return this.aci.previous();
    }

    @Override
    public char setIndex(int position) {
        return this.aci.setIndex(position);
    }

    @Override
    public int getBeginIndex() {
        return this.aci.getBeginIndex();
    }

    @Override
    public int getEndIndex() {
        return this.aci.getEndIndex();
    }

    @Override
    public int getIndex() {
        return this.aci.getIndex();
    }

    @Override
    public Object clone() {
        return new BidiAttributedCharacterIterator((AttributedCharacterIterator)this.aci.clone());
    }

    @Override
    public int getRunStart() {
        return this.aci.getRunStart();
    }

    @Override
    public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
        return this.aci.getRunStart(attribute);
    }

    @Override
    public int getRunStart(Set<? extends AttributedCharacterIterator.Attribute> attributes) {
        return this.aci.getRunStart(attributes);
    }

    @Override
    public int getRunLimit() {
        return this.aci.getRunLimit();
    }

    @Override
    public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
        return this.aci.getRunLimit(attribute);
    }

    @Override
    public int getRunLimit(Set<? extends AttributedCharacterIterator.Attribute> attributes) {
        return this.aci.getRunLimit(attributes);
    }

    @Override
    public Map<AttributedCharacterIterator.Attribute, Object> getAttributes() {
        return this.aci.getAttributes();
    }

    @Override
    public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
        return this.aci.getAttribute(attribute);
    }

    @Override
    public Set<AttributedCharacterIterator.Attribute> getAllAttributeKeys() {
        return this.aci.getAllAttributeKeys();
    }
}

