/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.numeric;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jruby.truffle.core.numeric.TruffleFixnumNodes;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=TruffleFixnumNodes.class)
public final class TruffleFixnumNodesFactory {
    public static List<NodeFactory<TruffleFixnumNodes.LowerPrimitiveNode>> getFactories() {
        return Collections.singletonList(LowerPrimitiveNodeFactory.getInstance());
    }

    @GeneratedBy(value=TruffleFixnumNodes.LowerPrimitiveNode.class)
    public static final class LowerPrimitiveNodeFactory
    implements NodeFactory<TruffleFixnumNodes.LowerPrimitiveNode> {
        private static LowerPrimitiveNodeFactory lowerPrimitiveNodeFactoryInstance;

        private LowerPrimitiveNodeFactory() {
        }

        @Override
        public Class<TruffleFixnumNodes.LowerPrimitiveNode> getNodeClass() {
            return TruffleFixnumNodes.LowerPrimitiveNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class));
        }

        @Override
        public TruffleFixnumNodes.LowerPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return LowerPrimitiveNodeFactory.create((RubyNode)arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TruffleFixnumNodes.LowerPrimitiveNode> getInstance() {
            if (lowerPrimitiveNodeFactoryInstance == null) {
                lowerPrimitiveNodeFactoryInstance = new LowerPrimitiveNodeFactory();
            }
            return lowerPrimitiveNodeFactoryInstance;
        }

        public static TruffleFixnumNodes.LowerPrimitiveNode create(RubyNode operand) {
            return new LowerPrimitiveNodeGen(operand);
        }

        @GeneratedBy(value=TruffleFixnumNodes.LowerPrimitiveNode.class)
        public static final class LowerPrimitiveNodeGen
        extends TruffleFixnumNodes.LowerPrimitiveNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private Class<?> operandType_;
            @Node.Child
            private BaseNode_ specialization_;

            private LowerPrimitiveNodeGen(RubyNode operand) {
                this.operand_ = operand;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="lowerFails(long)", value=TruffleFixnumNodes.LowerPrimitiveNode.class)
            private static final class LowerFailsNode_
            extends BaseNode_ {
                private final Class<?> operandImplicitType;

                LowerFailsNode_(LowerPrimitiveNodeGen root, Object operandValue) {
                    super(root, 3);
                    this.operandImplicitType = RubyTypesGen.getImplicitLongClass(operandValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.operandImplicitType == ((LowerFailsNode_)other).operandImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long operandValue_;
                    try {
                        operandValue_ = this.executeOperandLong_(frameValue, this.operandImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return LowerPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (!TruffleFixnumNodes.LowerPrimitiveNode.canLower(operandValue_)) {
                        return this.root.lowerFails(operandValue_);
                    }
                    return LowerPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, operandValue_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object operandValue) {
                    long operandValue_;
                    if (RubyTypesGen.isImplicitLong(operandValue, this.operandImplicitType) && !TruffleFixnumNodes.LowerPrimitiveNode.canLower(operandValue_ = RubyTypesGen.asImplicitLong(operandValue, this.operandImplicitType))) {
                        return this.root.lowerFails(operandValue_);
                    }
                    return this.getNext().execute_(frameValue, operandValue);
                }

                static BaseNode_ create(LowerPrimitiveNodeGen root, Object operandValue) {
                    return new LowerFailsNode_(root, operandValue);
                }
            }

            @GeneratedBy(methodName="lower(long)", value=TruffleFixnumNodes.LowerPrimitiveNode.class)
            private static final class Lower1Node_
            extends BaseNode_ {
                private final Class<?> operandImplicitType;

                Lower1Node_(LowerPrimitiveNodeGen root, Object operandValue) {
                    super(root, 2);
                    this.operandImplicitType = RubyTypesGen.getImplicitLongClass(operandValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.operandImplicitType == ((Lower1Node_)other).operandImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    long operandValue_;
                    try {
                        operandValue_ = this.executeOperandLong_(frameValue, this.operandImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return LowerPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (TruffleFixnumNodes.LowerPrimitiveNode.canLower(operandValue_)) {
                        return this.root.lower(operandValue_);
                    }
                    return LowerPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, operandValue_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object operandValue) {
                    long operandValue_;
                    if (RubyTypesGen.isImplicitLong(operandValue, this.operandImplicitType) && TruffleFixnumNodes.LowerPrimitiveNode.canLower(operandValue_ = RubyTypesGen.asImplicitLong(operandValue, this.operandImplicitType))) {
                        return this.root.lower(operandValue_);
                    }
                    return this.getNext().execute_(frameValue, operandValue);
                }

                static BaseNode_ create(LowerPrimitiveNodeGen root, Object operandValue) {
                    return new Lower1Node_(root, operandValue);
                }
            }

            @GeneratedBy(methodName="lower(int)", value=TruffleFixnumNodes.LowerPrimitiveNode.class)
            private static final class Lower0Node_
            extends BaseNode_ {
                private final Class<?> operandImplicitType;

                Lower0Node_(LowerPrimitiveNodeGen root, Object operandValue) {
                    super(root, 1);
                    this.operandImplicitType = RubyTypesGen.getImplicitIntegerClass(operandValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.operandImplicitType == ((Lower0Node_)other).operandImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int operandValue_;
                    try {
                        if (this.operandImplicitType == Integer.TYPE) {
                            operandValue_ = this.root.operand_.executeInteger(frameValue);
                        } else {
                            Object operandValue__ = this.executeOperand_(frameValue);
                            operandValue_ = RubyTypesGen.expectImplicitInteger(operandValue__, this.operandImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return LowerPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.lower(operandValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object operandValue) {
                    if (RubyTypesGen.isImplicitInteger(operandValue, this.operandImplicitType)) {
                        int operandValue_ = RubyTypesGen.asImplicitInteger(operandValue, this.operandImplicitType);
                        return this.root.lower(operandValue_);
                    }
                    return this.getNext().execute_(frameValue, operandValue);
                }

                static BaseNode_ create(LowerPrimitiveNodeGen root, Object operandValue) {
                    return new Lower0Node_(root, operandValue);
                }
            }

            @GeneratedBy(value=TruffleFixnumNodes.LowerPrimitiveNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LowerPrimitiveNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object operandValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, operandValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object operandValue) {
                    return this.getNext().execute_(frameValue, operandValue);
                }

                static BaseNode_ create(LowerPrimitiveNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=TruffleFixnumNodes.LowerPrimitiveNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LowerPrimitiveNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object operandValue) {
                    return this.uninitialized((Frame)frameValue, operandValue);
                }

                static BaseNode_ create(LowerPrimitiveNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=TruffleFixnumNodes.LowerPrimitiveNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected LowerPrimitiveNodeGen root;

                BaseNode_(LowerPrimitiveNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (LowerPrimitiveNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.operand_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object operandValue) {
                    return this.execute_((VirtualFrame)frameValue, operandValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object operandValue_ = this.executeOperand_(frameValue);
                    return this.execute_(frameValue, operandValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return LowerPrimitiveNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return LowerPrimitiveNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object operandValue) {
                    if (RubyTypesGen.isImplicitInteger(operandValue)) {
                        return Lower0Node_.create(this.root, operandValue);
                    }
                    if (RubyTypesGen.isImplicitLong(operandValue)) {
                        long operandValue_ = RubyTypesGen.asImplicitLong(operandValue);
                        if (TruffleFixnumNodes.LowerPrimitiveNode.canLower(operandValue_)) {
                            return Lower1Node_.create(this.root, operandValue);
                        }
                        return LowerFailsNode_.create(this.root, operandValue);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeOperand_(Frame frameValue) {
                    Object object;
                    Class operandType_ = this.root.operandType_;
                    if (operandType_ == Integer.TYPE) {
                        return this.root.operand_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (operandType_ == Long.TYPE) {
                        return this.root.operand_.executeLong((VirtualFrame)frameValue);
                    }
                    if (operandType_ != null) return this.root.operand_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.operand_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.operandType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.operandType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.operandType_ = _type;
                    return object;
                }

                protected final long executeOperandLong_(Frame frameValue, Class<?> operandImplicitType) throws UnexpectedResultException {
                    if (operandImplicitType == Long.TYPE) {
                        return this.root.operand_.executeLong((VirtualFrame)frameValue);
                    }
                    if (operandImplicitType == Integer.TYPE) {
                        return RubyTypes.promoteToLong(this.root.operand_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object operandValue_ = this.executeOperand_(frameValue);
                    return RubyTypesGen.expectImplicitLong(operandValue_, operandImplicitType);
                }
            }
        }
    }
}

