/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import java.util.IllegalFormatConversionException;
import java.util.Iterator;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.util.BytesHash;
import org.joni.Analyser;
import org.joni.Matcher;
import org.joni.MatcherFactory;
import org.joni.MinMaxLen;
import org.joni.NameEntry;
import org.joni.OptAnchorInfo;
import org.joni.OptExactInfo;
import org.joni.OptMapInfo;
import org.joni.Option;
import org.joni.Region;
import org.joni.ScanEnvironment;
import org.joni.SearchAlgorithm;
import org.joni.Syntax;
import org.joni.WarnCallback;
import org.joni.exception.InternalException;
import org.joni.exception.ValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Regex {
    int[] code;
    int codeLength;
    boolean requireStack;
    Object[] operands;
    int operandLength;
    int numMem;
    int numRepeat;
    int numNullCheck;
    int numCombExpCheck;
    int numCall;
    int captureHistory;
    int btMemStart;
    int btMemEnd;
    int stackPopLevel;
    int[] repeatRangeLo;
    int[] repeatRangeHi;
    public WarnCallback warnings;
    public MatcherFactory factory;
    final Encoding enc;
    int options;
    int userOptions;
    Object userObject;
    final int caseFoldFlag;
    BytesHash<NameEntry> nameTable;
    SearchAlgorithm searchAlgorithm;
    int thresholdLength;
    int anchor;
    int anchorDmin;
    int anchorDmax;
    int subAnchor;
    byte[] exact;
    int exactP;
    int exactEnd;
    byte[] map;
    int[] intMap;
    int[] intMapBackward;
    int dMin;
    int dMax;
    byte[][] templates;
    int templateNum;

    public Regex(CharSequence cs) {
        this(cs.toString());
    }

    public Regex(CharSequence cs, Encoding enc) {
        this(cs.toString(), enc);
    }

    public Regex(String str) {
        this(str.getBytes(), 0, str.length(), 0, UTF8Encoding.INSTANCE);
    }

    public Regex(String str, Encoding enc) {
        this(str.getBytes(), 0, str.length(), 0, enc);
    }

    public Regex(byte[] bytes2) {
        this(bytes2, 0, bytes2.length, 0, ASCIIEncoding.INSTANCE);
    }

    public Regex(byte[] bytes2, int p2, int end2) {
        this(bytes2, p2, end2, 0, ASCIIEncoding.INSTANCE);
    }

    public Regex(byte[] bytes2, int p2, int end2, int option) {
        this(bytes2, p2, end2, option, ASCIIEncoding.INSTANCE);
    }

    public Regex(byte[] bytes2, int p2, int end2, int option, Encoding enc) {
        this(bytes2, p2, end2, option, enc, Syntax.RUBY, WarnCallback.DEFAULT);
    }

    public Regex(byte[] bytes2, int p2, int end2, int option, Encoding enc, Syntax syntax) {
        this(bytes2, p2, end2, option, 0x40000000, enc, syntax, WarnCallback.DEFAULT);
    }

    public Regex(byte[] bytes2, int p2, int end2, int option, Encoding enc, WarnCallback warnings) {
        this(bytes2, p2, end2, option, enc, Syntax.RUBY, warnings);
    }

    public Regex(byte[] bytes2, int p2, int end2, int option, Encoding enc, Syntax syntax, WarnCallback warnings) {
        this(bytes2, p2, end2, option, 0x40000000, enc, syntax, warnings);
    }

    public Regex(byte[] bytes2, int p2, int end2, int option, int caseFoldFlag, Encoding enc, Syntax syntax, WarnCallback warnings) {
        if ((option & 0x180) == 384) {
            throw new ValueException("invalid combination of options");
        }
        if ((option & 0x40) != 0) {
            option |= syntax.options;
            option &= 0xFFFFFFF7;
        } else {
            option |= syntax.options;
        }
        this.enc = enc;
        this.options = option;
        this.caseFoldFlag = caseFoldFlag;
        this.warnings = warnings;
        new Analyser(new ScanEnvironment(this, syntax), bytes2, p2, end2).compile();
        this.warnings = null;
    }

    public Matcher matcher(byte[] bytes2) {
        return this.matcher(bytes2, 0, bytes2.length);
    }

    public Matcher matcher(byte[] bytes2, int p2, int end2) {
        return this.factory.create(this, bytes2, p2, end2);
    }

    public int numberOfCaptures() {
        return this.numMem;
    }

    public int numberOfCaptureHistories() {
        return 0;
    }

    String nameTableToString() {
        StringBuilder sb = new StringBuilder();
        if (this.nameTable != null) {
            sb.append("name table\n");
            for (NameEntry ne : this.nameTable) {
                sb.append("  " + ne + "\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    NameEntry nameFind(byte[] name2, int nameP, int nameEnd) {
        if (this.nameTable != null) {
            return this.nameTable.get(name2, nameP, nameEnd);
        }
        return null;
    }

    void renumberNameTable(int[] map2) {
        if (this.nameTable != null) {
            for (NameEntry e : this.nameTable) {
                if (e.backNum > 1) {
                    for (int i2 = 0; i2 < e.backNum; ++i2) {
                        e.backRefs[i2] = map2[e.backRefs[i2]];
                    }
                    continue;
                }
                if (e.backNum != 1) continue;
                e.backRef1 = map2[e.backRef1];
            }
        }
    }

    public int numberOfNames() {
        return this.nameTable == null ? 0 : this.nameTable.size();
    }

    void nameAdd(byte[] name2, int nameP, int nameEnd, int backRef, Syntax syntax) {
        if (nameEnd - nameP <= 0) {
            throw new ValueException("group name is empty");
        }
        NameEntry e = null;
        if (this.nameTable == null) {
            this.nameTable = new BytesHash();
        } else {
            e = this.nameFind(name2, nameP, nameEnd);
        }
        if (e == null) {
            e = new NameEntry(name2, nameP, nameEnd);
            this.nameTable.putDirect(name2, nameP, nameEnd, e);
        } else if (e.backNum >= 1 && !syntax.allowMultiplexDefinitionName()) {
            throw new ValueException("multiplex defined name <%n>", new String(name2, nameP, nameEnd - nameP));
        }
        e.addBackref(backRef);
    }

    NameEntry nameToGroupNumbers(byte[] name2, int nameP, int nameEnd) {
        return this.nameFind(name2, nameP, nameEnd);
    }

    public int nameToBackrefNumber(byte[] name2, int nameP, int nameEnd, Region region) {
        NameEntry e = this.nameToGroupNumbers(name2, nameP, nameEnd);
        if (e == null) {
            throw new ValueException("undefined name <%n> reference", new String(name2, nameP, nameEnd - nameP));
        }
        switch (e.backNum) {
            case 0: {
                throw new InternalException("internal parser error (bug)");
            }
            case 1: {
                return e.backRef1;
            }
        }
        if (region != null) {
            for (int i2 = e.backNum - 1; i2 >= 0; --i2) {
                if (region.beg[e.backRefs[i2]] == -1) continue;
                return e.backRefs[i2];
            }
        }
        return e.backRefs[e.backNum - 1];
    }

    public Iterator<NameEntry> namedBackrefIterator() {
        return this.nameTable.iterator();
    }

    public boolean noNameGroupIsActive(Syntax syntax) {
        if (Option.isDontCaptureGroup(this.options)) {
            return false;
        }
        return this.numberOfNames() <= 0 || !syntax.captureOnlyNamedGroup() || Option.isCaptureGroup(this.options);
    }

    void setupBMSkipMap() {
        byte[] bytes2 = this.exact;
        int end2 = this.exactEnd;
        int p2 = this.exactP;
        int len = end2 - p2;
        if (len < 256) {
            int i2;
            if (this.map == null) {
                this.map = new byte[256];
            }
            for (i2 = 0; i2 < 256; ++i2) {
                this.map[i2] = (byte)len;
            }
            for (i2 = 0; i2 < len - 1; ++i2) {
                this.map[bytes2[p2 + i2] & 0xFF] = (byte)(len - 1 - i2);
            }
        } else {
            if (this.intMap == null) {
                this.intMap = new int[256];
            }
            for (int i3 = 0; i3 < len - 1; ++i3) {
                this.intMap[bytes2[p2 + i3] & 0xFF] = len - 1 - i3;
            }
        }
    }

    void setExactInfo(OptExactInfo e) {
        if (e.length == 0) {
            return;
        }
        this.exact = e.bytes;
        this.exactP = 0;
        this.exactEnd = e.length;
        if (e.ignoreCase) {
            this.searchAlgorithm = this.enc.toLowerCaseTable() != null ? SearchAlgorithm.SLOW_IC_SB : SearchAlgorithm.SLOW_IC;
        } else {
            boolean allowReverse = this.enc.isReverseMatchAllowed(this.exact, this.exactP, this.exactEnd);
            if (e.length >= 3 || e.length >= 2 && allowReverse) {
                this.setupBMSkipMap();
                this.searchAlgorithm = allowReverse ? SearchAlgorithm.BM : SearchAlgorithm.BM_NOT_REV;
            } else {
                this.searchAlgorithm = this.enc.isSingleByte() ? SearchAlgorithm.SLOW_SB : SearchAlgorithm.SLOW;
            }
        }
        this.dMin = e.mmd.min;
        this.dMax = e.mmd.max;
        if (this.dMin != Integer.MAX_VALUE) {
            this.thresholdLength = this.dMin + (this.exactEnd - this.exactP);
        }
    }

    void setOptimizeMapInfo(OptMapInfo m) {
        this.map = m.map;
        this.searchAlgorithm = this.enc.isSingleByte() ? SearchAlgorithm.MAP_SB : SearchAlgorithm.MAP;
        this.dMin = m.mmd.min;
        this.dMax = m.mmd.max;
        if (this.dMin != Integer.MAX_VALUE) {
            this.thresholdLength = this.dMin + 1;
        }
    }

    void setSubAnchor(OptAnchorInfo anc) {
        this.subAnchor |= anc.leftAnchor & 2;
        this.subAnchor |= anc.rightAnchor & 0x20;
    }

    void clearOptimizeInfo() {
        this.searchAlgorithm = SearchAlgorithm.NONE;
        this.anchor = 0;
        this.anchorDmax = 0;
        this.anchorDmin = 0;
        this.subAnchor = 0;
        this.exact = null;
        this.exactEnd = 0;
        this.exactP = 0;
    }

    public String encStringToString(byte[] bytes2, int p2, int end2) {
        StringBuilder sb = new StringBuilder("\nPATTERN: /");
        if (this.enc.minLength() > 1) {
            for (int p_ = p2; p_ < end2; p_ += this.enc.length(bytes2, p_, end2)) {
                int code = this.enc.mbcToCode(bytes2, p_, end2);
                if (code >= 128) {
                    try {
                        sb.append(String.format(" 0x%04x ", code));
                    }
                    catch (IllegalFormatConversionException ifce) {
                        sb.append(code);
                    }
                    continue;
                }
                sb.append((char)code);
            }
        } else {
            while (p2 < end2) {
                sb.append(new String(new byte[]{bytes2[p2]}));
                ++p2;
            }
        }
        return sb.append("/").toString();
    }

    public String optimizeInfoToString() {
        String s2 = "";
        s2 = s2 + "optimize: " + this.searchAlgorithm.getName() + "\n";
        s2 = s2 + "  anchor:     " + OptAnchorInfo.anchorToString(this.anchor);
        if ((this.anchor & 0x18) != 0) {
            s2 = s2 + MinMaxLen.distanceRangeToString(this.anchorDmin, this.anchorDmax);
        }
        s2 = s2 + "\n";
        if (this.searchAlgorithm != SearchAlgorithm.NONE) {
            s2 = s2 + "  sub anchor: " + OptAnchorInfo.anchorToString(this.subAnchor) + "\n";
        }
        s2 = s2 + "dmin: " + this.dMin + " dmax: " + this.dMax + "\n";
        s2 = s2 + "threshold length: " + this.thresholdLength + "\n";
        if (this.exact != null) {
            s2 = s2 + "exact: [" + new String(this.exact, this.exactP, this.exactEnd - this.exactP) + "]: length: " + (this.exactEnd - this.exactP) + "\n";
        } else if (this.searchAlgorithm == SearchAlgorithm.MAP || this.searchAlgorithm == SearchAlgorithm.MAP_SB) {
            int n = 0;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (this.map[i2] == 0) continue;
                ++n;
            }
            s2 = s2 + "map: n = " + n + "\n";
            if (n > 0) {
                int c = 0;
                s2 = s2 + "[";
                for (int i3 = 0; i3 < 256; ++i3) {
                    if (this.map[i3] == 0) continue;
                    if (c > 0) {
                        s2 = s2 + ", ";
                    }
                    ++c;
                    s2 = this.enc.maxLength() == 1 && this.enc.isPrint(i3) ? s2 + (char)i3 : s2 + i3;
                }
                s2 = s2 + "]\n";
            }
        }
        return s2;
    }

    public Encoding getEncoding() {
        return this.enc;
    }

    public int getOptions() {
        return this.options;
    }

    public void setUserOptions(int options2) {
        this.userOptions = options2;
    }

    public int getUserOptions() {
        return this.userOptions;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }
}

