/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control;

import com.baselet.control.StringStyle;
import com.baselet.control.basics.geom.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedUtils {
    private static final Logger log = LoggerFactory.getLogger(SharedUtils.class);

    public static int realignToGrid(double d) {
        return SharedUtils.realignTo(true, d, false, 10);
    }

    public static Rectangle realignToGrid(Rectangle rectangle, boolean realignHeightAndWidth) {
        int x = SharedUtils.realignToGrid(false, rectangle.getX(), false);
        int y = SharedUtils.realignToGrid(false, rectangle.getY(), false);
        if (realignHeightAndWidth) {
            int width = SharedUtils.realignToGrid(false, rectangle.getX() - x + rectangle.getWidth(), true);
            int height = SharedUtils.realignToGrid(false, rectangle.getY() - y + rectangle.getHeight(), true);
            return new Rectangle(x, y, width, height);
        }
        return new Rectangle(x, y, rectangle.getWidth(), rectangle.getHeight());
    }

    public static int realignToGridRoundToNearest(boolean logRealign, double val) {
        boolean roundUp = Math.abs(val % 10.0) < 5.0 ? val < 0.0 : val >= 0.0;
        return SharedUtils.realignTo(logRealign, val, roundUp, 10);
    }

    public static int realignToGrid(boolean logRealign, double val, boolean roundUp) {
        return SharedUtils.realignTo(logRealign, val, roundUp, 10);
    }

    public static int realignTo(boolean logRealign, double val, boolean roundUp, int gridSize) {
        double alignedVal = val;
        double mod = val % (double)gridSize;
        if (mod != 0.0) {
            alignedVal -= mod;
            if (val > 0.0 && roundUp) {
                alignedVal += (double)gridSize;
            }
            if (val < 0.0 && !roundUp) {
                alignedVal -= (double)gridSize;
            }
            if (logRealign) {
                log.error("realignToGrid from " + val + " to " + alignedVal);
            }
        }
        return (int)alignedVal;
    }

    public static String listToString(String sep, Collection<?> list) {
        return SharedUtils.listToStringHelper(new StringBuilder(), sep, list).toString();
    }

    private static StringBuilder listToStringHelper(StringBuilder sb, String sep, Collection<?> list) {
        for (Object line : list) {
            sb.append(line).append(sep);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - sep.length());
        }
        return sb;
    }

    public static String mapToString(Map<?, ?> map) {
        return SharedUtils.mapToString("\n", ",", map);
    }

    public static String mapToString(String mapSep, String listSep, Map<?, ?> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, ?> e : map.entrySet()) {
            sb.append(e.getKey()).append(": ");
            if (e.getValue() instanceof Collection) {
                SharedUtils.listToStringHelper(sb, listSep, (Collection)e.getValue());
            } else {
                sb.append(e.getValue().toString());
            }
            sb.append(mapSep);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - mapSep.length());
        }
        return sb.toString();
    }

    public static <T> List<T> mergeLists(List<T> listA, List<T> listB, List<T> listC) {
        ArrayList<T> returnList = new ArrayList<T>(listA);
        returnList.addAll(listB);
        returnList.addAll(listC);
        return Collections.unmodifiableList(returnList);
    }

    public static Double[][] cloneArray(Double[][] src) {
        int length = src.length;
        Double[][] target = new Double[length][src[0].length];
        int i = 0;
        while (i < length) {
            System.arraycopy(src[i], 0, target[i], 0, src[i].length);
            ++i;
        }
        return target;
    }

    public static String[] cloneArray(String[] src) {
        String[] target = new String[src.length];
        System.arraycopy(src, 0, target, 0, src.length);
        return target;
    }

    public static int[] cloneArray(int[] src) {
        int[] target = new int[src.length];
        System.arraycopy(src, 0, target, 0, src.length);
        return target;
    }

    public static String[] splitAtLineEndChar(String text) {
        String rep = StringStyle.replaceNotEscaped(text, "\\n", "\n");
        if (rep.contains("\n")) {
            String[] split = rep.split("\n");
            return split;
        }
        return new String[]{text};
    }
}

