/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.Script;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorer;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.control.messages.Message;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.ClassPermission;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.script.ScoreAccessor;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;

public class GroovyScriptEngineService
extends AbstractComponent
implements ScriptEngineService {
    public static final String NAME = "groovy";
    public static final String GROOVY_INDY_SETTING_NAME = "indy";
    private final ClassLoader loader;

    public GroovyScriptEngineService(Settings settings) {
        super(settings);
        this.deprecationLogger.deprecated("[groovy] scripts are deprecated, use [painless] scripts instead", new Object[0]);
        final SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        this.loader = AccessController.doPrivileged(() -> {
            final AccessControlContext context = AccessController.getContext();
            return new ClassLoader(((Object)((Object)this)).getClass().getClassLoader()){

                @Override
                protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                    if (sm != null) {
                        try {
                            context.checkPermission((Permission)new ClassPermission(name));
                        }
                        catch (SecurityException e) {
                            throw new ClassNotFoundException(name, e);
                        }
                    }
                    return super.loadClass(name, resolve);
                }
            };
        });
    }

    public void close() throws IOException {
    }

    public String getType() {
        return NAME;
    }

    public String getExtension() {
        return NAME;
    }

    public Object compile(String scriptName, String scriptSource, Map<String, String> params) {
        String className = MessageDigests.toHexString((byte[])MessageDigests.sha1().digest(scriptSource.getBytes(StandardCharsets.UTF_8)));
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        return AccessController.doPrivileged(() -> {
            try {
                GroovyCodeSource codeSource = new GroovyCodeSource(scriptSource, className, "/untrusted");
                codeSource.setCachable(false);
                CompilerConfiguration configuration = new CompilerConfiguration().addCompilationCustomizers(new CompilationCustomizer[]{new ImportCustomizer().addStarImports(new String[]{"org.joda.time"}).addStaticStars(new String[]{"java.lang.Math"})}).addCompilationCustomizers(new CompilationCustomizer[]{new GroovyBigDecimalTransformer(CompilePhase.CONVERSION)});
                configuration.getOptimizationOptions().put(GROOVY_INDY_SETTING_NAME, true);
                GroovyClassLoader groovyClassLoader = new GroovyClassLoader(this.loader, configuration);
                return groovyClassLoader.parseClass(codeSource);
            }
            catch (Exception e) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Exception compiling Groovy script:", (Throwable)e);
                }
                throw this.convertToScriptException("Error compiling script " + className, scriptSource, e);
            }
        });
    }

    private Script createScript(Object compiledScript, Map<String, Object> vars) throws ReflectiveOperationException {
        Class scriptClass = (Class)compiledScript;
        Script scriptObject = (Script)scriptClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        Binding binding = new Binding();
        binding.getVariables().putAll(vars);
        scriptObject.setBinding(binding);
        return scriptObject;
    }

    public ExecutableScript executable(CompiledScript compiledScript, Map<String, Object> vars) {
        this.deprecationLogger.deprecated("[groovy] scripts are deprecated, use [painless] scripts instead", new Object[0]);
        try {
            HashMap<String, Object> allVars = new HashMap<String, Object>();
            if (vars != null) {
                allVars.putAll(vars);
            }
            return new GroovyScript(compiledScript, this.createScript(compiledScript.compiled(), allVars), this.logger);
        }
        catch (ReflectiveOperationException e) {
            throw this.convertToScriptException("Failed to build executable script", compiledScript.name(), e);
        }
    }

    public SearchScript search(final CompiledScript compiledScript, final SearchLookup lookup, final @Nullable Map<String, Object> vars) {
        this.deprecationLogger.deprecated("[groovy] scripts are deprecated, use [painless] scripts instead", new Object[0]);
        return new SearchScript(){

            public LeafSearchScript getLeafSearchScript(LeafReaderContext context) throws IOException {
                Script scriptObject;
                LeafSearchLookup leafLookup = lookup.getLeafSearchLookup(context);
                HashMap allVars = new HashMap();
                allVars.putAll(leafLookup.asMap());
                if (vars != null) {
                    allVars.putAll(vars);
                }
                try {
                    scriptObject = GroovyScriptEngineService.this.createScript(compiledScript.compiled(), allVars);
                }
                catch (ReflectiveOperationException e) {
                    throw GroovyScriptEngineService.this.convertToScriptException("Failed to build search script", compiledScript.name(), e);
                }
                return new GroovyScript(compiledScript, scriptObject, leafLookup, GroovyScriptEngineService.this.logger);
            }

            public boolean needsScores() {
                return true;
            }
        };
    }

    private ScriptException convertToScriptException(String message, String source, Throwable cause) {
        ArrayList<String> stack = new ArrayList<String>();
        if (cause instanceof MultipleCompilationErrorsException) {
            List errors = ((MultipleCompilationErrorsException)cause).getErrorCollector().getErrors();
            for (Message error : errors) {
                try {
                    StringWriter writer = new StringWriter();
                    Throwable throwable = null;
                    try {
                        error.write(new PrintWriter(writer));
                        stack.add(writer.toString());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (writer == null) continue;
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        writer.close();
                    }
                }
                catch (IOException e1) {
                    this.logger.error("failed to write compilation error message to the stack", (Throwable)e1);
                }
            }
        } else if (cause instanceof CompilationFailedException) {
            CompilationFailedException error = (CompilationFailedException)cause;
            stack.add(error.getMessage());
        }
        throw new ScriptException(message, cause, stack, source, NAME);
    }

    private class BigDecimalExpressionTransformer
    extends ClassCodeExpressionTransformer {
        private final SourceUnit source;

        private BigDecimalExpressionTransformer(SourceUnit source) {
            this.source = source;
        }

        protected SourceUnit getSourceUnit() {
            return this.source;
        }

        public Expression transform(Expression expr) {
            ConstantExpression constExpr;
            Object val;
            Expression newExpr = expr;
            if (expr instanceof ConstantExpression && (val = (constExpr = (ConstantExpression)expr).getValue()) != null && val instanceof BigDecimal) {
                newExpr = new ConstantExpression((Object)((BigDecimal)val).doubleValue());
            }
            return super.transform(newExpr);
        }
    }

    private class GroovyBigDecimalTransformer
    extends CompilationCustomizer {
        private GroovyBigDecimalTransformer(CompilePhase phase) {
            super(phase);
        }

        public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
            new BigDecimalExpressionTransformer(source).visitClass(classNode);
        }
    }

    public static final class GroovyScript
    implements ExecutableScript,
    LeafSearchScript {
        private final CompiledScript compiledScript;
        private final Script script;
        private final LeafSearchLookup lookup;
        private final Map<String, Object> variables;
        private final Logger logger;

        public GroovyScript(CompiledScript compiledScript, Script script, Logger logger) {
            this(compiledScript, script, null, logger);
        }

        public GroovyScript(CompiledScript compiledScript, Script script, @Nullable LeafSearchLookup lookup, Logger logger) {
            this.compiledScript = compiledScript;
            this.script = script;
            this.lookup = lookup;
            this.logger = logger;
            this.variables = script.getBinding().getVariables();
        }

        public void setScorer(Scorer scorer) {
            this.variables.put("_score", new ScoreAccessor(scorer));
        }

        public void setDocument(int doc) {
            if (this.lookup != null) {
                this.lookup.setDocument(doc);
            }
        }

        public void setNextVar(String name, Object value) {
            this.variables.put(name, value);
        }

        public void setSource(Map<String, Object> source) {
            if (this.lookup != null) {
                this.lookup.source().setSource(source);
            }
        }

        public Object run() {
            try {
                return AccessController.doPrivileged(() -> ((Script)this.script).run());
            }
            catch (AssertionError ae) {
                if (ae instanceof GroovyBugError) {
                    String message = "encountered bug in Groovy while executing script [" + this.compiledScript.name() + "]";
                    throw new ScriptException(message, (Throwable)((Object)ae), Collections.emptyList(), this.compiledScript.toString(), this.compiledScript.lang());
                }
                StackTraceElement[] elements = ((Throwable)((Object)ae)).getStackTrace();
                if (elements.length > 0 && "org.codehaus.groovy.runtime.InvokerHelper".equals(elements[0].getClassName())) {
                    this.logger.debug(() -> new ParameterizedMessage("failed to run {}", (Object)this.compiledScript), (Throwable)((Object)ae));
                    throw new ScriptException("error evaluating " + this.compiledScript.name(), (Throwable)((Object)ae), Collections.emptyList(), "", this.compiledScript.lang());
                }
                throw ae;
            }
            catch (Exception | NoClassDefFoundError e) {
                this.logger.trace(() -> new ParameterizedMessage("failed to run {}", (Object)this.compiledScript), e);
                throw new ScriptException("error evaluating " + this.compiledScript.name(), e, Collections.emptyList(), "", this.compiledScript.lang());
            }
        }

        public long runAsLong() {
            return ((Number)this.run()).longValue();
        }

        public double runAsDouble() {
            return ((Number)this.run()).doubleValue();
        }
    }
}

