/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.representations;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.ir.Tuple;
import org.jruby.ir.instructions.BranchInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.JumpTargetInstr;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;

public class IGVCFGVisitor {
    PrintStream writer;
    Map<BasicBlock, Integer> indexOffsets = new HashMap<BasicBlock, Integer>();
    List<Tuple<Integer, Integer>> instrEdges = new ArrayList<Tuple<Integer, Integer>>();
    List<Tuple<Integer, JumpTargetInstr>> extraInstrEdges = new ArrayList<Tuple<Integer, JumpTargetInstr>>();
    int instrIndex = 0;

    private void property(String name2, Object content) {
        this.startTag("p", "name", name2);
        this.writer.print(content.toString().replace("<", "&lt;"));
        this.endTag("p");
    }

    private void emptyTag(String name2, Object ... attributes) {
        this.writer.print("<" + name2 + " ");
        for (int i2 = 0; i2 < attributes.length; i2 += 2) {
            this.writer.print(attributes[i2]);
            this.writer.print("=\"");
            this.writer.print(attributes[i2 + 1]);
            this.writer.print("\" ");
        }
        this.writer.println("/>");
    }

    private void startTag(String name2) {
        this.writer.println("<" + name2 + ">");
    }

    private void startTag(String name2, Object ... attributes) {
        this.writer.print("<" + name2 + " ");
        for (int i2 = 0; i2 < attributes.length; i2 += 2) {
            this.writer.print(attributes[i2]);
            this.writer.print("=\"");
            this.writer.print(attributes[i2 + 1]);
            this.writer.print("\" ");
        }
        this.writer.println(">");
    }

    private void endTag(String name2) {
        this.writer.println("</" + name2 + ">");
    }

    public IGVCFGVisitor(CFG cfg, PrintStream writer, String name2) {
        this.writer = writer;
        this.startTag("group");
        this.startTag("properties");
        this.property("name", name2);
        this.endTag("properties");
        this.CFG(cfg);
        this.endTag("group");
    }

    protected void visitBasicBlocks(CFG cfg) {
        for (BasicBlock basicBlock : cfg.getBasicBlocks()) {
            this.BasicBlock(basicBlock);
        }
    }

    protected void visitEdges(CFG cfg) {
        for (BasicBlock basicBlock : cfg.getBasicBlocks()) {
            this.startTag("block", "name", basicBlock.getLabel());
            this.startTag("successors");
            for (BasicBlock destination : cfg.getOutgoingDestinations(basicBlock)) {
                this.emptyTag("successor", "name", destination.getLabel());
            }
            this.endTag("successors");
            this.startTag("nodes");
            int index2 = this.indexOffsets.get(basicBlock);
            int length2 = basicBlock.getInstrs().size();
            for (int i2 = 0; i2 < length2; ++i2) {
                this.emptyTag("node", "id", index2 + i2);
            }
            this.endTag("nodes");
            this.endTag("block");
        }
    }

    protected void visitInstrs(BasicBlock basicBlock) {
        List<Instr> instrs = basicBlock.getInstrs();
        int size2 = instrs.size();
        if (size2 > 0) {
            for (int i2 = 0; i2 < size2 - 1; ++i2) {
                this.Instr(instrs.get(i2));
                this.instrEdges.add(new Tuple<Integer, Integer>(this.instrIndex - 1, this.instrIndex));
            }
            Instr lastInstr = instrs.get(size2 - 1);
            this.Instr(lastInstr);
            if (!(lastInstr instanceof JumpInstr)) {
                this.instrEdges.add(new Tuple<Integer, Integer>(this.instrIndex - 1, this.instrIndex));
            }
        }
    }

    public void BasicBlock(BasicBlock basicBlock) {
        this.indexOffsets.put(basicBlock, this.instrIndex);
        this.visitInstrs(basicBlock);
    }

    public void CFG(CFG cfg) {
        this.startTag("graph");
        this.startTag("nodes");
        this.visitBasicBlocks(cfg);
        this.endTag("nodes");
        this.startTag("edges");
        for (Tuple<Integer, Integer> tuple : this.instrEdges) {
            this.startTag("edge", "from", tuple.a, "to", tuple.b);
            this.endTag("edge");
        }
        for (Tuple<Integer, Object> tuple : this.extraInstrEdges) {
            this.startTag("edge", "from", tuple.a, "to", this.indexOffsets.get(cfg.getBBForLabel(((JumpTargetInstr)tuple.b).getJumpTarget())));
            this.endTag("edge");
        }
        this.endTag("edges");
        this.startTag("controlFlow");
        this.visitEdges(cfg);
        this.endTag("controlFlow");
        this.endTag("graph");
    }

    public void Instr(Instr instr) {
        int ipc = this.instrIndex;
        this.startTag("node", "id", ipc);
        this.startTag("properties");
        this.property("label", ipc);
        this.property("name", instr);
        if (instr instanceof BranchInstr) {
            this.extraInstrEdges.add(new Tuple<Integer, JumpTargetInstr>(ipc, (JumpTargetInstr)((Object)instr)));
        }
        this.endTag("properties");
        this.endTag("node");
        ++this.instrIndex;
    }
}

