/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.parser.ast.BlockAcceptingParseNode;
import org.jruby.truffle.parser.ast.IArgumentNode;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.types.INameNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.lexer.ISourcePosition;

public class FCallParseNode
extends ParseNode
implements INameNode,
IArgumentNode,
BlockAcceptingParseNode {
    private String name;
    protected ParseNode argsNode;
    protected ParseNode iterNode;

    public FCallParseNode(ISourcePosition position, String name) {
        this(position, name, null, null);
    }

    public FCallParseNode(ISourcePosition position, String name, ParseNode argsNode, ParseNode iterNode) {
        super(position, argsNode != null && argsNode.containsVariableAssignment() || iterNode != null && iterNode.containsVariableAssignment());
        this.name = name;
        this.argsNode = argsNode;
        this.iterNode = iterNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.FCALLNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitFCallNode(this);
    }

    @Override
    public ParseNode getIterNode() {
        return this.iterNode;
    }

    @Override
    public ParseNode setIterNode(ParseNode iterNode) {
        this.iterNode = iterNode;
        return this;
    }

    @Override
    public ParseNode getArgsNode() {
        return this.argsNode;
    }

    @Override
    public ParseNode setArgsNode(ParseNode argsNode) {
        this.argsNode = argsNode;
        return argsNode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<ParseNode> childNodes() {
        return FCallParseNode.createList(this.argsNode, this.iterNode);
    }
}

