/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProgressBar
extends Control {
    int timerId;
    int minimum = 0;
    int maximum = 100;
    int selection = 0;
    static final int DELAY = 100;

    public ProgressBar(Composite composite, int n) {
        super(composite, ProgressBar.checkStyle(n));
    }

    static int checkStyle(int n) {
        return ProgressBar.checkBits(n |= 0x80000, 256, 512, 0, 0, 0, 0);
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.fixedHandle, true);
        this.handle = OS.gtk_progress_bar_new();
        if (this.handle == 0) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        int n2 = (this.style & 0x200) != 0 ? 2 : 0;
        this.gtk_orientable_set_orientation(this.handle, n2);
        if ((this.style & 2) != 0) {
            this.timerId = OS.g_timeout_add(100, this.display.windowTimerProc, this.handle);
        }
    }

    @Override
    int eventHandle() {
        return OS.GTK3 ? this.fixedHandle : super.eventHandle();
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public int getState() {
        this.checkWidget();
        return 0;
    }

    @Override
    int gtk_realize(int n) {
        int n2 = super.gtk_realize(n);
        if (n2 != 0) {
            return n2;
        }
        this.updateBar(this.selection, this.minimum, this.maximum);
        return 0;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.timerId != 0) {
            OS.g_source_remove(this.timerId);
        }
        this.timerId = 0;
    }

    @Override
    void setParentBackground() {
    }

    public void setMaximum(int n) {
        this.checkWidget();
        if (n <= this.minimum) {
            return;
        }
        this.maximum = n;
        this.selection = Math.min(this.selection, this.maximum);
        this.updateBar(this.selection, this.minimum, this.maximum);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.maximum) {
            return;
        }
        this.minimum = n;
        this.selection = Math.max(this.selection, this.minimum);
        this.updateBar(this.selection, this.minimum, this.maximum);
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.selection = Math.max(this.minimum, Math.min(this.maximum, n));
        this.updateBar(this.selection, this.minimum, this.maximum);
    }

    public void setState(int n) {
        this.checkWidget();
    }

    @Override
    int timerProc(int n) {
        if (this.isVisible()) {
            OS.gtk_progress_bar_pulse(this.handle);
        }
        return 1;
    }

    void updateBar(int n, int n2, int n3) {
        if (!this.gtk_widget_get_realized(this.handle)) {
            return;
        }
        double d = n2 == n3 ? 1.0 : (double)(n - n2) / (double)(n3 - n2);
        OS.gtk_progress_bar_set_fraction(this.handle, d);
        if (!OS.GTK3) {
            int n4 = this.paintWindow();
            OS.gdk_window_process_updates(n4, false);
            OS.gdk_flush();
        }
    }

    void gtk_orientable_set_orientation(int n, int n2) {
        if (OS.GTK3) {
            switch (n2) {
                case 2: {
                    OS.gtk_orientable_set_orientation(n, 1);
                    OS.gtk_progress_bar_set_inverted(n, true);
                    break;
                }
                case 0: {
                    OS.gtk_orientable_set_orientation(n, 0);
                    OS.gtk_progress_bar_set_inverted(n, false);
                }
            }
        } else {
            OS.gtk_progress_bar_set_orientation(n, n2);
        }
    }
}

