/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.BreakpointLocation;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.DebuggerNode;
import com.oracle.truffle.api.debug.DebuggerTags;
import com.oracle.truffle.api.debug.KillException;
import com.oracle.truffle.api.debug.SteppingStrategy;
import com.oracle.truffle.api.debug.SuspendedCallback;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.Node;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class DebuggerSession
implements Closeable {
    private static final AtomicInteger SESSIONS = new AtomicInteger(0);
    private final Debugger debugger;
    private final SuspendedCallback callback;
    private final Set<Breakpoint> breakpoints = Collections.synchronizedSet(new HashSet());
    private final Breakpoint alwaysHaltBreakpoint;
    private EventBinding<? extends ExecutionEventNodeFactory> callBinding;
    private EventBinding<? extends ExecutionEventNodeFactory> statementBinding;
    private final ConcurrentHashMap<Thread, SuspendedEvent> currentSuspendedEventMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Thread, SteppingStrategy> strategyMap = new ConcurrentHashMap();
    private volatile boolean suspendNext;
    private boolean suspendAll;
    private final StableBoolean stepping = new StableBoolean(false);
    private final boolean legacy;
    private final int sessionId = SESSIONS.incrementAndGet();
    private volatile boolean closed;

    DebuggerSession(Debugger debugger, SuspendedCallback callback, boolean legacy) {
        this.debugger = debugger;
        this.callback = callback;
        SourceSectionFilter filter = SourceSectionFilter.newBuilder().tagIs(DebuggerTags.AlwaysHalt.class).build();
        this.alwaysHaltBreakpoint = new Breakpoint(BreakpointLocation.ANY, filter, false);
        this.alwaysHaltBreakpoint.setEnabled(true);
        this.alwaysHaltBreakpoint.install(this);
        this.legacy = legacy;
        if (Debugger.TRACE) {
            this.trace("open with callback %s", callback);
        }
        if (!legacy) {
            this.addBindings();
        }
    }

    private void trace(String msg, Object ... parameters) {
        Debugger.trace(this + ": " + msg, parameters);
    }

    public String toString() {
        return String.format("Session[id=%s]", this.sessionId);
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public synchronized void suspendNextExecution() {
        if (Debugger.TRACE) {
            this.trace("suspend next execution", new Object[0]);
        }
        if (this.closed) {
            throw new IllegalStateException("session closed");
        }
        this.suspendNext = true;
        this.updateStepping();
    }

    void suspend(Thread t) {
        if (Debugger.TRACE) {
            this.trace("suspend thread %s ", t);
        }
        if (this.closed) {
            throw new IllegalStateException("session closed");
        }
        this.setSteppingStrategy(t, SteppingStrategy.createAlwaysHalt(), true);
    }

    synchronized void suspendAll() {
        if (Debugger.TRACE) {
            this.trace("suspend all threads", new Object[0]);
        }
        if (this.closed) {
            throw new IllegalStateException("session closed");
        }
        this.suspendAll = true;
        for (Thread t : this.strategyMap.keySet()) {
            SteppingStrategy s = this.strategyMap.get(t);
            assert (s != null);
            if (!s.isDone() && !s.isConsumed()) continue;
            this.setSteppingStrategy(t, SteppingStrategy.createAlwaysHalt(), false);
        }
        this.updateStepping();
    }

    public synchronized void resumeAll() {
        if (Debugger.TRACE) {
            this.trace("resume all threads", new Object[0]);
        }
        if (this.closed) {
            throw new IllegalStateException("session closed");
        }
        this.clearStrategies();
    }

    synchronized void resume(Thread t) {
        if (Debugger.TRACE) {
            this.trace("resume threads", t);
        }
        if (this.closed) {
            throw new IllegalStateException("session closed");
        }
        this.setSteppingStrategy(t, SteppingStrategy.createContinue(), true);
    }

    private synchronized void setSteppingStrategy(Thread thread, SteppingStrategy strategy, boolean updateStepping) {
        if (this.closed) {
            return;
        }
        assert (strategy != null);
        SteppingStrategy oldStrategy = this.strategyMap.put(thread, strategy);
        if (oldStrategy != strategy) {
            if (Debugger.TRACE) {
                this.trace("set stepping for thread: %s with strategy: %s", thread, strategy);
            }
            if (updateStepping) {
                this.updateStepping();
            }
        }
    }

    private synchronized void clearStrategies() {
        this.suspendAll = false;
        this.suspendNext = false;
        this.strategyMap.clear();
        this.updateStepping();
    }

    private SteppingStrategy getSteppingStrategy(Object value) {
        return this.strategyMap.get(value);
    }

    private void updateStepping() {
        boolean needsStepping;
        assert (Thread.holdsLock(this));
        boolean bl = needsStepping = this.suspendNext || this.suspendAll;
        if (!needsStepping) {
            for (Object t : this.strategyMap.keySet()) {
                SteppingStrategy s = this.strategyMap.get(t);
                assert (s != null);
                if (s.isDone()) continue;
                needsStepping = true;
                break;
            }
        }
        this.stepping.set(needsStepping);
        if (this.legacy) {
            if (needsStepping) {
                this.addBindings();
            } else {
                this.removeBindings();
            }
        }
    }

    private void addBindings() {
        if (this.statementBinding == null) {
            SourceSectionFilter.Builder builder = SourceSectionFilter.newBuilder().tagIs(StandardTags.CallTag.class);
            this.callBinding = this.debugger.getInstrumenter().attachFactory(builder.build(), new ExecutionEventNodeFactory(){

                @Override
                public ExecutionEventNode create(EventContext context) {
                    return new CallSteppingNode(context);
                }
            });
            builder = SourceSectionFilter.newBuilder().tagIs(StandardTags.StatementTag.class);
            this.statementBinding = this.debugger.getInstrumenter().attachFactory(builder.build(), new ExecutionEventNodeFactory(){

                @Override
                public ExecutionEventNode create(EventContext context) {
                    return new StatementSteppingNode(context);
                }
            });
        }
    }

    private void removeBindings() {
        if (this.statementBinding != null) {
            this.callBinding.dispose();
            this.statementBinding.dispose();
            this.callBinding = null;
            this.statementBinding = null;
            if (Debugger.TRACE) {
                this.trace("disabled stepping", new Object[0]);
            }
        }
    }

    @Override
    public synchronized void close() {
        if (Debugger.TRACE) {
            this.trace("close session", new Object[0]);
        }
        if (this.closed) {
            throw new IllegalStateException("session already closed");
        }
        this.clearStrategies();
        this.removeBindings();
        for (Breakpoint breakpoint : this.getBreakpoints()) {
            breakpoint.dispose();
        }
        this.alwaysHaltBreakpoint.dispose();
        this.currentSuspendedEventMap.clear();
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Breakpoint> getBreakpoints() {
        ArrayList<Breakpoint> b;
        if (this.closed) {
            throw new IllegalStateException("session already closed");
        }
        Set<Breakpoint> set = this.breakpoints;
        synchronized (set) {
            b = new ArrayList<Breakpoint>(this.breakpoints);
        }
        return Collections.unmodifiableList(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Breakpoint> getLegacyBreakpoints() {
        ArrayList<Breakpoint> sortedBreakpoints;
        if (this.closed) {
            throw new IllegalStateException("session already closed");
        }
        Set<Breakpoint> set = this.breakpoints;
        synchronized (set) {
            sortedBreakpoints = new ArrayList<Breakpoint>(this.breakpoints);
        }
        Collections.sort(sortedBreakpoints, Breakpoint.COMPARATOR);
        return sortedBreakpoints;
    }

    public synchronized Breakpoint install(Breakpoint breakpoint) {
        if (this.closed) {
            throw new IllegalStateException("Debugger session is already closed. Cannot install new breakpoints.");
        }
        if (breakpoint.isDisposed()) {
            throw new IllegalArgumentException("Cannot install breakpoint, it is already disposed.");
        }
        if (breakpoint.getSession() != null) {
            throw new IllegalArgumentException("Cannot install breakpoint, it is already installed in different debugger session.");
        }
        breakpoint.install(this);
        this.breakpoints.add(breakpoint);
        breakpoint.setEnabled(true);
        if (Debugger.TRACE) {
            this.trace("installed breakpoint %s", breakpoint);
        }
        return breakpoint;
    }

    synchronized void disposeBreakpoint(Breakpoint breakpoint) {
        this.breakpoints.remove(breakpoint);
        this.debugger.disposeBreakpoint(breakpoint);
        if (Debugger.TRACE) {
            this.trace("disposed breakpoint %s", breakpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @CompilerDirectives.TruffleBoundary
    void notifyCallback(DebuggerNode source, MaterializedFrame frame, Object returnValue, Breakpoint.BreakpointConditionFailure conditionFailure) {
        boolean hitBreakpoint;
        void var9_15;
        Thread currentThread = Thread.currentThread();
        SuspendedEvent event = this.currentSuspendedEventMap.get(currentThread);
        if (!this.legacy && event != null) {
            if (Debugger.TRACE) {
                this.trace("ignored suspended reason: recursive from source:%s context:%s location:%s", new Object[]{source, source.getContext(), source.getSteppingLocation()});
            }
            return;
        }
        if (source.consumeIsDuplicate()) {
            if (Debugger.TRACE) {
                this.trace("ignored suspended reason: duplicate from source:%s context:%s location:%s", new Object[]{source, source.getContext(), source.getSteppingLocation()});
            }
            return;
        }
        List<DebuggerNode> nodes = this.collectDebuggerNodes(source);
        for (DebuggerNode debuggerNode : nodes) {
            if (debuggerNode == source) continue;
            debuggerNode.markAsDuplicate();
        }
        SteppingStrategy s = this.getSteppingStrategy(currentThread);
        if (this.suspendNext) {
            DebuggerSession debuggerSession = this;
            synchronized (debuggerSession) {
                if (this.suspendNext) {
                    s = SteppingStrategy.createAlwaysHalt();
                    this.setSteppingStrategy(currentThread, s, true);
                    this.suspendNext = false;
                }
            }
        }
        if (s == null) {
            s = this.notifyNewThread(currentThread);
        }
        Object var9_12 = null;
        if (conditionFailure != null) {
            HashMap<Breakpoint, Throwable> hashMap = new HashMap<Breakpoint, Throwable>();
            hashMap.put(conditionFailure.getBreakpoint(), conditionFailure.getConditionFailure());
        }
        ArrayList<Breakpoint> breaks = null;
        for (DebuggerNode node : nodes) {
            Breakpoint breakpoint = node.getBreakpoint();
            if (breakpoint == null) continue;
            boolean hit = true;
            Breakpoint.BreakpointConditionFailure failure = null;
            try {
                hit = breakpoint.notifyIndirectHit(source, node, frame);
            }
            catch (Breakpoint.BreakpointConditionFailure e) {
                failure = e;
            }
            if (hit) {
                if (breaks == null) {
                    breaks = new ArrayList<Breakpoint>();
                }
                breaks.add(breakpoint);
            }
            if (failure == null) continue;
            if (var9_15 == null) {
                HashMap hashMap = new HashMap();
            }
            var9_15.put(failure.getBreakpoint(), failure.getConditionFailure());
        }
        boolean hitStepping = s.step(this, source.getContext(), source.getSteppingLocation());
        boolean bl = hitBreakpoint = breaks != null && !breaks.isEmpty();
        if (hitStepping || hitBreakpoint) {
            s.consume();
            this.doSuspend(source, frame, returnValue, (List<Breakpoint>)breaks, (Map<Breakpoint, Throwable>)var9_15);
        } else if (Debugger.TRACE) {
            this.trace("ignored suspended reason: strategy(%s) from source:%s context:%s location:%s", new Object[]{s, source, source.getContext(), source.getSteppingLocation()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSuspend(DebuggerNode source, MaterializedFrame frame, Object returnValue, List<Breakpoint> breaks, Map<Breakpoint, Throwable> conditionFailures) {
        SteppingStrategy currentStrategy;
        CompilerAsserts.neverPartOfCompilation();
        Thread currentThread = Thread.currentThread();
        SuspendedEvent suspendedEvent = new SuspendedEvent(this, currentThread, source.getContext(), frame, source.getSteppingLocation(), returnValue, breaks, conditionFailures);
        this.currentSuspendedEventMap.put(currentThread, suspendedEvent);
        try {
            this.callback.onSuspend(suspendedEvent);
        }
        finally {
            this.currentSuspendedEventMap.remove(currentThread);
            suspendedEvent.clearLeakingReferences();
        }
        if (this.closed) {
            return;
        }
        SteppingStrategy strategy = suspendedEvent.getNextStrategy();
        if (!(this.legacy || strategy.isKill() || (currentStrategy = this.getSteppingStrategy(currentThread)) == null || currentStrategy.isConsumed())) {
            strategy = currentStrategy;
        }
        strategy.initialize();
        if (Debugger.TRACE) {
            this.trace("end suspend with strategy %s at %s location %s", new Object[]{strategy, source.getContext(), source.getSteppingLocation()});
        }
        this.setSteppingStrategy(currentThread, strategy, true);
        if (strategy.isKill()) {
            throw new KillException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DebuggerNode> collectDebuggerNodes(DebuggerNode source) {
        ArrayList<DebuggerNode> nodes = new ArrayList<DebuggerNode>();
        if (source.getSteppingLocation() == SteppingLocation.BEFORE_STATEMENT) {
            DebuggerNode node;
            Object localStatementBinding;
            EventContext context = source.getContext();
            if (this.stepping.get() && (localStatementBinding = this.statementBinding) != null) {
                nodes.add((DebuggerNode)context.lookupExecutionEventNode((EventBinding<? extends ExecutionEventNodeFactory>)localStatementBinding));
            }
            if (!this.breakpoints.isEmpty()) {
                localStatementBinding = this.breakpoints;
                synchronized (localStatementBinding) {
                    for (Breakpoint b : this.breakpoints) {
                        DebuggerNode node2 = b.lookupNode(context);
                        if (node2 == null) continue;
                        nodes.add(node2);
                    }
                }
            }
            if ((node = this.alwaysHaltBreakpoint.lookupNode(context)) != null) {
                nodes.add(node);
            }
        } else {
            assert (source.getSteppingLocation() == SteppingLocation.AFTER_CALL);
            if (this.stepping.get()) {
                assert (source.getContext().lookupExecutionEventNode(this.callBinding) == source);
                nodes.add(source);
            }
        }
        return nodes;
    }

    private synchronized SteppingStrategy notifyNewThread(Thread currentThread) {
        SteppingStrategy s = this.getSteppingStrategy(currentThread);
        if (s == null) {
            s = this.suspendAll ? SteppingStrategy.createAlwaysHalt() : SteppingStrategy.createContinue();
            this.setSteppingStrategy(currentThread, s, true);
        }
        assert (s != null);
        return s;
    }

    static Object evalInContext(SuspendedEvent ev, String code, FrameInstance frameInstance) throws IOException {
        try {
            MaterializedFrame frame;
            Node node;
            if (frameInstance == null) {
                node = ev.getContext().getInstrumentedNode();
                frame = ev.getMaterializedFrame();
            } else {
                node = frameInstance.getCallNode();
                frame = frameInstance.getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize();
            }
            return Debugger.ACCESSOR.evalInContext(ev.getSession().getDebugger().getSourceVM(), node, frame, code);
        }
        catch (KillException kex) {
            throw new IOException("Evaluation was killed.", kex);
        }
    }

    private static final class StableBoolean {
        @CompilerDirectives.CompilationFinal
        private volatile Assumption unchanged;
        @CompilerDirectives.CompilationFinal
        private volatile boolean value;

        StableBoolean(boolean initialValue) {
            this.value = initialValue;
            this.unchanged = Truffle.getRuntime().createAssumption("Unchanged boolean");
        }

        boolean get() {
            if (this.unchanged.isValid()) {
                return this.value;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.value;
        }

        void set(boolean value) {
            if (this.value != value) {
                this.value = value;
                Assumption old = this.unchanged;
                this.unchanged = Truffle.getRuntime().createAssumption("Unchanged boolean");
                old.invalidate();
            }
        }
    }

    private final class CallSteppingNode
    extends DebuggerNode {
        CallSteppingNode(EventContext context) {
            super(context);
        }

        @Override
        EventBinding<?> getBinding() {
            return DebuggerSession.this.callBinding;
        }

        @Override
        public void onReturnValue(VirtualFrame frame, Object result) {
            if (DebuggerSession.this.stepping.get()) {
                DebuggerSession.this.notifyCallback(this, frame.materialize(), result, null);
            }
        }

        @Override
        public void onReturnExceptional(VirtualFrame frame, Throwable exception) {
            if (DebuggerSession.this.stepping.get()) {
                DebuggerSession.this.notifyCallback(this, frame.materialize(), null, null);
            }
        }

        @Override
        SteppingLocation getSteppingLocation() {
            return SteppingLocation.AFTER_CALL;
        }
    }

    private final class StatementSteppingNode
    extends DebuggerNode {
        StatementSteppingNode(EventContext context) {
            super(context);
        }

        @Override
        EventBinding<?> getBinding() {
            return DebuggerSession.this.statementBinding;
        }

        @Override
        protected void onEnter(VirtualFrame frame) {
            if (DebuggerSession.this.stepping.get()) {
                DebuggerSession.this.notifyCallback(this, frame.materialize(), null, null);
            }
        }

        @Override
        SteppingLocation getSteppingLocation() {
            return SteppingLocation.BEFORE_STATEMENT;
        }
    }

    static enum SteppingLocation {
        AFTER_CALL,
        BEFORE_STATEMENT;

    }
}

