/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.array.ArrayHelpers;

@CoreClass(value="Truffle::Array")
public class TruffleArrayNodes {

    @CoreMethod(names={"steal_storage"}, onSingleton=true, required=2)
    public static abstract class StealStorageNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"array == other"})
        public DynamicObject stealStorageNoOp(DynamicObject array, DynamicObject other) {
            return array;
        }

        @Specialization(guards={"array != other", "isRubyArray(other)"})
        public DynamicObject stealStorage(DynamicObject array, DynamicObject other) {
            int size = ArrayHelpers.getSize(other);
            Object store = ArrayHelpers.getStore(other);
            ArrayHelpers.setStoreAndSize(array, store, size);
            ArrayHelpers.setStoreAndSize(other, null, 0);
            return array;
        }
    }
}

