/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.parser.Helpers;
import org.jruby.truffle.parser.ast.ArgumentParseNode;
import org.jruby.truffle.parser.ast.BlockArgParseNode;
import org.jruby.truffle.parser.ast.KeywordRestArgParseNode;
import org.jruby.truffle.parser.ast.ListParseNode;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.RestArgParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.lexer.ISourcePosition;

public class ArgsParseNode
extends ParseNode {
    private ParseNode[] args;
    private short optIndex;
    private short postIndex;
    private short keywordsIndex;
    protected final ArgumentParseNode restArgNode;
    private final KeywordRestArgParseNode keyRest;
    private final BlockArgParseNode blockArgNode;
    private ListParseNode blockLocalVariables = null;
    private static final ParseNode[] NO_ARGS = new ParseNode[0];

    public ArgsParseNode(ISourcePosition position, ListParseNode pre, ListParseNode optionalArguments, RestArgParseNode rest, ListParseNode post, BlockArgParseNode blockArgNode) {
        this(position, pre, optionalArguments, rest, post, null, null, blockArgNode);
    }

    public ArgsParseNode(ISourcePosition position, ListParseNode pre, ListParseNode optionalArguments, RestArgParseNode rest, ListParseNode post, ListParseNode keywords, KeywordRestArgParseNode keyRest, BlockArgParseNode blockArgNode) {
        super(position, pre != null && pre.containsVariableAssignment() || optionalArguments != null && optionalArguments.containsVariableAssignment() || rest != null && rest.containsVariableAssignment() || post != null && post.containsVariableAssignment() || keywords != null && keywords.containsVariableAssignment() || keyRest != null && keyRest.containsVariableAssignment() || blockArgNode != null && blockArgNode.containsVariableAssignment());
        int preSize = pre != null ? pre.size() : 0;
        int optSize = optionalArguments != null ? optionalArguments.size() : 0;
        int postSize = post != null ? post.size() : 0;
        int keywordsSize = keywords != null ? keywords.size() : 0;
        int size = preSize + optSize + postSize + keywordsSize;
        this.args = size > 0 ? new ParseNode[size] : NO_ARGS;
        this.optIndex = (short)(preSize != 0 ? preSize : 0);
        this.postIndex = (short)(optSize != 0 ? this.optIndex + optSize : this.optIndex);
        this.keywordsIndex = (short)(postSize != 0 ? this.postIndex + postSize : this.postIndex);
        if (preSize > 0) {
            System.arraycopy(pre.children(), 0, this.args, 0, preSize);
        }
        if (optSize > 0) {
            System.arraycopy(optionalArguments.children(), 0, this.args, this.optIndex, optSize);
        }
        if (postSize > 0) {
            System.arraycopy(post.children(), 0, this.args, this.postIndex, postSize);
        }
        if (keywordsSize > 0) {
            System.arraycopy(keywords.children(), 0, this.args, this.keywordsIndex, keywordsSize);
        }
        this.restArgNode = rest;
        this.blockArgNode = blockArgNode;
        this.keyRest = keyRest;
    }

    public ParseNode[] getArgs() {
        return this.args;
    }

    public int getOptArgIndex() {
        return this.optIndex;
    }

    public int getPostIndex() {
        return this.postIndex;
    }

    public int getKeywordsIndex() {
        return this.keywordsIndex;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARGSNODE;
    }

    public boolean hasKwargs() {
        boolean keywords = this.getKeywordCount() > 0;
        return keywords || this.keyRest != null;
    }

    public int countKeywords() {
        if (this.hasKwargs()) {
            boolean keywords;
            boolean bl = keywords = this.args.length - this.keywordsIndex > 0;
            if (keywords) {
                return 0;
            }
            return this.args.length - this.keywordsIndex;
        }
        return 0;
    }

    public boolean hasRestArg() {
        return this.restArgNode != null;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitArgsNode(this);
    }

    public ListParseNode getPre() {
        return new ListParseNode(this.getPosition()).addAll(this.args, 0, this.getPreCount());
    }

    public int getRequiredArgsCount() {
        return this.getPreCount() + this.getPostCount();
    }

    public int getOptionalArgsCount() {
        return this.postIndex - this.optIndex;
    }

    public ListParseNode getPost() {
        return new ListParseNode(this.getPosition()).addAll(this.args, this.postIndex, this.getPostCount());
    }

    public int getMaxArgumentsCount() {
        return this.hasRestArg() ? -1 : this.getRequiredArgsCount() + this.getOptionalArgsCount();
    }

    public ListParseNode getOptArgs() {
        return new ListParseNode(this.getPosition()).addAll(this.args, this.optIndex, this.getOptionalArgsCount());
    }

    public ArgumentParseNode getRestArgNode() {
        return this.restArgNode;
    }

    public BlockArgParseNode getBlock() {
        return this.blockArgNode;
    }

    public int getPostCount() {
        return this.keywordsIndex - this.postIndex;
    }

    public int getPreCount() {
        return this.optIndex;
    }

    public ListParseNode getKeywords() {
        return new ListParseNode(this.getPosition()).addAll(this.args, this.keywordsIndex, this.getKeywordCount());
    }

    public KeywordRestArgParseNode getKeyRest() {
        return this.keyRest;
    }

    public boolean hasKeyRest() {
        return this.keyRest != null;
    }

    @Override
    public List<ParseNode> childNodes() {
        ListParseNode post = this.getPost();
        ListParseNode keywords = this.getKeywords();
        ListParseNode pre = this.getPre();
        ListParseNode optArgs = this.getOptArgs();
        if (post != null) {
            if (keywords != null) {
                if (this.keyRest != null) {
                    return ParseNode.createList(pre, optArgs, this.restArgNode, post, keywords, this.keyRest, this.blockArgNode);
                }
                return ParseNode.createList(pre, optArgs, this.restArgNode, post, keywords, this.blockArgNode);
            }
            return ParseNode.createList(pre, optArgs, this.restArgNode, post, this.blockArgNode);
        }
        if (keywords != null) {
            if (this.keyRest != null) {
                return ParseNode.createList(pre, optArgs, this.restArgNode, keywords, this.keyRest, this.blockArgNode);
            }
            return ParseNode.createList(pre, optArgs, this.restArgNode, keywords, this.blockArgNode);
        }
        return ParseNode.createList(pre, optArgs, this.restArgNode, this.blockArgNode);
    }

    public int getKeywordCount() {
        return this.args.length - this.keywordsIndex;
    }

    public int getRequiredKeywordCount() {
        if (this.getKeywordCount() < 1) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.getKeywordCount(); ++i) {
            for (ParseNode asgnNode : this.args[this.keywordsIndex + i].childNodes()) {
                if (!Helpers.isRequiredKeywordArgumentValueNode(asgnNode)) continue;
                ++count;
            }
        }
        return count;
    }

    public ListParseNode getBlockLocalVariables() {
        return this.blockLocalVariables;
    }

    public void setBlockLocalVariables(ListParseNode blockLocalVariables) {
        this.blockLocalVariables = blockLocalVariables;
    }
}

