/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.lexer.ISourcePosition;

public class EnsureParseNode
extends ParseNode {
    private final ParseNode bodyNode;
    private final ParseNode ensureNode;

    public EnsureParseNode(ISourcePosition position, ParseNode bodyNode, ParseNode ensureNode) {
        super(position, bodyNode.containsVariableAssignment() || ensureNode != null && ensureNode.containsVariableAssignment());
        assert (bodyNode != null) : "bodyNode is not null";
        this.bodyNode = bodyNode;
        this.ensureNode = ensureNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ENSURENODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitEnsureNode(this);
    }

    public ParseNode getBodyNode() {
        return this.bodyNode;
    }

    public ParseNode getEnsureNode() {
        return this.ensureNode;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.bodyNode, this.ensureNode);
    }
}

