/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast.util;

import java.util.HashSet;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubySymbol;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

public final class ArgsUtil {
    public static RubyArray convertToRubyArray(Ruby runtime, IRubyObject value, boolean coerce) {
        if (value == null) {
            return RubyArray.newEmptyArray((Ruby)runtime);
        }
        if (coerce) {
            return ArgsUtil.convertToRubyArrayWithCoerce(runtime, value);
        }
        return RubyArray.newArrayLight((Ruby)runtime, (IRubyObject)value);
    }

    public static RubyArray convertToRubyArrayWithCoerce(Ruby runtime, IRubyObject value) {
        if (value instanceof RubyArray) {
            return (RubyArray)value;
        }
        IRubyObject newValue = TypeConverter.convertToType((IRubyObject)value, (RubyClass)runtime.getArray(), (String)"to_ary", (boolean)false);
        if (newValue.isNil()) {
            return RubyArray.newArrayLight((Ruby)runtime, (IRubyObject)value);
        }
        if (!(newValue instanceof RubyArray)) {
            throw runtime.newTypeError(newValue.getMetaClass() + "#to_ary should return Array");
        }
        return (RubyArray)newValue;
    }

    public static int arrayLength(IRubyObject node) {
        return node instanceof RubyArray ? ((RubyArray)node).getLength() : 0;
    }

    public static IRubyObject getOptionsArg(Ruby runtime, IRubyObject ... args) {
        if (args.length >= 1) {
            return TypeConverter.checkHashType((Ruby)runtime, (IRubyObject)args[args.length - 1]);
        }
        return runtime.getNil();
    }

    public static IRubyObject getOptionsArg(Ruby runtime, IRubyObject arg) {
        return TypeConverter.checkHashType((Ruby)runtime, (IRubyObject)arg);
    }

    public static IRubyObject[] extractKeywordArgs(ThreadContext context, RubyHash options, String[] validKeys) {
        IRubyObject[] ret = new IRubyObject[validKeys.length];
        int index = 0;
        HashSet<RubySymbol> validKeySet = new HashSet<RubySymbol>();
        for (String key : validKeys) {
            RubySymbol keySym = context.runtime.newSymbol(key);
            ret[index] = options.containsKey((Object)keySym) ? options.fastARef((IRubyObject)keySym) : context.runtime.getNil();
            ++index;
            validKeySet.add(keySym);
        }
        for (Object obj : options.keySet()) {
            if (validKeySet.contains(obj)) continue;
            throw context.runtime.newArgumentError("unknown keyword: " + obj);
        }
        return ret;
    }

    public static IRubyObject[] extractKeywordArgs(ThreadContext context, IRubyObject[] args, String[] validKeys) {
        IRubyObject options = ArgsUtil.getOptionsArg(context.runtime, args);
        if (options instanceof RubyHash) {
            return ArgsUtil.extractKeywordArgs(context, (RubyHash)options, validKeys);
        }
        return null;
    }

    public static IRubyObject extractKeywordArg(ThreadContext context, String keyword, IRubyObject arg) {
        IRubyObject opts = ArgsUtil.getOptionsArg(context.runtime, arg);
        if (!opts.isNil()) {
            return ((RubyHash)opts).op_aref(context, (IRubyObject)context.runtime.newSymbol(keyword));
        }
        return context.nil;
    }

    public static IRubyObject extractKeywordArg(ThreadContext context, String keyword, IRubyObject ... args) {
        IRubyObject opts = ArgsUtil.getOptionsArg(context.runtime, args);
        if (!opts.isNil()) {
            return ((RubyHash)opts).op_aref(context, (IRubyObject)context.runtime.newSymbol(keyword));
        }
        return context.nil;
    }

    public static IRubyObject extractArg(int index, IRubyObject _default, IRubyObject ... args) {
        if (index < args.length) {
            return args[index];
        }
        return _default;
    }
}

