/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.TestTools;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.RuleMatch;

public class MultipleWhitespaceRuleTest {
    @Test
    public void testRule() throws IOException {
        MultipleWhitespaceRule rule = new MultipleWhitespaceRule(TestTools.getEnglishMessages(), TestTools.getDemoLanguage());
        JLanguageTool langTool = new JLanguageTool(TestTools.getDemoLanguage());
        RuleMatch[] matches = rule.match(langTool.getAnalyzedSentence("This is a test sentence."));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("This is a test sentence..."));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("\n\tThis is a test sentence..."));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("Multiple tabs\t\tare okay"));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("This  is a test sentence."));
        Assert.assertEquals((long)1L, (long)matches.length);
        Assert.assertEquals((long)4L, (long)matches[0].getFromPos());
        Assert.assertEquals((long)6L, (long)matches[0].getToPos());
        matches = rule.match(langTool.getAnalyzedSentence("This is a test   sentence."));
        Assert.assertEquals((long)1L, (long)matches.length);
        Assert.assertEquals((long)14L, (long)matches[0].getFromPos());
        Assert.assertEquals((long)17L, (long)matches[0].getToPos());
        matches = rule.match(langTool.getAnalyzedSentence("This is   a  test   sentence."));
        Assert.assertEquals((long)3L, (long)matches.length);
        Assert.assertEquals((long)7L, (long)matches[0].getFromPos());
        Assert.assertEquals((long)10L, (long)matches[0].getToPos());
        Assert.assertEquals((long)11L, (long)matches[1].getFromPos());
        Assert.assertEquals((long)13L, (long)matches[1].getToPos());
        Assert.assertEquals((long)17L, (long)matches[2].getFromPos());
        Assert.assertEquals((long)20L, (long)matches[2].getToPos());
        matches = rule.match(langTool.getAnalyzedSentence("\t\t\t    \t\t\t\t  "));
        Assert.assertEquals((long)1L, (long)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("This \u00a0is a test sentence."));
        Assert.assertEquals((long)1L, (long)matches.length);
        Assert.assertEquals((long)4L, (long)matches[0].getFromPos());
        Assert.assertEquals((long)6L, (long)matches[0].getToPos());
    }
}

