/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.CacheCustomContent;
import org.openstreetmap.josm.tools.HttpClient;
import org.xml.sax.InputSource;

public class CachedAttributionBingAerialTileSource
extends BingAerialTileSource {
    private Runnable attributionDownloadedTask;

    public CachedAttributionBingAerialTileSource(ImageryInfo imageryInfo) {
        super(imageryInfo);
    }

    public CachedAttributionBingAerialTileSource(TileSourceInfo tileSourceInfo, Runnable runnable) {
        super(tileSourceInfo);
        this.attributionDownloadedTask = runnable;
    }

    @Override
    protected Callable<List<BingAerialTileSource.Attribution>> getAttributionLoaderCallable() {
        return () -> {
            BingAttributionData bingAttributionData = new BingAttributionData();
            int n = 1;
            while (true) {
                try {
                    String string = bingAttributionData.updateIfRequiredString();
                    List<BingAerialTileSource.Attribution> list = this.parseAttributionText(new InputSource(new StringReader(string)));
                    if (this.attributionDownloadedTask != null) {
                        GuiHelper.runInEDT(this.attributionDownloadedTask);
                        this.attributionDownloadedTask = null;
                    }
                    return list;
                }
                catch (IOException iOException) {
                    Main.warn((Throwable)iOException, "Could not connect to Bing API. Will retry in " + n + " seconds.");
                    Thread.sleep(TimeUnit.SECONDS.toMillis(n));
                    n *= 2;
                    continue;
                }
                break;
            }
        };
    }

    class BingAttributionData
    extends CacheCustomContent<IOException> {
        BingAttributionData() {
            super("bing.attribution.xml", CacheCustomContent.INTERVAL_HOURLY);
        }

        @Override
        protected byte[] updateData() throws IOException {
            URL uRL = CachedAttributionBingAerialTileSource.this.getAttributionUrl();
            String string = HttpClient.create(uRL).connect().fetchContent();
            Main.info("Successfully loaded Bing attribution data.");
            return string.getBytes("UTF-8");
        }
    }
}

