/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.TemplatedTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.DefaultLayer;
import org.openstreetmap.josm.data.imagery.GetCapabilitiesParseHelper;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.WMTSDefaultLayer;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.NativeScaleLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class WMTSTileSource
extends AbstractTMSTileSource
implements TemplatedTileSource {
    public static final String WMTS_NS_URL = "http://www.opengis.net/wmts/1.0";
    private static final QName QN_CONTENTS = new QName("http://www.opengis.net/wmts/1.0", "Contents");
    private static final QName QN_FORMAT = new QName("http://www.opengis.net/wmts/1.0", "Format");
    private static final QName QN_LAYER = new QName("http://www.opengis.net/wmts/1.0", "Layer");
    private static final QName QN_MATRIX_WIDTH = new QName("http://www.opengis.net/wmts/1.0", "MatrixWidth");
    private static final QName QN_MATRIX_HEIGHT = new QName("http://www.opengis.net/wmts/1.0", "MatrixHeight");
    private static final QName QN_RESOURCE_URL = new QName("http://www.opengis.net/wmts/1.0", "ResourceURL");
    private static final QName QN_SCALE_DENOMINATOR = new QName("http://www.opengis.net/wmts/1.0", "ScaleDenominator");
    private static final QName QN_STYLE = new QName("http://www.opengis.net/wmts/1.0", "Style");
    private static final QName QN_TILEMATRIX = new QName("http://www.opengis.net/wmts/1.0", "TileMatrix");
    private static final QName QN_TILEMATRIXSET = new QName("http://www.opengis.net/wmts/1.0", "TileMatrixSet");
    private static final QName QN_TILEMATRIX_SET_LINK = new QName("http://www.opengis.net/wmts/1.0", "TileMatrixSetLink");
    private static final QName QN_TILE_WIDTH = new QName("http://www.opengis.net/wmts/1.0", "TileWidth");
    private static final QName QN_TILE_HEIGHT = new QName("http://www.opengis.net/wmts/1.0", "TileHeight");
    private static final QName QN_TOPLEFT_CORNER = new QName("http://www.opengis.net/wmts/1.0", "TopLeftCorner");
    private static final String PATTERN_HEADER = "\\{header\\(([^,]+),([^}]+)\\)\\}";
    private static final String URL_GET_ENCODING_PARAMS = "SERVICE=WMTS&REQUEST=GetTile&VERSION=1.0.0&LAYER={layer}&STYLE={style}&FORMAT={format}&tileMatrixSet={TileMatrixSet}&tileMatrix={TileMatrix}&tileRow={TileRow}&tileCol={TileCol}";
    private static final String[] ALL_PATTERNS = new String[]{"\\{header\\(([^,]+),([^}]+)\\)\\}"};
    private final Map<String, String> headers = new ConcurrentHashMap<String, String>();
    private final Collection<Layer> layers;
    private Layer currentLayer;
    private TileMatrixSet currentTileMatrixSet;
    private double crsScale;
    private GetCapabilitiesParseHelper.TransferMode transferMode;
    private NativeScaleLayer.ScaleList nativeScaleList;
    private final WMTSDefaultLayer defaultLayer;

    public WMTSTileSource(ImageryInfo imageryInfo) throws IOException {
        super(imageryInfo);
        CheckParameterUtil.ensureThat(imageryInfo.getDefaultLayers().size() < 2, "At most 1 default layer for WMTS is supported");
        this.baseUrl = GetCapabilitiesParseHelper.normalizeCapabilitiesUrl(this.handleTemplate(imageryInfo.getUrl()));
        this.layers = this.getCapabilities();
        WMTSDefaultLayer wMTSDefaultLayer = this.defaultLayer = imageryInfo.getDefaultLayers().isEmpty() ? null : (WMTSDefaultLayer)imageryInfo.getDefaultLayers().iterator().next();
        if (this.layers.isEmpty()) {
            throw new IllegalArgumentException(I18n.tr("No layers defined by getCapabilities document: {0}", imageryInfo.getUrl()));
        }
    }

    public DefaultLayer userSelectLayer() {
        List<Map.Entry<String, List<Layer>>> list = WMTSTileSource.groupLayersByName(this.layers);
        if (list.size() == 1) {
            Layer layer = (Layer)((List)((Map.Entry)list.iterator().next()).getValue()).iterator().next();
            return new WMTSDefaultLayer(layer.name, layer.tileMatrixSet.identifier);
        }
        SelectLayerDialog selectLayerDialog = new SelectLayerDialog(this.layers);
        if (selectLayerDialog.showDialog().getValue() == 1) {
            return selectLayerDialog.getSelectedLayer();
        }
        return null;
    }

    private String handleTemplate(String string) {
        Pattern pattern = Pattern.compile(PATTERN_HEADER);
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            this.headers.put(matcher.group(1), matcher.group(2));
            matcher.appendReplacement(stringBuffer, "");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private static List<Map.Entry<String, List<Layer>>> groupLayersByName(Collection<Layer> collection) {
        Map<String, List<Layer>> map = collection.stream().collect(Collectors.groupingBy(layer -> ((Layer)layer).name + '\u001c' + ((Layer)layer).tileMatrixSet.identifier));
        return map.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
    }

    /*
     * Exception decompiling
     */
    private Collection<Layer> getCapabilities() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Collection<Layer> parseContents(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !QN_CONTENTS.equals(xMLStreamReader.getName()))) {
            if (n == 1) {
                if (QN_LAYER.equals(xMLStreamReader.getName())) {
                    arrayList.add(WMTSTileSource.parseLayer(xMLStreamReader));
                }
                if (QN_TILEMATRIXSET.equals(xMLStreamReader.getName())) {
                    TileMatrixSet tileMatrixSet = WMTSTileSource.parseTileMatrixSet(xMLStreamReader);
                    concurrentHashMap.put(tileMatrixSet.identifier, tileMatrixSet);
                }
            }
            n = xMLStreamReader.next();
        }
        ArrayList<Layer> arrayList2 = new ArrayList<Layer>();
        for (Layer layer : arrayList) {
            for (String string : layer.tileMatrixSetLinks) {
                Layer layer2 = new Layer(layer);
                layer2.tileMatrixSet = (TileMatrixSet)concurrentHashMap.get(string);
                arrayList2.add(layer2);
            }
        }
        return arrayList2;
    }

    private static Layer parseLayer(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        Layer layer = new Layer();
        Stack<QName> stack = new Stack<QName>();
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !QN_LAYER.equals(xMLStreamReader.getName()))) {
            QName qName;
            if (n == 1) {
                stack.push(xMLStreamReader.getName());
                if (stack.size() == 2) {
                    if (QN_FORMAT.equals(xMLStreamReader.getName())) {
                        layer.format = xMLStreamReader.getElementText();
                    } else if (GetCapabilitiesParseHelper.QN_OWS_IDENTIFIER.equals(xMLStreamReader.getName())) {
                        layer.name = xMLStreamReader.getElementText();
                    } else if (QN_RESOURCE_URL.equals(xMLStreamReader.getName()) && "tile".equals(xMLStreamReader.getAttributeValue("", "resourceType"))) {
                        layer.baseUrl = xMLStreamReader.getAttributeValue("", "template");
                    } else if (QN_STYLE.equals(xMLStreamReader.getName()) && "true".equals(xMLStreamReader.getAttributeValue("", "isDefault"))) {
                        if (GetCapabilitiesParseHelper.moveReaderToTag(xMLStreamReader, GetCapabilitiesParseHelper.QN_OWS_IDENTIFIER)) {
                            layer.style = xMLStreamReader.getElementText();
                            stack.push(xMLStreamReader.getName());
                        }
                    } else if (QN_TILEMATRIX_SET_LINK.equals(xMLStreamReader.getName())) {
                        layer.tileMatrixSetLinks.add(WMTSTileSource.praseTileMatrixSetLink(xMLStreamReader));
                    } else {
                        GetCapabilitiesParseHelper.moveReaderToEndCurrentTag(xMLStreamReader);
                    }
                }
            }
            if (xMLStreamReader.getEventType() == 2 && !(qName = (QName)stack.pop()).equals(xMLStreamReader.getName())) {
                throw new IllegalStateException(I18n.tr("WMTS Parser error - start element {0} has different name than end element {2}", qName, xMLStreamReader.getName()));
            }
            n = xMLStreamReader.next();
        }
        if (layer.style == null) {
            layer.style = "";
        }
        return layer;
    }

    private static String praseTileMatrixSetLink(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        String string = null;
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !QN_TILEMATRIX_SET_LINK.equals(xMLStreamReader.getName()))) {
            if (n == 1 && QN_TILEMATRIXSET.equals(xMLStreamReader.getName())) {
                string = xMLStreamReader.getElementText();
            }
            n = xMLStreamReader.next();
        }
        return string;
    }

    private static TileMatrixSet parseTileMatrixSet(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        TileMatrixSetBuilder tileMatrixSetBuilder = new TileMatrixSetBuilder();
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !QN_TILEMATRIXSET.equals(xMLStreamReader.getName()))) {
            if (n == 1) {
                if (GetCapabilitiesParseHelper.QN_OWS_IDENTIFIER.equals(xMLStreamReader.getName())) {
                    tileMatrixSetBuilder.identifier = xMLStreamReader.getElementText();
                }
                if (GetCapabilitiesParseHelper.QN_OWS_SUPPORTED_CRS.equals(xMLStreamReader.getName())) {
                    tileMatrixSetBuilder.crs = GetCapabilitiesParseHelper.crsToCode(xMLStreamReader.getElementText());
                }
                if (QN_TILEMATRIX.equals(xMLStreamReader.getName())) {
                    tileMatrixSetBuilder.tileMatrix.add(WMTSTileSource.parseTileMatrix(xMLStreamReader, tileMatrixSetBuilder.crs));
                }
            }
            n = xMLStreamReader.next();
        }
        return tileMatrixSetBuilder.build();
    }

    private static TileMatrix parseTileMatrix(XMLStreamReader xMLStreamReader, String string) throws XMLStreamException {
        Projection projection = Projections.getProjectionByCode(string);
        TileMatrix tileMatrix = new TileMatrix();
        if (projection == null) {
            projection = Main.getProjection();
        }
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !QN_TILEMATRIX.equals(xMLStreamReader.getName()))) {
            if (n == 1) {
                if (GetCapabilitiesParseHelper.QN_OWS_IDENTIFIER.equals(xMLStreamReader.getName())) {
                    tileMatrix.identifier = xMLStreamReader.getElementText();
                }
                if (QN_SCALE_DENOMINATOR.equals(xMLStreamReader.getName())) {
                    tileMatrix.scaleDenominator = Double.parseDouble(xMLStreamReader.getElementText());
                }
                if (QN_TOPLEFT_CORNER.equals(xMLStreamReader.getName())) {
                    String[] stringArray = xMLStreamReader.getElementText().split(" ");
                    if (projection.switchXY()) {
                        tileMatrix.topLeftCorner = new EastNorth(Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[0]));
                    } else {
                        tileMatrix.topLeftCorner = new EastNorth(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]));
                    }
                }
                if (QN_TILE_HEIGHT.equals(xMLStreamReader.getName())) {
                    tileMatrix.tileHeight = Integer.parseInt(xMLStreamReader.getElementText());
                }
                if (QN_TILE_WIDTH.equals(xMLStreamReader.getName())) {
                    tileMatrix.tileWidth = Integer.parseInt(xMLStreamReader.getElementText());
                }
                if (QN_MATRIX_HEIGHT.equals(xMLStreamReader.getName())) {
                    tileMatrix.matrixHeight = Integer.parseInt(xMLStreamReader.getElementText());
                }
                if (QN_MATRIX_WIDTH.equals(xMLStreamReader.getName())) {
                    tileMatrix.matrixWidth = Integer.parseInt(xMLStreamReader.getElementText());
                }
            }
            n = xMLStreamReader.next();
        }
        if (tileMatrix.tileHeight != tileMatrix.tileWidth) {
            throw new AssertionError((Object)I18n.tr("Only square tiles are supported. {0}x{1} returned by server for TileMatrix identifier {2}", tileMatrix.tileHeight, tileMatrix.tileWidth, tileMatrix.identifier));
        }
        return tileMatrix;
    }

    private void parseOperationMetadata(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        int n = xMLStreamReader.getEventType();
        while (xMLStreamReader.hasNext() && (n != 2 || !GetCapabilitiesParseHelper.QN_OWS_OPERATIONS_METADATA.equals(xMLStreamReader.getName()))) {
            if (n == 1 && GetCapabilitiesParseHelper.QN_OWS_OPERATION.equals(xMLStreamReader.getName()) && "GetTile".equals(xMLStreamReader.getAttributeValue("", "name")) && GetCapabilitiesParseHelper.moveReaderToTag(xMLStreamReader, GetCapabilitiesParseHelper.QN_OWS_DCP, GetCapabilitiesParseHelper.QN_OWS_HTTP, GetCapabilitiesParseHelper.QN_OWS_GET)) {
                this.baseUrl = xMLStreamReader.getAttributeValue("http://www.w3.org/1999/xlink", "href");
                this.transferMode = GetCapabilitiesParseHelper.getTransferMode(xMLStreamReader);
            }
            n = xMLStreamReader.next();
        }
    }

    public void initProjection(Projection projection) {
        Collection<Layer> collection = this.getLayers(this.currentLayer != null ? new WMTSDefaultLayer(this.currentLayer.name, this.currentLayer.tileMatrixSet.identifier) : this.defaultLayer, projection.toCode());
        if (collection.size() == 1) {
            Layer layer2 = collection.iterator().next();
            if (layer2 != null) {
                this.currentTileMatrixSet = layer2.tileMatrixSet;
                this.currentLayer = layer2;
                ArrayList<Double> arrayList = new ArrayList<Double>(this.currentTileMatrixSet.tileMatrix.size());
                for (TileMatrix tileMatrix : this.currentTileMatrixSet.tileMatrix) {
                    arrayList.add(tileMatrix.scaleDenominator * 2.8E-4);
                }
                this.nativeScaleList = new NativeScaleLayer.ScaleList(arrayList);
            }
        } else if (collection.size() > 1) {
            Main.warn("More than one layer WMTS available: {0} for projection {1} and name {2}. Do not know which to process", collection.stream().map(layer -> ((Layer)layer).name + ": " + ((Layer)layer).tileMatrixSet.identifier).collect(Collectors.joining(", ")), projection.toCode(), this.currentLayer != null ? this.currentLayer.name : this.defaultLayer);
        }
        this.crsScale = (double)this.getTileSize() * 2.8E-4 / projection.getMetersPerUnit();
    }

    private Collection<Layer> getLayers(WMTSDefaultLayer wMTSDefaultLayer, String string) {
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        if (this.layers != null) {
            for (Layer layer : this.layers) {
                if (wMTSDefaultLayer != null && (!wMTSDefaultLayer.getLayerName().equals(layer.name) || !wMTSDefaultLayer.getTileMatrixSet().equals(layer.tileMatrixSet.identifier)) || string != null && !string.equals(layer.tileMatrixSet.crs)) continue;
                arrayList.add(layer);
            }
        }
        return arrayList;
    }

    @Override
    public int getTileSize() {
        Collection<Layer> collection = this.getLayers(null, Main.getProjection().toCode());
        if (!collection.isEmpty()) {
            return ((TileMatrix)collection.iterator().next().tileMatrixSet.tileMatrix.get(0)).tileHeight;
        }
        Main.warn("WMTS: Could not determine tile size. Using default tile size of: {0}", this.getDefaultTileSize());
        return this.getDefaultTileSize();
    }

    @Override
    public String getTileUrl(int n, int n2, int n3) {
        String string;
        if (this.currentLayer == null) {
            return "";
        }
        if (this.currentLayer.baseUrl != null && this.transferMode == null) {
            string = this.currentLayer.baseUrl;
        } else {
            switch (this.transferMode) {
                case KVP: {
                    string = this.baseUrl + URL_GET_ENCODING_PARAMS;
                    break;
                }
                case REST: {
                    string = this.currentLayer.baseUrl;
                    break;
                }
                default: {
                    string = "";
                }
            }
        }
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return "";
        }
        return string.replaceAll("\\{layer\\}", this.currentLayer.name).replaceAll("\\{format\\}", this.currentLayer.format).replaceAll("\\{TileMatrixSet\\}", this.currentTileMatrixSet.identifier).replaceAll("\\{TileMatrix\\}", tileMatrix.identifier).replaceAll("\\{TileRow\\}", Integer.toString(n3)).replaceAll("\\{TileCol\\}", Integer.toString(n2)).replaceAll("(?i)\\{style\\}", this.currentLayer.style);
    }

    private TileMatrix getTileMatrix(int n) {
        if (n > this.getMaxZoom()) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        return (TileMatrix)this.currentTileMatrixSet.tileMatrix.get(n);
    }

    @Override
    public double getDistance(double d, double d2, double d3, double d4) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ICoordinate tileXYToLatLon(Tile tile) {
        return this.tileXYToLatLon(tile.getXtile(), tile.getYtile(), tile.getZoom());
    }

    @Override
    public ICoordinate tileXYToLatLon(TileXY tileXY, int n) {
        return this.tileXYToLatLon(tileXY.getXIndex(), tileXY.getYIndex(), n);
    }

    @Override
    public ICoordinate tileXYToLatLon(int n, int n2, int n3) {
        TileMatrix tileMatrix = this.getTileMatrix(n3);
        if (tileMatrix == null) {
            return Main.getProjection().getWorldBoundsLatLon().getCenter().toCoordinate();
        }
        double d = tileMatrix.scaleDenominator * this.crsScale;
        EastNorth eastNorth = new EastNorth(tileMatrix.topLeftCorner.east() + (double)n * d, tileMatrix.topLeftCorner.north() - (double)n2 * d);
        return Main.getProjection().eastNorth2latlon(eastNorth).toCoordinate();
    }

    @Override
    public TileXY latLonToTileXY(double d, double d2, int n) {
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return new TileXY(0.0, 0.0);
        }
        Projection projection = Main.getProjection();
        EastNorth eastNorth = projection.latlon2eastNorth(new LatLon(d, d2));
        double d3 = tileMatrix.scaleDenominator * this.crsScale;
        return new TileXY((eastNorth.east() - tileMatrix.topLeftCorner.east()) / d3, (tileMatrix.topLeftCorner.north() - eastNorth.north()) / d3);
    }

    @Override
    public TileXY latLonToTileXY(ICoordinate iCoordinate, int n) {
        return this.latLonToTileXY(iCoordinate.getLat(), iCoordinate.getLon(), n);
    }

    @Override
    public int getTileXMax(int n) {
        return this.getTileXMax(n, Main.getProjection());
    }

    @Override
    public int getTileXMin(int n) {
        return 0;
    }

    @Override
    public int getTileYMax(int n) {
        return this.getTileYMax(n, Main.getProjection());
    }

    @Override
    public int getTileYMin(int n) {
        return 0;
    }

    @Override
    public Point latLonToXY(double d, double d2, int n) {
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return new Point(0, 0);
        }
        double d3 = tileMatrix.scaleDenominator * this.crsScale;
        EastNorth eastNorth = Main.getProjection().latlon2eastNorth(new LatLon(d, d2));
        return new Point((int)Math.round((eastNorth.east() - tileMatrix.topLeftCorner.east()) / d3), (int)Math.round((tileMatrix.topLeftCorner.north() - eastNorth.north()) / d3));
    }

    @Override
    public Point latLonToXY(ICoordinate iCoordinate, int n) {
        return this.latLonToXY(iCoordinate.getLat(), iCoordinate.getLon(), n);
    }

    @Override
    public Coordinate xyToLatLon(Point point, int n) {
        return this.xyToLatLon(point.x, point.y, n);
    }

    @Override
    public Coordinate xyToLatLon(int n, int n2, int n3) {
        TileMatrix tileMatrix = this.getTileMatrix(n3);
        if (tileMatrix == null) {
            return new Coordinate(0.0, 0.0);
        }
        double d = tileMatrix.scaleDenominator * this.crsScale;
        Projection projection = Main.getProjection();
        EastNorth eastNorth = new EastNorth(tileMatrix.topLeftCorner.east() + (double)n * d, tileMatrix.topLeftCorner.north() - (double)n2 * d);
        LatLon latLon = projection.eastNorth2latlon(eastNorth);
        return new Coordinate(latLon.lat(), latLon.lon());
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public int getMaxZoom() {
        if (this.currentTileMatrixSet != null) {
            return this.currentTileMatrixSet.tileMatrix.size() - 1;
        }
        return 0;
    }

    @Override
    public String getTileId(int n, int n2, int n3) {
        return this.getTileUrl(n, n2, n3);
    }

    public static void checkUrl(String string) {
        CheckParameterUtil.ensureParameterNotNull(string, "url");
        Matcher matcher = Pattern.compile("\\{[^}]*\\}").matcher(string);
        while (matcher.find()) {
            boolean bl = false;
            for (String string2 : ALL_PATTERNS) {
                if (!matcher.group().matches(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new IllegalArgumentException(I18n.tr("{0} is not a valid WMS argument. Please check this server URL:\n{1}", matcher.group(), string));
        }
    }

    public Set<String> getSupportedProjections() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.currentLayer == null) {
            for (Layer layer : this.layers) {
                hashSet.add(layer.tileMatrixSet.crs);
            }
        } else {
            for (Layer layer : this.layers) {
                if (!this.currentLayer.name.equals(layer.name)) continue;
                hashSet.add(layer.tileMatrixSet.crs);
            }
        }
        return hashSet;
    }

    private int getTileYMax(int n, Projection projection) {
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return 0;
        }
        if (tileMatrix.matrixHeight != -1) {
            return tileMatrix.matrixHeight;
        }
        double d = tileMatrix.scaleDenominator * this.crsScale;
        EastNorth eastNorth = tileMatrix.topLeftCorner;
        EastNorth eastNorth2 = projection.latlon2eastNorth(projection.getWorldBoundsLatLon().getMax());
        return (int)Math.ceil(Math.abs(eastNorth2.north() - eastNorth.north()) / d);
    }

    private int getTileXMax(int n, Projection projection) {
        TileMatrix tileMatrix = this.getTileMatrix(n);
        if (tileMatrix == null) {
            return 0;
        }
        if (tileMatrix.matrixWidth != -1) {
            return tileMatrix.matrixWidth;
        }
        double d = tileMatrix.scaleDenominator * this.crsScale;
        EastNorth eastNorth = tileMatrix.topLeftCorner;
        EastNorth eastNorth2 = projection.latlon2eastNorth(projection.getWorldBoundsLatLon().getMax());
        return (int)Math.ceil(Math.abs(eastNorth2.east() - eastNorth.east()) / d);
    }

    public NativeScaleLayer.ScaleList getNativeScales() {
        return this.nativeScaleList;
    }

    private static final class SelectLayerDialog
    extends ExtendedDialog {
        private final transient List<Map.Entry<String, List<Layer>>> layers;
        private final JTable list;

        SelectLayerDialog(Collection<Layer> collection) {
            super(Main.parent, I18n.tr("Select WMTS layer", new Object[0]), I18n.tr("Add layers", new Object[0]), I18n.tr("Cancel", new Object[0]));
            this.layers = WMTSTileSource.groupLayersByName(collection);
            this.list = new JTable(new AbstractTableModel(){

                @Override
                public Object getValueAt(int n, int n2) {
                    switch (n2) {
                        case 0: {
                            return ((List)((Map.Entry)layers.get(n)).getValue()).stream().map(layer -> ((Layer)layer).name).collect(Collectors.joining(", "));
                        }
                        case 1: {
                            return ((List)((Map.Entry)layers.get(n)).getValue()).stream().map(layer -> ((Layer)layer).tileMatrixSet.crs).collect(Collectors.joining(", "));
                        }
                        case 2: {
                            return ((List)((Map.Entry)layers.get(n)).getValue()).stream().map(layer -> ((Layer)layer).tileMatrixSet.identifier).collect(Collectors.joining(", "));
                        }
                    }
                    throw new IllegalArgumentException();
                }

                @Override
                public int getRowCount() {
                    return layers.size();
                }

                @Override
                public int getColumnCount() {
                    return 3;
                }

                @Override
                public String getColumnName(int n) {
                    switch (n) {
                        case 0: {
                            return I18n.tr("Layer name", new Object[0]);
                        }
                        case 1: {
                            return I18n.tr("Projection", new Object[0]);
                        }
                        case 2: {
                            return I18n.tr("Matrix set identifier", new Object[0]);
                        }
                    }
                    throw new IllegalArgumentException();
                }

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            });
            this.list.setSelectionMode(0);
            this.list.setRowSelectionAllowed(true);
            this.list.setColumnSelectionAllowed(false);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new JScrollPane(this.list), GBC.eol().fill());
            this.setContent(jPanel);
        }

        public DefaultLayer getSelectedLayer() {
            int n = this.list.getSelectedRow();
            if (n < 0) {
                return null;
            }
            Layer layer = this.layers.get(n).getValue().iterator().next();
            return new WMTSDefaultLayer(layer.name, layer.tileMatrixSet.identifier);
        }
    }

    private static class Layer {
        private String format;
        private String name;
        private TileMatrixSet tileMatrixSet;
        private String baseUrl;
        private String style;
        private final Collection<String> tileMatrixSetLinks = new ArrayList<String>();

        Layer(Layer layer) {
            if (layer != null) {
                this.format = layer.format;
                this.name = layer.name;
                this.baseUrl = layer.baseUrl;
                this.style = layer.style;
                this.tileMatrixSet = new TileMatrixSet(layer.tileMatrixSet);
            }
        }

        Layer() {
        }
    }

    private static class TileMatrixSet {
        private final List<TileMatrix> tileMatrix;
        private final String crs;
        private final String identifier;

        TileMatrixSet(TileMatrixSet tileMatrixSet) {
            if (tileMatrixSet != null) {
                this.tileMatrix = new ArrayList<TileMatrix>(tileMatrixSet.tileMatrix);
                this.crs = tileMatrixSet.crs;
                this.identifier = tileMatrixSet.identifier;
            } else {
                this.tileMatrix = Collections.emptyList();
                this.crs = null;
                this.identifier = null;
            }
        }

        TileMatrixSet(TileMatrixSetBuilder tileMatrixSetBuilder) {
            this.tileMatrix = new ArrayList<TileMatrix>(tileMatrixSetBuilder.tileMatrix);
            this.crs = tileMatrixSetBuilder.crs;
            this.identifier = tileMatrixSetBuilder.identifier;
        }
    }

    private static class TileMatrixSetBuilder {
        SortedSet<TileMatrix> tileMatrix = new TreeSet<TileMatrix>((tileMatrix, tileMatrix2) -> -1 * Double.compare(((TileMatrix)tileMatrix).scaleDenominator, ((TileMatrix)tileMatrix2).scaleDenominator));
        private String crs;
        private String identifier;

        private TileMatrixSetBuilder() {
        }

        TileMatrixSet build() {
            return new TileMatrixSet(this);
        }
    }

    private static class TileMatrix {
        private String identifier;
        private double scaleDenominator;
        private EastNorth topLeftCorner;
        private int tileWidth;
        private int tileHeight;
        private int matrixWidth = -1;
        private int matrixHeight = -1;

        private TileMatrix() {
        }
    }
}

