/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.gui.mappaint.mapcss.ExpressionFactory;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Utils;

public final class ConditionFactory {
    private ConditionFactory() {
    }

    public static Condition createKeyValueCondition(String string, String string2, Op op, Condition.Context context, boolean bl) {
        switch (context) {
            case PRIMITIVE: {
                if (KeyValueRegexpCondition.SUPPORTED_OPS.contains((Object)op) && !bl) {
                    return new KeyValueRegexpCondition(string, string2, op, false);
                }
                if (!bl && op.equals((Object)Op.EQ)) {
                    return new SimpleKeyValueCondition(string, string2);
                }
                return new KeyValueCondition(string, string2, op, bl);
            }
            case LINK: {
                if (bl) {
                    throw new MapCSSException("''considerValAsKey'' not supported in LINK context");
                }
                if ("role".equalsIgnoreCase(string)) {
                    return new RoleCondition(string2, op);
                }
                if ("index".equalsIgnoreCase(string)) {
                    return new IndexCondition(string2, op);
                }
                throw new MapCSSException(MessageFormat.format("Expected key ''role'' or ''index'' in link context. Got ''{0}''.", string));
            }
        }
        throw new AssertionError();
    }

    public static Condition createRegexpKeyRegexpValueCondition(String string, String string2, Op op) {
        return new RegexpKeyValueRegexpCondition(string, string2, op);
    }

    public static Condition createKeyCondition(String string, boolean bl, KeyMatchType keyMatchType, Condition.Context context) {
        switch (context) {
            case PRIMITIVE: {
                return new KeyCondition(string, bl, keyMatchType);
            }
            case LINK: {
                if (keyMatchType != null) {
                    throw new MapCSSException("Question mark operator ''?'' and regexp match not supported in LINK context");
                }
                if (bl) {
                    return new RoleCondition(string, Op.NEQ);
                }
                return new RoleCondition(string, Op.EQ);
            }
        }
        throw new AssertionError();
    }

    public static PseudoClassCondition createPseudoClassCondition(String string, boolean bl, Condition.Context context) {
        return PseudoClassCondition.createPseudoClassCondition(string, bl, context);
    }

    public static ClassCondition createClassCondition(String string, boolean bl, Condition.Context context) {
        return new ClassCondition(string, bl);
    }

    public static ExpressionCondition createExpressionCondition(Expression expression, Condition.Context context) {
        return new ExpressionCondition(expression);
    }

    public static class ExpressionCondition
    implements Condition {
        final Expression e;

        public ExpressionCondition(Expression expression) {
            this.e = expression;
        }

        @Override
        public boolean applies(Environment environment) {
            Boolean bl = Cascade.convertTo(this.e.evaluate(environment), Boolean.class);
            return bl != null && bl != false;
        }

        public String toString() {
            return '[' + this.e.toString() + ']';
        }
    }

    public static class OpenEndPseudoClassCondition
    extends PseudoClassCondition {
        public OpenEndPseudoClassCondition(boolean bl) {
            super(null, bl);
        }

        @Override
        public boolean applies(Environment environment) {
            return true;
        }
    }

    public static class PseudoClassCondition
    implements Condition {
        final Method method;
        final boolean not;

        protected PseudoClassCondition(Method method, boolean bl) {
            this.method = method;
            this.not = bl;
        }

        public static PseudoClassCondition createPseudoClassCondition(String string, boolean bl, Condition.Context context) {
            CheckParameterUtil.ensureThat(!"sameTags".equals(string) || Condition.Context.LINK.equals((Object)context), "sameTags only supported in LINK context");
            if ("open_end".equals(string)) {
                return new OpenEndPseudoClassCondition(bl);
            }
            Method method = PseudoClassCondition.getMethod(string);
            if (method != null) {
                return new PseudoClassCondition(method, bl);
            }
            throw new MapCSSException("Invalid pseudo class specified: " + string);
        }

        protected static Method getMethod(String string) {
            String string2 = string.replaceAll("-|_", "");
            for (Method method : PseudoClasses.class.getDeclaredMethods()) {
                String string3 = method.getName().replaceAll("-|_", "");
                if (!string3.equalsIgnoreCase(string2)) continue;
                return method;
            }
            return null;
        }

        @Override
        public boolean applies(Environment environment) {
            try {
                return this.not ^ (Boolean)this.method.invoke(null, environment);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                throw new JosmRuntimeException(reflectiveOperationException);
            }
        }

        public String toString() {
            return (this.not ? "!" : "") + ':' + this.method.getName();
        }
    }

    public static final class PseudoClasses {
        private static final Predicate<OsmPrimitive> IN_DOWNLOADED_AREA = new SearchCompiler.InDataSourceArea(false);

        private PseudoClasses() {
        }

        static boolean closed(Environment environment) {
            if (environment.osm instanceof Way && ((Way)environment.osm).isClosed()) {
                return true;
            }
            return environment.osm instanceof Relation && ((Relation)environment.osm).isMultipolygon();
        }

        static boolean modified(Environment environment) {
            return environment.osm.isModified() || environment.osm.isNewOrUndeleted();
        }

        static boolean _new(Environment environment) {
            return environment.osm.isNew();
        }

        static boolean connection(Environment environment) {
            return environment.osm instanceof Node && environment.osm.getDataSet() != null && ((Node)environment.osm).isConnectionNode();
        }

        static boolean tagged(Environment environment) {
            return environment.osm.isTagged();
        }

        static boolean sameTags(Environment environment) {
            return environment.osm.hasSameInterestingTags(Utils.firstNonNull(environment.child, environment.parent));
        }

        static boolean areaStyle(Environment environment) {
            return ElemStyles.hasAreaElemStyle(environment.osm, false);
        }

        static boolean unconnected(Environment environment) {
            return environment.osm instanceof Node && OsmPrimitive.getFilteredList(environment.osm.getReferrers(), Way.class).isEmpty();
        }

        static boolean righthandtraffic(Environment environment) {
            return ExpressionFactory.Functions.is_right_hand_traffic(environment);
        }

        static boolean clockwise(Environment environment) {
            return ExpressionFactory.Functions.is_clockwise(environment);
        }

        static boolean anticlockwise(Environment environment) {
            return ExpressionFactory.Functions.is_anticlockwise(environment);
        }

        static boolean unclosed_multipolygon(Environment environment) {
            return environment.osm instanceof Relation && ((Relation)environment.osm).isMultipolygon() && !environment.osm.isIncomplete() && !((Relation)environment.osm).hasIncompleteMembers() && !MultipolygonCache.getInstance().get(Main.map.mapView, (Relation)environment.osm).getOpenEnds().isEmpty();
        }

        static boolean inDownloadedArea(Environment environment) {
            return IN_DOWNLOADED_AREA.test(environment.osm);
        }

        static boolean completely_downloaded(Environment environment) {
            if (environment.osm instanceof Relation) {
                return !((Relation)environment.osm).hasIncompleteMembers();
            }
            return true;
        }

        static boolean closed2(Environment environment) {
            if (environment.osm instanceof Way && ((Way)environment.osm).isClosed()) {
                return true;
            }
            if (environment.osm instanceof Relation && ((Relation)environment.osm).isMultipolygon()) {
                return MultipolygonCache.getInstance().get(Main.map.mapView, (Relation)environment.osm).getOpenEnds().isEmpty();
            }
            return false;
        }

        static boolean selected(Environment environment) {
            Cascade cascade = environment.mc.getCascade(environment.layer);
            cascade.setDefaultSelectedHandling(false);
            return environment.osm.isSelected();
        }
    }

    public static class ClassCondition
    implements Condition {
        public final String id;
        final boolean not;

        public ClassCondition(String string, boolean bl) {
            this.id = string;
            this.not = bl;
        }

        @Override
        public boolean applies(Environment environment) {
            Cascade cascade = environment.getCascade(environment.layer);
            return cascade != null && this.not ^ cascade.containsKey(this.id);
        }

        public String toString() {
            return (this.not ? "!" : "") + '.' + this.id;
        }
    }

    public static class KeyCondition
    implements Condition,
    Condition.ToTagConvertable {
        public final String label;
        public final boolean negateResult;
        public final KeyMatchType matchType;
        public final Predicate<String> containsPattern;

        public KeyCondition(String string, boolean bl, KeyMatchType keyMatchType) {
            this.label = string;
            this.negateResult = bl;
            this.matchType = keyMatchType == null ? KeyMatchType.EQ : keyMatchType;
            this.containsPattern = KeyMatchType.REGEX.equals((Object)keyMatchType) ? Pattern.compile(string).asPredicate() : null;
        }

        @Override
        public boolean applies(Environment environment) {
            switch (environment.getContext()) {
                case PRIMITIVE: {
                    switch (this.matchType) {
                        case TRUE: {
                            return environment.osm.isKeyTrue(this.label) ^ this.negateResult;
                        }
                        case FALSE: {
                            return environment.osm.isKeyFalse(this.label) ^ this.negateResult;
                        }
                        case REGEX: {
                            return environment.osm.keySet().stream().anyMatch(this.containsPattern) ^ this.negateResult;
                        }
                    }
                    return environment.osm.hasKey(this.label) ^ this.negateResult;
                }
                case LINK: {
                    Utils.ensure(false, "Illegal state: KeyCondition not supported in LINK context", new Object[0]);
                    return false;
                }
            }
            throw new AssertionError();
        }

        @Override
        public Tag asTag(OsmPrimitive osmPrimitive) {
            String string = this.label;
            if (KeyMatchType.REGEX.equals((Object)this.matchType)) {
                string = osmPrimitive.keySet().stream().filter(this.containsPattern).findAny().orElse(string);
            }
            return new Tag(string, osmPrimitive.get(string));
        }

        public String toString() {
            return '[' + (this.negateResult ? "!" : "") + this.label + ']';
        }
    }

    public static enum KeyMatchType {
        EQ,
        TRUE,
        FALSE,
        REGEX;

    }

    public static class IndexCondition
    implements Condition {
        final String index;
        final Op op;

        public IndexCondition(String string, Op op) {
            this.index = string;
            this.op = op;
        }

        @Override
        public boolean applies(Environment environment) {
            if (environment.index == null) {
                return false;
            }
            if (this.index.startsWith("-")) {
                return environment.count != null && this.op.eval(Integer.toString(environment.index - environment.count), this.index);
            }
            return this.op.eval(Integer.toString(environment.index + 1), this.index);
        }
    }

    public static class RoleCondition
    implements Condition {
        final String role;
        final Op op;

        public RoleCondition(String string, Op op) {
            this.role = string;
            this.op = op;
        }

        @Override
        public boolean applies(Environment environment) {
            String string = environment.getRole();
            if (string == null) {
                return false;
            }
            return this.op.eval(string, this.role);
        }
    }

    public static class RegexpKeyValueRegexpCondition
    extends KeyValueRegexpCondition {
        final Pattern keyPattern;

        public RegexpKeyValueRegexpCondition(String string, String string2, Op op) {
            super(string, string2, op, false);
            this.keyPattern = Pattern.compile(string);
        }

        @Override
        protected boolean matches(Environment environment) {
            for (Map.Entry<String, String> entry : environment.osm.getKeys().entrySet()) {
                if (!this.keyPattern.matcher(entry.getKey()).find() || !this.pattern.matcher(entry.getValue()).find()) continue;
                return true;
            }
            return false;
        }
    }

    public static class KeyValueRegexpCondition
    extends KeyValueCondition {
        protected static final Set<Op> SUPPORTED_OPS = EnumSet.of(Op.REGEX, Op.NREGEX);
        final Pattern pattern;

        public KeyValueRegexpCondition(String string, String string2, Op op, boolean bl) {
            super(string, string2, op, bl);
            CheckParameterUtil.ensureThat(!bl, "considerValAsKey is not supported");
            CheckParameterUtil.ensureThat(SUPPORTED_OPS.contains((Object)op), "Op must be REGEX or NREGEX");
            this.pattern = Pattern.compile(string2);
        }

        protected boolean matches(Environment environment) {
            String string = environment.osm.get(this.k);
            return string != null && this.pattern.matcher(string).find();
        }

        @Override
        public boolean applies(Environment environment) {
            if (Op.REGEX.equals((Object)this.op)) {
                return this.matches(environment);
            }
            if (Op.NREGEX.equals((Object)this.op)) {
                return !this.matches(environment);
            }
            throw new IllegalStateException();
        }
    }

    public static class KeyValueCondition
    implements Condition,
    Condition.ToTagConvertable {
        public final String k;
        public final String v;
        public final Op op;
        public final boolean considerValAsKey;

        public KeyValueCondition(String string, String string2, Op op, boolean bl) {
            this.k = string;
            this.v = string2;
            this.op = op;
            this.considerValAsKey = bl;
        }

        @Override
        public boolean applies(Environment environment) {
            return this.op.eval(environment.osm.get(this.k), this.considerValAsKey ? environment.osm.get(this.v) : this.v);
        }

        @Override
        public Tag asTag(OsmPrimitive osmPrimitive) {
            return new Tag(this.k, this.v);
        }

        public String toString() {
            return '[' + this.k + '\'' + (Object)((Object)this.op) + '\'' + this.v + ']';
        }
    }

    public static class SimpleKeyValueCondition
    implements Condition,
    Condition.ToTagConvertable {
        public final String k;
        public final String v;

        public SimpleKeyValueCondition(String string, String string2) {
            this.k = string;
            this.v = string2;
        }

        @Override
        public boolean applies(Environment environment) {
            return this.v.equals(environment.osm.get(this.k));
        }

        @Override
        public Tag asTag(OsmPrimitive osmPrimitive) {
            return new Tag(this.k, this.v);
        }

        public String toString() {
            return '[' + this.k + '=' + this.v + ']';
        }
    }

    public static enum Op {
        EQ(Objects::equals),
        NEQ(EQ),
        GREATER_OR_EQUAL(n -> n >= 0),
        GREATER(n -> n > 0),
        LESS_OR_EQUAL(n -> n <= 0),
        LESS(n -> n < 0),
        REGEX((string, string2) -> Pattern.compile(string2).matcher((CharSequence)string).find()),
        NREGEX(REGEX),
        ONE_OF((string, string2) -> Arrays.asList(string.split("\\s*;\\s*")).contains(string2)),
        BEGINS_WITH(String::startsWith),
        ENDS_WITH(String::endsWith),
        CONTAINS(String::contains);

        static final Set<Op> NEGATED_OPS;
        private final BiFunction<String, String, Boolean> function;
        private final boolean negated;

        private Op(BiFunction<String, String, Boolean> biFunction) {
            this.function = biFunction;
            this.negated = false;
        }

        private Op(IntFunction<Boolean> intFunction) {
            this.function = (string, string2) -> {
                float f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                float f2 = Float.parseFloat(string2);
                int n = Float.compare(f, f2);
                return (Boolean)intFunction.apply(n);
            };
            this.negated = false;
        }

        private Op(Op op) {
            this.function = (string, string2) -> op.function.apply((String)string, (String)string2) == false;
            this.negated = true;
        }

        public boolean eval(String string, String string2) {
            if (string == null) {
                return this.negated;
            }
            return this.function.apply(string, string2);
        }

        static {
            NEGATED_OPS = EnumSet.of(NEQ, NREGEX);
        }
    }
}

