/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.io.OsmApiException;

public class OsmApiPrimitiveGoneException
extends OsmApiException {
    public static final String ERROR_HEADER_PATTERN = "The (\\S+) with the id (\\d+) has already been deleted";
    private final OsmPrimitiveType type;
    private final long id;

    public OsmApiPrimitiveGoneException(String string, String string2) {
        super(410, string, string2);
        if (string != null) {
            Matcher matcher = Pattern.compile(ERROR_HEADER_PATTERN).matcher(string);
            if (matcher.matches()) {
                this.type = OsmPrimitiveType.from(matcher.group(1));
                this.id = Long.parseLong(matcher.group(2));
            } else {
                this.type = null;
                this.id = 0L;
            }
        } else {
            this.type = null;
            this.id = 0L;
        }
    }

    public boolean isKnownPrimitive() {
        return this.id > 0L && this.type != null;
    }

    public OsmPrimitiveType getPrimitiveType() {
        return this.type;
    }

    public long getPrimitiveId() {
        return this.id;
    }
}

