/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.tools.callgraph;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.truffle.language.methods.SharedMethodInfo;
import org.jruby.truffle.tools.callgraph.CallGraph;
import org.jruby.truffle.tools.callgraph.CallSite;
import org.jruby.truffle.tools.callgraph.MethodVersion;

public class Method {
    private final CallGraph callGraph;
    private final SharedMethodInfo sharedInfo;
    private final List<MethodVersion> versions = new ArrayList<MethodVersion>();
    private final Map<SourceSection, CallSite> callSites = new HashMap<SourceSection, CallSite>();

    public Method(CallGraph callGraph, SharedMethodInfo sharedInfo) {
        this.callGraph = callGraph;
        this.sharedInfo = sharedInfo;
    }

    public List<MethodVersion> getVersions() {
        return this.versions;
    }

    public SharedMethodInfo getSharedInfo() {
        return this.sharedInfo;
    }

    public Map<SourceSection, CallSite> getCallSites() {
        return this.callSites;
    }

    public CallSite getCallSite(Node node) {
        SourceSection sourceSection = node.getEncapsulatingSourceSection();
        CallSite callSite = this.callSites.get(sourceSection);
        if (callSite == null) {
            callSite = new CallSite(this, sourceSection);
            this.callSites.put(sourceSection, callSite);
        }
        return callSite;
    }

    public CallGraph getCallGraph() {
        return this.callGraph;
    }
}

