/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.tools.I18n;

public class WayConnectedToArea
extends Test {
    public WayConnectedToArea() {
        super(I18n.tr("Way connected to Area", new Object[0]), I18n.tr("Checks for ways connected to areas.", new Object[0]));
    }

    @Override
    public void visit(Way way) {
        if (!way.isUsable() || way.isClosed() || !way.hasKey("highway")) {
            return;
        }
        boolean bl = false;
        List<OsmPrimitive> list = way.firstNode().getReferrers();
        for (OsmPrimitive osmPrimitive : list) {
            if (osmPrimitive == way || !osmPrimitive.hasKey("highway")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (OsmPrimitive osmPrimitive : list) {
                this.testForError(way, way.firstNode(), osmPrimitive);
            }
        }
        bl = false;
        list = way.lastNode().getReferrers();
        for (OsmPrimitive osmPrimitive : list) {
            if (osmPrimitive == way || !osmPrimitive.hasKey("highway")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (OsmPrimitive osmPrimitive : list) {
                this.testForError(way, way.lastNode(), osmPrimitive);
            }
        }
    }

    private void testForError(Way way, Node node, OsmPrimitive osmPrimitive2) {
        if (node.isOutsideDownloadArea()) {
            return;
        }
        if (node.getReferrers().stream().anyMatch(osmPrimitive -> osmPrimitive.hasTag("route", "ferry"))) {
            return;
        }
        if (WayConnectedToArea.isArea(osmPrimitive2)) {
            this.addPossibleError(way, node, osmPrimitive2, osmPrimitive2);
        } else {
            for (OsmPrimitive osmPrimitive3 : osmPrimitive2.getReferrers()) {
                if (!(osmPrimitive3 instanceof Relation) || !osmPrimitive3.hasTag("type", "multipolygon") || !WayConnectedToArea.isArea(osmPrimitive3)) continue;
                this.addPossibleError(way, node, osmPrimitive2, osmPrimitive3);
                break;
            }
        }
    }

    private static boolean isArea(OsmPrimitive osmPrimitive) {
        return (osmPrimitive.hasKey("landuse") || osmPrimitive.hasKey("natural")) && ElemStyles.hasAreaElemStyle(osmPrimitive, false);
    }

    private void addPossibleError(Way way, Node node, OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        if (way.hasKey("highway") && node.hasTag("leisure", "slipway") && osmPrimitive2.hasTag("natural", "water")) {
            return;
        }
        this.errors.add(TestError.builder(this, Severity.WARNING, 2301).message(I18n.tr("Way terminates on Area", new Object[0])).primitives(way, osmPrimitive).highlight(node).build());
    }
}

