/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.config;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.jnlp.config.BasicValueValidators;
import net.sourceforge.jnlp.config.PathsAndFiles;
import net.sourceforge.jnlp.config.SecurityValueValidator;
import net.sourceforge.jnlp.config.Setting;
import net.sourceforge.jnlp.config.ValueValidator;
import net.sourceforge.jnlp.runtime.ManifestAttributesChecker;
import net.sourceforge.jnlp.runtime.Translator;

public class Defaults {
    public static Map<String, Setting<String>> getDefaults() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkRead(PathsAndFiles.USER_DEPLOYMENT_FILE.getDefaultFullPath());
            sm.checkRead(PathsAndFiles.USER_DEPLOYMENT_FILE.getFullPath());
        }
        Object[][] defaults = new Object[][]{{"deployment.user.cachedir", BasicValueValidators.getFilePathValidator(), PathsAndFiles.CACHE_DIR.getDefaultFullPath()}, {"deployment.user.pcachedir", BasicValueValidators.getFilePathValidator(), PathsAndFiles.PCACHE_DIR.getDefaultFullPath()}, {"deployment.system.cachedir", BasicValueValidators.getFilePathValidator(), null}, {"deployment.user.logdir", BasicValueValidators.getFilePathValidator(), PathsAndFiles.LOG_DIR.getDefaultFullPath()}, {"deployment.user.tmp", BasicValueValidators.getFilePathValidator(), PathsAndFiles.TMP_DIR.getDefaultFullPath()}, {"deployment.user.locksdir", BasicValueValidators.getFilePathValidator(), PathsAndFiles.LOCKS_DIR.getDefaultFullPath()}, {"deployment.user.runningfile", BasicValueValidators.getFilePathValidator(), PathsAndFiles.MAIN_LOCK.getDefaultFullPath()}, {"deployment.user.security.policy", BasicValueValidators.getUrlValidator(), "file://" + PathsAndFiles.JAVA_POLICY.getDefaultFullPath()}, {"deployment.user.security.trusted.cacerts", BasicValueValidators.getFilePathValidator(), PathsAndFiles.USER_CACERTS.getDefaultFullPath()}, {"deployment.user.security.trusted.jssecacerts", BasicValueValidators.getFilePathValidator(), PathsAndFiles.USER_JSSECAC.getDefaultFullPath()}, {"deployment.user.security.trusted.certs", BasicValueValidators.getFilePathValidator(), PathsAndFiles.USER_CERTS.getDefaultFullPath()}, {"deployment.user.security.trusted.jssecerts", BasicValueValidators.getFilePathValidator(), PathsAndFiles.USER_JSSECER.getDefaultFullPath()}, {"deployment.user.security.trusted.clientauthcerts", BasicValueValidators.getFilePathValidator(), PathsAndFiles.USER_CLIENTCERT.getDefaultFullPath()}, {"deployment.system.security.policy", BasicValueValidators.getUrlValidator(), null}, {"deployment.system.security.cacerts", BasicValueValidators.getFilePathValidator(), PathsAndFiles.SYS_CACERT.getDefaultFullPath()}, {"deployment.system.security.jssecacerts", BasicValueValidators.getFilePathValidator(), PathsAndFiles.SYS_JSSECAC.getDefaultFullPath()}, {"deployment.system.security.trusted.certs", BasicValueValidators.getFilePathValidator(), PathsAndFiles.SYS_CERT.getDefaultFullPath()}, {"deployment.system.security.trusted.jssecerts", BasicValueValidators.getFilePathValidator(), PathsAndFiles.SYS_JSSECERT.getDefaultFullPath()}, {"deployment.system.security.trusted.clientautcerts", BasicValueValidators.getFilePathValidator(), PathsAndFiles.SYS_CLIENTCERT.getDefaultFullPath()}, {"deployment.security.askgrantdialog.show", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.askgrantdialog.notinca", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.notinca.warning", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.expired.warning", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.jsse.hostmismatch.warning", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.trusted.policy", BasicValueValidators.getFilePathValidator(), null}, {"deployment.security.sandbox.awtwarningwindow", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.sandbox.jnlp.enhanced", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.jnlpclassloader.strict", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.security.sandbox.jnlp.enhanced", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.proxy.type", BasicValueValidators.getRangedIntegerValidator(-1, 3), String.valueOf(3)}, {"deployment.proxy.same", BasicValueValidators.getBooleanValidator(), String.valueOf(false)}, {"deployment.proxy.auto.config.url", BasicValueValidators.getUrlValidator(), null}, {"deployment.proxy.bypass.list", null, null}, {"deployment.proxy.bypass.local", null, null}, {"deployment.proxy.http.host", null, null}, {"deployment.proxy.http.port", null, null}, {"deployment.proxy.https.host", null, null}, {"deployment.proxy.https.port", null, null}, {"deployment.proxy.ftp.host", null, null}, {"deployment.proxy.ftp.port", null, null}, {"deployment.proxy.socks.host", null, null}, {"deployment.proxy.socks.port", null, null}, {"deployment.proxy.override.hosts", null, null}, {"deployment.cache.max.size", BasicValueValidators.getRangedIntegerValidator(-1, Integer.MAX_VALUE), String.valueOf("-1")}, {"deployment.cache.jarcompression", BasicValueValidators.getRangedIntegerValidator(0, 10), String.valueOf(0)}, {"deployment.javapi.cache.enabled", BasicValueValidators.getBooleanValidator(), String.valueOf(false)}, {"deployment.console.startup.mode", BasicValueValidators.getStringValidator(new String[]{"DISABLE", "HIDE", "SHOW", "SHOW_PLUGIN_ONLY", "SHOW_JAVAWS_ONLY"}), "HIDE"}, {"deployment.log", BasicValueValidators.getBooleanValidator(), String.valueOf(false)}, {"deployment.log.headers", BasicValueValidators.getBooleanValidator(), String.valueOf(false)}, {"deployment.log.file", BasicValueValidators.getBooleanValidator(), String.valueOf(false)}, {"deployment.log.file.clientapp", BasicValueValidators.getBooleanValidator(), String.valueOf(false)}, {"deployment.log.file.legacylog", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.log.stdstreams", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.log.system", BasicValueValidators.getBooleanValidator(), String.valueOf(true)}, {"deployment.javaws.associations", BasicValueValidators.getRangedIntegerValidator(0, 3), String.valueOf(2)}, {"deployment.javaws.shortcut", BasicValueValidators.getStringValidator(new String[]{"ALWAYS", "ALWAYS_IF_HINTED", "ASK_USER", "ASK_IF_HINTED", "NEVER"}), "ASK_IF_HINTED"}, {"deployment.javaws.installURL", BasicValueValidators.getUrlValidator(), null}, {"deployment.javaws.autodownload", BasicValueValidators.getBooleanValidator(), String.valueOf(false)}, {"deployment.browser.path", BasicValueValidators.getFilePathValidator(), null}, {"deployment.javaws.update.timeout", BasicValueValidators.getRangedIntegerValidator(0, 10000), String.valueOf(500)}, {"deployment.plugin.jvm.arguments", null, null}, {"deployment.security.level", new SecurityValueValidator(), null}, {"deployment.jre.dir", null, null}, {"deployment.manifest.attributes.check", BasicValueValidators.getManifestAttributeCheckValidator(), String.valueOf((Object)ManifestAttributesChecker.MANIFEST_ATTRIBUTES_CHECK.ALL)}};
        HashMap<String, Setting<String>> result = new HashMap<String, Setting<String>>();
        for (Object[] default1 : defaults) {
            String name = (String)default1[0];
            ValueValidator checker = (ValueValidator)default1[1];
            String actualValue = (String)default1[2];
            boolean locked = false;
            Setting<String> value = new Setting<String>(name, Translator.R("Unknown"), locked, checker, actualValue, actualValue, Translator.R("DCSourceInternal"));
            result.put(name, value);
        }
        return result;
    }
}

