/*
 *  This file is part of the WebKit open source project.
 *  This file has been generated by generate-bindings.pl. DO NOT MODIFY!
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef WebKitDOMStorage_h
#define WebKitDOMStorage_h

#ifdef WEBKIT_DOM_USE_UNSTABLE_API

#include <glib-object.h>
#include <webkitdom/WebKitDOMObject.h>
#include <webkitdom/webkitdomdefines-unstable.h>

G_BEGIN_DECLS

#define WEBKIT_DOM_TYPE_STORAGE            (webkit_dom_storage_get_type())
#define WEBKIT_DOM_STORAGE(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), WEBKIT_DOM_TYPE_STORAGE, WebKitDOMStorage))
#define WEBKIT_DOM_STORAGE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),  WEBKIT_DOM_TYPE_STORAGE, WebKitDOMStorageClass)
#define WEBKIT_DOM_IS_STORAGE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), WEBKIT_DOM_TYPE_STORAGE))
#define WEBKIT_DOM_IS_STORAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),  WEBKIT_DOM_TYPE_STORAGE))
#define WEBKIT_DOM_STORAGE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),  WEBKIT_DOM_TYPE_STORAGE, WebKitDOMStorageClass))

struct _WebKitDOMStorage {
    WebKitDOMObject parent_instance;
};

struct _WebKitDOMStorageClass {
    WebKitDOMObjectClass parent_class;
};

WEBKIT_API GType
webkit_dom_storage_get_type(void);

/**
 * webkit_dom_storage_key:
 * @self: A #WebKitDOMStorage
 * @index: A #gulong
 * @error: #GError
 *
 * Returns: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API gchar*
webkit_dom_storage_key(WebKitDOMStorage* self, gulong index, GError** error);

/**
 * webkit_dom_storage_get_item:
 * @self: A #WebKitDOMStorage
 * @key: A #gchar
 * @error: #GError
 *
 * Returns: A #gchar
 *
 * Stability: Unstable
**/
WEBKIT_API gchar*
webkit_dom_storage_get_item(WebKitDOMStorage* self, const gchar* key, GError** error);

/**
 * webkit_dom_storage_set_item:
 * @self: A #WebKitDOMStorage
 * @key: A #gchar
 * @data: A #gchar
 * @error: #GError
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_storage_set_item(WebKitDOMStorage* self, const gchar* key, const gchar* data, GError** error);

/**
 * webkit_dom_storage_remove_item:
 * @self: A #WebKitDOMStorage
 * @key: A #gchar
 * @error: #GError
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_storage_remove_item(WebKitDOMStorage* self, const gchar* key, GError** error);

/**
 * webkit_dom_storage_clear:
 * @self: A #WebKitDOMStorage
 * @error: #GError
 *
 * Stability: Unstable
**/
WEBKIT_API void
webkit_dom_storage_clear(WebKitDOMStorage* self, GError** error);

/**
 * webkit_dom_storage_get_length:
 * @self: A #WebKitDOMStorage
 * @error: #GError
 *
 * Returns: A #gulong
 *
 * Stability: Unstable
**/
WEBKIT_API gulong
webkit_dom_storage_get_length(WebKitDOMStorage* self, GError** error);

G_END_DECLS

#endif /* WEBKIT_DOM_USE_UNSTABLE_API */
#endif /* WebKitDOMStorage_h */
