/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;
import org.apache.tomcat.util.compat.Jre7Compat;

class Jre8Compat
extends Jre7Compat {
    private static final Method getSSLParametersMethod;
    private static final Method getSSLParametersEngineMethod;
    private static final Method setUseCipherSuitesOrderMethod;
    private static final Method setSSLParametersMethod;
    private static final Method setSSLParametersEngineMethod;

    Jre8Compat() {
    }

    static boolean isSupported() {
        return setUseCipherSuitesOrderMethod != null;
    }

    public void setUseServerCipherSuitesOrder(SSLServerSocket socket, boolean useCipherSuitesOrder) {
        try {
            Object sslParameters = getSSLParametersMethod.invoke((Object)socket, new Object[0]);
            setUseCipherSuitesOrderMethod.invoke(sslParameters, useCipherSuitesOrder);
            setSSLParametersMethod.invoke((Object)socket, sslParameters);
            return;
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public void setUseServerCipherSuitesOrder(SSLEngine engine, boolean useCipherSuitesOrder) {
        try {
            Object sslParameters = getSSLParametersEngineMethod.invoke((Object)engine, new Object[0]);
            setUseCipherSuitesOrderMethod.invoke(sslParameters, useCipherSuitesOrder);
            setSSLParametersEngineMethod.invoke((Object)engine, sslParameters);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    static {
        Method m1 = null;
        Method m2 = null;
        Method m3 = null;
        Method m4 = null;
        Method m5 = null;
        try {
            m1 = SSLServerSocket.class.getMethod("getSSLParameters", new Class[0]);
            m2 = SSLEngine.class.getMethod("getSSLParameters", new Class[0]);
            m3 = sslParametersClass.getMethod("setUseCipherSuitesOrder", Boolean.TYPE);
            m4 = SSLServerSocket.class.getMethod("setSSLParameters", sslParametersClass);
            m5 = SSLEngine.class.getMethod("setSSLParameters", sslParametersClass);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        getSSLParametersMethod = m1;
        getSSLParametersEngineMethod = m2;
        setUseCipherSuitesOrderMethod = m3;
        setSSLParametersMethod = m4;
        setSSLParametersEngineMethod = m5;
    }
}

