/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.initializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.JsReservedIdentifiers;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNew;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsParameter;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.declaration.DelegationTranslator;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.initializer.InitializerUtils;
import org.jetbrains.kotlin.js.translate.initializer.InitializerVisitor;
import org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.jsAstUtils.AstUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.types.KotlinType;

public final class ClassInitializerTranslator
extends AbstractTranslator {
    @NotNull
    private final KtClassOrObject classDeclaration;
    @NotNull
    private final JsFunction initFunction;
    private final TranslationContext context;

    public ClassInitializerTranslator(@NotNull KtClassOrObject classDeclaration, @NotNull TranslationContext context) {
        if (classDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDeclaration", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "<init>"));
        }
        super(context);
        this.classDeclaration = classDeclaration;
        this.initFunction = ClassInitializerTranslator.createInitFunction(classDeclaration, context);
        this.context = context.contextWithScope(this.initFunction);
    }

    @Override
    @NotNull
    protected TranslationContext context() {
        TranslationContext translationContext = this.context;
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "context"));
        }
        return translationContext;
    }

    @NotNull
    private static JsFunction createInitFunction(KtClassOrObject declaration, TranslationContext context) {
        Name name2;
        ClassDescriptor classDescriptor = BindingUtils.getClassDescriptor(context.bindingContext(), declaration);
        ClassConstructorDescriptor primaryConstructor2 = classDescriptor.getUnsubstitutedPrimaryConstructor();
        String functionName = AnnotationsUtils.getJsName(classDescriptor);
        if (functionName == null && !(name2 = classDescriptor.getName()).isSpecial()) {
            functionName = name2.asString();
        }
        JsFunction ctorFunction = primaryConstructor2 != null ? context.getFunctionObject(primaryConstructor2) : new JsFunction(context.scope(), new JsBlock(), "fake constructor for " + functionName);
        if (functionName != null) {
            if (JsReservedIdentifiers.reservedGlobalSymbols.contains(functionName) || JsFunctionScope.Companion.getRESERVED_WORDS().contains(functionName)) {
                functionName = functionName + "$";
            }
            ctorFunction.setName(ctorFunction.getScope().declareName(functionName));
        }
        JsFunction jsFunction = ctorFunction;
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "createInitFunction"));
        }
        return jsFunction;
    }

    @NotNull
    public JsFunction generateInitializeMethod(DelegationTranslator delegationTranslator) {
        ClassDescriptor classDescriptor = BindingUtils.getClassDescriptor(this.bindingContext(), this.classDeclaration);
        this.addOuterClassReference(classDescriptor);
        ClassConstructorDescriptor primaryConstructor2 = classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (primaryConstructor2 != null) {
            this.initFunction.getBody().getStatements().addAll(FunctionBodyTranslator.setDefaultValueForArguments(primaryConstructor2, this.context()));
            this.mayBeAddCallToSuperMethod(this.initFunction, classDescriptor);
            this.initFunction.getParameters().addAll(this.translatePrimaryConstructorParameters());
        }
        delegationTranslator.addInitCode(this.initFunction.getBody().getStatements());
        new InitializerVisitor().traverseContainer(this.classDeclaration, this.context().innerBlock(this.initFunction.getBody()));
        JsFunction jsFunction = this.initFunction;
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "generateInitializeMethod"));
        }
        return jsFunction;
    }

    private void addOuterClassReference(ClassDescriptor classDescriptor) {
        JsName outerName = this.context.getOuterClassReference(classDescriptor);
        if (outerName == null) {
            return;
        }
        this.initFunction.getParameters().add(0, new JsParameter(outerName));
        JsNameRef paramRef = JsAstUtils.pureFqn(outerName, null);
        JsBinaryOperation assignment = JsAstUtils.assignment(JsAstUtils.pureFqn(outerName, (JsExpression)JsLiteral.THIS), paramRef);
        this.initFunction.getBody().getStatements().add(new JsExpressionStatement(assignment));
    }

    @NotNull
    public JsExpression generateEnumEntryInstanceCreation(@NotNull KotlinType enumClassType) {
        if (enumClassType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassType", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "generateEnumEntryInstanceCreation"));
        }
        ResolvedCall<FunctionDescriptor> superCall = BindingUtils.getSuperCall(this.bindingContext(), this.classDeclaration);
        if (superCall == null) {
            ClassDescriptor classDescriptor = DescriptorUtils.getClassDescriptorForType(enumClassType);
            JsNameRef reference = this.context().getQualifiedReference(classDescriptor);
            JsNew jsNew = new JsNew(reference);
            if (jsNew == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "generateEnumEntryInstanceCreation"));
            }
            return jsNew;
        }
        JsExpression jsExpression = CallTranslator.translate(this.context(), superCall);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "generateEnumEntryInstanceCreation"));
        }
        return jsExpression;
    }

    private void mayBeAddCallToSuperMethod(JsFunction initializer2, @NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "mayBeAddCallToSuperMethod"));
        }
        if (this.classDeclaration.hasModifier(KtTokens.ENUM_KEYWORD)) {
            this.addCallToSuperMethod(Collections.<JsExpression>emptyList(), initializer2);
        } else if (BindingUtils.hasAncestorClass(this.bindingContext(), this.classDeclaration)) {
            ResolvedCall<FunctionDescriptor> superCall = BindingUtils.getSuperCall(this.bindingContext(), this.classDeclaration);
            if (superCall == null) {
                if (DescriptorUtils.isEnumEntry(descriptor2)) {
                    this.addCallToSuperMethod(Collections.<JsExpression>emptyList(), initializer2);
                }
                return;
            }
            if (this.classDeclaration instanceof KtEnumEntry) {
                JsExpression expression = CallTranslator.translate(this.context(), superCall, null);
                JsExpression fixedInvocation = AstUtilsKt.toInvocationWith(expression, Collections.emptyList(), 0, JsLiteral.THIS);
                this.initFunction.getBody().getStatements().add(fixedInvocation.makeStmt());
            } else {
                ArrayList<JsExpression> arguments2 = new ArrayList<JsExpression>();
                ConstructorDescriptor superDescriptor = (ConstructorDescriptor)superCall.getResultingDescriptor();
                List<DeclarationDescriptor> superclassClosure = this.context.getClassOrConstructorClosure(superDescriptor);
                if (superclassClosure != null) {
                    UsageTracker tracker = this.context.usageTracker();
                    assert (tracker != null) : "Closure exists, therefore UsageTracker must exist too. Translating constructor of " + descriptor2;
                    for (DeclarationDescriptor capturedValue : superclassClosure) {
                        tracker.used(capturedValue);
                        arguments2.add(tracker.getCapturedDescriptorToJsName().get(capturedValue).makeRef());
                    }
                }
                if (superDescriptor.getContainingDeclaration().isInner() && descriptor2.isInner()) {
                    arguments2.add(JsAstUtils.pureFqn("$outer", (JsExpression)JsLiteral.THIS));
                }
                if (!DescriptorUtils.isAnonymousObject(descriptor2)) {
                    arguments2.addAll(CallArgumentTranslator.translate(superCall, null, this.context()).getTranslateArguments());
                } else {
                    for (ValueParameterDescriptor parameter : superDescriptor.getValueParameters()) {
                        JsName parameterName = this.context.getNameForDescriptor(parameter);
                        arguments2.add(parameterName.makeRef());
                        initializer2.getParameters().add(new JsParameter(parameterName));
                    }
                }
                if (superDescriptor.isPrimary()) {
                    this.addCallToSuperMethod(arguments2, initializer2);
                } else {
                    int maxValueArgumentIndex = 0;
                    for (ValueParameterDescriptor arg : superCall.getValueArguments().keySet()) {
                        ResolvedValueArgument resolvedArg = superCall.getValueArguments().get(arg);
                        if (resolvedArg instanceof DefaultValueArgument) continue;
                        maxValueArgumentIndex = Math.max(maxValueArgumentIndex, arg.getIndex() + 1);
                    }
                    int padSize = superDescriptor.getValueParameters().size() - maxValueArgumentIndex;
                    while (padSize-- > 0) {
                        arguments2.add(Namer.getUndefinedExpression());
                    }
                    this.addCallToSuperSecondaryConstructor(arguments2, superDescriptor);
                }
            }
        }
    }

    private void addCallToSuperMethod(@NotNull List<JsExpression> arguments2, JsFunction initializer2) {
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "addCallToSuperMethod"));
        }
        if (initializer2.getName() == null) {
            JsName ref = this.context().scope().declareName("$fun");
            initializer2.setName(ref);
        }
        JsInvocation call = new JsInvocation((JsExpression)Namer.getFunctionCallRef(Namer.superMethodNameRef(initializer2.getName())), new JsExpression[0]);
        call.getArguments().add(JsLiteral.THIS);
        call.getArguments().addAll(arguments2);
        this.initFunction.getBody().getStatements().add(call.makeStmt());
    }

    private void addCallToSuperSecondaryConstructor(@NotNull List<JsExpression> arguments2, @NotNull ConstructorDescriptor descriptor2) {
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "addCallToSuperSecondaryConstructor"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "addCallToSuperSecondaryConstructor"));
        }
        JsNameRef reference = this.context.getQualifiedReference(descriptor2);
        JsInvocation call = new JsInvocation((JsExpression)reference, new JsExpression[0]);
        call.getArguments().addAll(arguments2);
        call.getArguments().add(JsLiteral.THIS);
        this.initFunction.getBody().getStatements().add(call.makeStmt());
    }

    @NotNull
    private List<JsParameter> translatePrimaryConstructorParameters() {
        List<KtParameter> parameterList = PsiUtils.getPrimaryConstructorParameters(this.classDeclaration);
        ArrayList<JsParameter> result2 = new ArrayList<JsParameter>();
        for (KtParameter jetParameter : parameterList) {
            result2.add(this.translateParameter(jetParameter));
        }
        ArrayList<JsParameter> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "translatePrimaryConstructorParameters"));
        }
        return arrayList;
    }

    @NotNull
    private JsParameter translateParameter(@NotNull KtParameter jetParameter) {
        if (jetParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetParameter", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "translateParameter"));
        }
        DeclarationDescriptor parameterDescriptor = BindingUtils.getDescriptorForElement(this.bindingContext(), jetParameter);
        JsName parameterName = this.context().getNameForDescriptor(parameterDescriptor);
        JsParameter jsParameter = new JsParameter(parameterName);
        this.mayBeAddInitializerStatementForProperty(jsParameter, jetParameter);
        JsParameter jsParameter2 = jsParameter;
        if (jsParameter2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "translateParameter"));
        }
        return jsParameter2;
    }

    private void mayBeAddInitializerStatementForProperty(@NotNull JsParameter jsParameter, @NotNull KtParameter jetParameter) {
        if (jsParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsParameter", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "mayBeAddInitializerStatementForProperty"));
        }
        if (jetParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetParameter", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "mayBeAddInitializerStatementForProperty"));
        }
        PropertyDescriptor propertyDescriptor = BindingUtils.getPropertyDescriptorForConstructorParameter(this.bindingContext(), jetParameter);
        if (propertyDescriptor == null) {
            return;
        }
        JsNameRef initialValueForProperty = jsParameter.getName().makeRef();
        this.addInitializerOrPropertyDefinition(initialValueForProperty, propertyDescriptor);
    }

    private void addInitializerOrPropertyDefinition(@NotNull JsNameRef initialValue, @NotNull PropertyDescriptor propertyDescriptor) {
        if (initialValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialValue", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "addInitializerOrPropertyDefinition"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/js/translate/initializer/ClassInitializerTranslator", "addInitializerOrPropertyDefinition"));
        }
        this.initFunction.getBody().getStatements().add(InitializerUtils.generateInitializerForProperty(this.context(), propertyDescriptor, initialValue));
    }
}

