/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.math.ec.ECPoint;

public class ECDHPublicBCPGKey
extends ECPublicBCPGKey {
    private byte reserved;
    private byte hashFunctionId;
    private byte symAlgorithmId;

    public ECDHPublicBCPGKey(BCPGInputStream bCPGInputStream) throws IOException {
        super(bCPGInputStream);
        int n = bCPGInputStream.read();
        byte[] byArray = new byte[n];
        if (byArray.length != 3) {
            throw new IllegalStateException("kdf parameters size of 3 expected.");
        }
        bCPGInputStream.read(byArray);
        this.reserved = byArray[0];
        this.hashFunctionId = byArray[1];
        this.symAlgorithmId = byArray[2];
        this.verifyHashAlgorithm();
        this.verifySymmetricKeyAlgorithm();
    }

    public ECDHPublicBCPGKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, ECPoint eCPoint, int n, int n2) {
        super(aSN1ObjectIdentifier, eCPoint);
        this.reserved = 1;
        this.hashFunctionId = (byte)n;
        this.symAlgorithmId = (byte)n2;
        this.verifyHashAlgorithm();
        this.verifySymmetricKeyAlgorithm();
    }

    public byte getReserved() {
        return this.reserved;
    }

    public byte getHashAlgorithm() {
        return this.hashFunctionId;
    }

    public byte getSymmetricKeyAlgorithm() {
        return this.symAlgorithmId;
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        super.encode(bCPGOutputStream);
        bCPGOutputStream.write(3);
        bCPGOutputStream.write(this.reserved);
        bCPGOutputStream.write(this.hashFunctionId);
        bCPGOutputStream.write(this.symAlgorithmId);
    }

    private void verifyHashAlgorithm() {
        switch (this.hashFunctionId) {
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            default: {
                throw new IllegalStateException("Hash algorithm must be SHA-256 or stronger.");
            }
        }
    }

    private void verifySymmetricKeyAlgorithm() {
        switch (this.symAlgorithmId) {
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            default: {
                throw new IllegalStateException("Symmetric key algorithm must be AES-128 or stronger.");
            }
        }
    }
}

